/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ClipIntersectsFeatureCollection;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.data.DataAccess;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ReTypingFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.ClippedFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.PropertyName;

public class SecuredFeatureSource<T extends FeatureType, F extends Feature>
extends DecoratingFeatureSource<T, F> {
    static final Logger LOGGER = Logging.getLogger(SecuredFeatureSource.class);
    WrapperPolicy policy;

    protected SecuredFeatureSource(FeatureSource<T, F> delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public DataAccess<T, F> getDataStore() {
        DataAccess store = ((FeatureSource)this.delegate).getDataStore();
        if (store == null) {
            return null;
        }
        return SecuredObjects.secure(store, this.policy);
    }

    @Override
    public FeatureCollection<T, F> getFeatures() throws IOException {
        FeatureCollection fc = ((FeatureSource)this.delegate).getFeatures(this.getReadQuery());
        if (fc == null) {
            return null;
        }
        return SecuredObjects.secure(fc, this.policy);
    }

    @Override
    public FeatureCollection<T, F> getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(null, filter));
    }

    @Override
    public FeatureCollection<T, F> getFeatures(Query query) throws IOException {
        AccessLimits limits;
        Query readQuery = this.getReadQuery();
        Query mixed = this.mixQueries(query, readQuery);
        int limitedAttributeSize = mixed.getProperties() != null ? mixed.getProperties().size() : 0;
        FeatureCollection fc = ((FeatureSource)this.delegate).getFeatures(mixed);
        FeatureCollection result = null;
        if (fc != null) {
            if (limitedAttributeSize > 0 && fc.getSchema().getDescriptors().size() > limitedAttributeSize) {
                if (fc instanceof SimpleFeatureCollection) {
                    SimpleFeatureCollection sfc = (SimpleFeatureCollection)fc;
                    SimpleFeatureType target = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)((SimpleFeatureType)sfc.getSchema()), (String[])mixed.getPropertyNames());
                    ReTypingFeatureCollection retyped = new ReTypingFeatureCollection(sfc, target);
                    result = (FeatureCollection)SecuredObjects.secure(retyped, this.policy);
                } else {
                    List readProps = readQuery.getProperties();
                    List queryProps = query.getProperties();
                    if (!(readProps == null || queryProps != null && readProps.containsAll(queryProps))) {
                        LOGGER.log(Level.SEVERE, "Complex store returned more properties than allowed by security (because they are required by the schema). Either the security setup is broken or you have a security breach");
                    }
                    result = SecuredObjects.secure(fc, this.policy);
                }
            } else {
                result = SecuredObjects.secure(fc, this.policy);
            }
        }
        if ((limits = this.policy.getLimits()) instanceof VectorAccessLimits) {
            VectorAccessLimits vectorLimits = (VectorAccessLimits)limits;
            result = this.decoratesForClipping(vectorLimits, result);
        }
        return result;
    }

    private FeatureCollection<T, F> decoratesForClipping(VectorAccessLimits limits, FeatureCollection<T, F> collection) {
        if (!(collection instanceof SimpleFeatureCollection)) {
            return collection;
        }
        Geometry clipFilter = limits.getClipVectorFilter();
        Geometry intersectFilter = limits.getIntersectVectorFilter();
        if (clipFilter != null) {
            collection = intersectFilter != null ? new ClipIntersectsFeatureCollection((SimpleFeatureCollection)collection, clipFilter, intersectFilter) : new ClippedFeatureCollection((SimpleFeatureCollection)collection, clipFilter, false);
        }
        return collection;
    }

    protected Query getReadQuery() {
        if (this.policy.getAccessLevel() == AccessLevel.HIDDEN || this.policy.getAccessLevel() == AccessLevel.METADATA) {
            return new Query(null, (Filter)Filter.EXCLUDE);
        }
        if (this.policy.getLimits() == null) {
            return Query.ALL;
        }
        if (this.policy.getLimits() instanceof VectorAccessLimits) {
            VectorAccessLimits val = (VectorAccessLimits)this.policy.getLimits();
            Request request = (Request)Dispatcher.REQUEST.get();
            if (request != null && request.getService().equalsIgnoreCase("WFS") && request.getRequest().equalsIgnoreCase("Transaction")) {
                return val.getWriteQuery();
            }
            return val.getReadQuery();
        }
        throw new IllegalArgumentException("SecureFeatureSources has been fed with unexpected AccessLimits class " + this.policy.getLimits().getClass());
    }

    protected Query mixQueries(Query userQuery, Query securityQuery) {
        Query result = new Query(DataUtilities.mixQueries((Query)userQuery, (Query)securityQuery, (String)userQuery.getHandle()));
        List securityProperties = securityQuery.getProperties();
        if (securityProperties != null && !securityProperties.isEmpty()) {
            List userProperties = userQuery.getProperties();
            if (userProperties == null) {
                result.setProperties(securityProperties);
            } else {
                for (PropertyName pn : userProperties) {
                    if (securityProperties.contains(pn)) continue;
                    throw new SecurityException("Attribute " + pn.getPropertyName() + " is not available");
                }
                result.setProperties(userProperties);
            }
        }
        if (userQuery.getHints() == null) {
            result.setHints(securityQuery.getHints());
        } else if (securityQuery.getHints() == null) {
            result.setHints(userQuery.getHints());
        } else {
            Hints mix = userQuery.getHints();
            mix.putAll((Map)securityQuery.getHints());
            result.setHints(mix);
        }
        result.setCoordinateSystem(userQuery.getCoordinateSystem());
        result.setCoordinateSystemReproject(userQuery.getCoordinateSystemReproject());
        result.setStartIndex(userQuery.getStartIndex());
        result.setSortBy(userQuery.getSortBy());
        return result;
    }
}

