/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredFeatureStore;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLocking;
import org.geotools.data.Query;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

public class SecuredFeatureLocking<T extends FeatureType, F extends Feature>
extends SecuredFeatureStore<T, F>
implements FeatureLocking<T, F> {
    FeatureLocking<T, F> lockDelegate;

    protected SecuredFeatureLocking(FeatureLocking<T, F> delegate, WrapperPolicy policy) {
        super(delegate, policy);
        this.lockDelegate = delegate;
    }

    public int lockFeatures() throws IOException {
        return this.lockFeatures((Filter)Filter.INCLUDE);
    }

    public int lockFeatures(Query query) throws IOException {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        Query mixed = this.mixQueries(query, writeQuery);
        Filter writeFilter = writeQuery.getFilter();
        if (writeFilter == Filter.EXCLUDE) {
            throw this.unsupportedOperation();
        }
        if (writeFilter == Filter.INCLUDE) {
            return this.lockDelegate.lockFeatures(query);
        }
        return this.lockDelegate.lockFeatures(mixed);
    }

    public int lockFeatures(Filter filter) throws IOException {
        return this.lockDelegate.lockFeatures(new Query(null, filter));
    }

    public void setFeatureLock(FeatureLock lock) {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        if (writeQuery.getFilter() == Filter.EXCLUDE) {
            throw this.unsupportedOperation();
        }
        this.lockDelegate.setFeatureLock(lock);
    }

    public void unLockFeatures() throws IOException {
        this.unLockFeatures(Query.ALL);
    }

    public void unLockFeatures(Filter filter) throws IOException {
        this.unLockFeatures(new Query(null, filter));
    }

    public void unLockFeatures(Query query) throws IOException {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        Query mixed = this.mixQueries(query, writeQuery);
        Filter writeFilter = writeQuery.getFilter();
        if (writeFilter == Filter.EXCLUDE) {
            throw this.unsupportedOperation();
        }
        if (writeFilter == Filter.INCLUDE) {
            this.lockDelegate.unLockFeatures(query);
        } else {
            this.lockDelegate.unLockFeatures(mixed);
        }
    }
}

