/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.security.AccessLevel;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DecoratingDataStoreInfo;
import org.geoserver.security.decorators.SecuredObjects;
import org.geotools.data.DataAccess;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.util.ProgressListener;

public class SecuredDataStoreInfo
extends DecoratingDataStoreInfo {
    WrapperPolicy policy;

    public SecuredDataStoreInfo(DataStoreInfo delegate, WrapperPolicy policy) {
        super(delegate);
        this.policy = policy;
    }

    @Override
    public DataAccess<? extends FeatureType, ? extends Feature> getDataStore(ProgressListener listener) throws IOException {
        DataAccess<? extends FeatureType, ? extends Feature> ds = super.getDataStore(listener);
        if (ds == null) {
            return null;
        }
        if (this.policy.level == AccessLevel.METADATA) {
            throw SecureCatalogImpl.unauthorizedAccess(this.getName());
        }
        return SecuredObjects.secure(ds, this.policy);
    }
}

