/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.util.HashMap;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.ClippedFeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;

class ClipIntersectsFeatureIterator
extends ClippedFeatureIterator {
    private Geometry intersects;

    ClipIntersectsFeatureIterator(SimpleFeatureIterator delegate, Geometry clip, Geometry intersects, SimpleFeatureType schema, boolean preserveZ) {
        super(delegate, clip, schema, preserveZ);
        this.intersects = intersects;
    }

    public boolean hasNext() {
        while (this.next == null && this.delegate.hasNext()) {
            Map<Name, Geometry> geometryAttributes;
            SimpleFeature f = (SimpleFeature)this.delegate.next();
            boolean doTheClip = this.intersects == null;
            Map<Name, Geometry> intersectedGeometries = null;
            if (this.intersects != null && (intersectedGeometries = this.getIntersectingGeometries(geometryAttributes = this.extractGeometryAttributes(f), f.getFeatureType())) != null) {
                doTheClip = geometryAttributes.size() > intersectedGeometries.size();
            }
            boolean clippedOut = false;
            if (doTheClip) {
                clippedOut = this.prepareBuilderForNextFeature(f);
            }
            if (!clippedOut && doTheClip) {
                this.next = this.fb.buildFeature(f.getID());
                this.unionWithIntersected(intersectedGeometries);
            } else if (intersectedGeometries != null && !intersectedGeometries.isEmpty()) {
                this.next = f;
                for (Name name : intersectedGeometries.keySet()) {
                    this.next.setAttribute(name, (Object)intersectedGeometries.get(name));
                }
            }
            this.fb.reset();
        }
        return this.next != null;
    }

    private void unionWithIntersected(Map<Name, Geometry> intersectedGeometries) {
        for (Name name : intersectedGeometries.keySet()) {
            Geometry intersected = intersectedGeometries.get(name);
            if (intersected == null || intersected.isEmpty()) continue;
            this.next.setAttribute(name, (Object)((Geometry)this.next.getAttribute(name)).union(intersected));
        }
    }

    private Map<Name, Geometry> getIntersectingGeometries(Map<Name, Geometry> geometryAttributes, SimpleFeatureType type) {
        HashMap<Name, Geometry> intersectedGeometries = new HashMap<Name, Geometry>();
        for (Name name : geometryAttributes.keySet()) {
            Geometry geom = geometryAttributes.get(name);
            if (!geom.intersects(this.intersects)) continue;
            intersectedGeometries.put(name, geom);
        }
        return intersectedGeometries;
    }

    private Map<Name, Geometry> extractGeometryAttributes(SimpleFeature f) {
        HashMap<Name, Geometry> geometryAttributes = new HashMap<Name, Geometry>();
        for (AttributeDescriptor ad : f.getFeatureType().getAttributeDescriptors()) {
            Object attribute = f.getAttribute(ad.getName());
            if (!(ad instanceof GeometryDescriptor)) continue;
            geometryAttributes.put(ad.getName(), (Geometry)attribute);
        }
        return geometryAttributes;
    }
}

