/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class RESTfulPathBasedFilterInvocationDefinitionMap
implements FilterInvocationSecurityMetadataSource {
    private static Logger log = Logging.getLogger(RESTfulPathBasedFilterInvocationDefinitionMap.class);
    private Collection<EntryHolder> requestMap = new ArrayList<EntryHolder>();
    private PathMatcher pathMatcher = new AntPathMatcher();
    private boolean convertUrlToLowercaseBeforeComparison = false;

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public void addSecureUrl(String antPath, String[] httpMethods, Collection<ConfigAttribute> attrs) {
        this.requestMap.add(new EntryHolder(antPath, httpMethods, attrs));
        if (log.isLoggable(Level.FINE)) {
            log.fine("Added Ant path: " + antPath + "; attributes: " + attrs + ", httpMethods: " + Arrays.toString(httpMethods));
        }
    }

    public void addSecureUrl(String antPath, Collection<ConfigAttribute> attrs) {
        throw new IllegalArgumentException("addSecureUrl(String, Collection<ConfigAttribute> ) is INVALID for RESTfulDefinitionSource");
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        HashSet<ConfigAttribute> set = new HashSet<ConfigAttribute>();
        for (EntryHolder h : this.requestMap) {
            set.addAll(h.getConfigAttributes());
        }
        return set;
    }

    public int getMapSize() {
        return this.requestMap.size();
    }

    public boolean isConvertUrlToLowercaseBeforeComparison() {
        return this.convertUrlToLowercaseBeforeComparison;
    }

    public void setConvertUrlToLowercaseBeforeComparison(boolean convertUrlToLowercaseBeforeComparison) {
        this.convertUrlToLowercaseBeforeComparison = convertUrlToLowercaseBeforeComparison;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("Object must be a FilterInvocation");
        }
        String url = ((FilterInvocation)object).getRequestUrl();
        String method = ((FilterInvocation)object).getHttpRequest().getMethod();
        return this.lookupAttributes(url, method);
    }

    public Collection<ConfigAttribute> lookupAttributes(String url) {
        throw new IllegalArgumentException("lookupAttributes(String url) is INVALID for RESTfulDefinitionSource");
    }

    public Collection<ConfigAttribute> lookupAttributes(String url, String httpMethod) {
        int firstQuestionMarkIndex = url.indexOf("?");
        if (firstQuestionMarkIndex != -1) {
            url = url.substring(0, firstQuestionMarkIndex);
        }
        if (this.isConvertUrlToLowercaseBeforeComparison()) {
            url = url.toLowerCase();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Converted URL to lowercase, from: '" + url + "'; to: '" + url + "'  and httpMethod= " + httpMethod);
            }
        }
        for (EntryHolder entryHolder : this.requestMap) {
            String antPath = entryHolder.getAntPath();
            Object[] methodList = entryHolder.getHttpMethodList();
            if (log.isLoggable(Level.FINE)) {
                log.fine("~~~~~~~~~~ antPath= " + antPath + " methodList= " + Arrays.toString(methodList));
            }
            boolean matchedPath = this.pathMatcher.match(antPath, url);
            boolean matchedMethods = true;
            if (methodList != null) {
                matchedMethods = false;
                for (Object s : methodList) {
                    if (!((String)s).equals(httpMethod)) continue;
                    matchedMethods = true;
                    break;
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Candidate is: '" + url + "'; antPath is " + antPath + "; matchedPath=" + matchedPath + "; matchedMethods=" + matchedMethods);
            }
            if (!matchedPath || !matchedMethods) continue;
            log.fine("returning " + StringUtils.collectionToCommaDelimitedString(entryHolder.getConfigAttributes()));
            return entryHolder.getConfigAttributes();
        }
        return null;
    }

    protected class EntryHolder {
        private Collection<ConfigAttribute> configAttributes;
        private String antPath;
        private String[] httpMethodList;

        public EntryHolder(String antPath, String[] httpMethodList, Collection<ConfigAttribute> attrs) {
            this.antPath = antPath;
            this.configAttributes = attrs;
            this.httpMethodList = httpMethodList;
        }

        protected EntryHolder() {
            throw new IllegalArgumentException("Cannot use default constructor");
        }

        public String getAntPath() {
            return this.antPath;
        }

        public String[] getHttpMethodList() {
            return this.httpMethodList;
        }

        public Collection<ConfigAttribute> getConfigAttributes() {
            return this.configAttributes;
        }
    }
}

