/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerSecurityFilterChainProxy;
import org.geoserver.security.impl.AbstractGeoServerSecurityService;
import org.geotools.util.logging.Logging;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public abstract class GeoServerAuthenticationProvider
extends AbstractGeoServerSecurityService
implements AuthenticationProvider {
    public static String DEFAULT_NAME = "default";
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");

    public final boolean supports(Class<? extends Object> authentication) {
        return this.supports(authentication, this.request());
    }

    public abstract boolean supports(Class<? extends Object> var1, HttpServletRequest var2);

    public final Authentication authenticate(Authentication authentication) throws AuthenticationException {
        return this.authenticate(authentication, this.request());
    }

    public abstract Authentication authenticate(Authentication var1, HttpServletRequest var2);

    HttpServletRequest request() {
        return GeoServerSecurityFilterChainProxy.REQUEST.get();
    }

    protected void log(AuthenticationException ex) {
        Level l = Level.WARNING;
        if (ex instanceof UsernameNotFoundException || ex instanceof BadCredentialsException || ex instanceof DisabledException) {
            l = Level.FINE;
        }
        LOGGER.log(l, ex.getLocalizedMessage(), (Throwable)ex);
    }
}

