/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.security.ConcurrentAuthenticationException;
import org.geoserver.security.GeoServerSecurityFilterChainProxy;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.MaxBlockedThreadsException;
import org.geoserver.security.config.BruteForcePreventionConfig;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.AuthenticationFailureProviderNotFoundEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;

public class BruteForceListener
implements ApplicationListener<AbstractAuthenticationEvent>,
GeoServerLifecycleHandler {
    static final Logger LOGGER = Logging.getLogger(BruteForceListener.class);
    Map<String, AtomicInteger> delayedUsers = new ConcurrentHashMap<String, AtomicInteger>();
    private GeoServerSecurityManager securityManager;

    public BruteForceListener(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    private BruteForcePreventionConfig getConfig() {
        BruteForcePreventionConfig config = this.securityManager.getSecurityConfig().getBruteForcePrevention();
        if (config == null) {
            return BruteForcePreventionConfig.DEFAULT;
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(AbstractAuthenticationEvent event) {
        AtomicInteger counter;
        BruteForcePreventionConfig config = this.getConfig();
        if (!config.isEnabled()) {
            return;
        }
        HttpServletRequest request = GeoServerSecurityFilterChainProxy.REQUEST.get();
        if (this.requestAddressInWhiteList(request, config)) {
            return;
        }
        Authentication authentication = event.getAuthentication();
        String name = this.getUserName(authentication);
        if (name == null) {
            LOGGER.warning("Brute force attack prevention enabled, but Spring Authentication does not provide a user name, skipping: " + authentication);
        }
        if ((counter = this.delayedUsers.get(name)) != null) {
            int count = counter.incrementAndGet();
            this.logFailedRequest(request, name, count);
            throw new ConcurrentAuthenticationException(name, count);
        }
        if (event instanceof AuthenticationFailureBadCredentialsEvent || event instanceof AuthenticationFailureProviderNotFoundEvent) {
            int maxBlockedThreads = config.getMaxBlockedThreads();
            if (maxBlockedThreads > 0 && this.delayedUsers.size() > maxBlockedThreads) {
                throw new MaxBlockedThreadsException(1);
            }
            this.delayedUsers.put(name, new AtomicInteger(1));
            try {
                this.logFailedRequest(request, name, 0);
                long delay = this.computeDelay(config);
                if (delay > 0L) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Brute force attack prevention, delaying login for " + delay + "ms");
                    }
                    Thread.sleep(delay);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.delayedUsers.remove(name);
            }
        }
    }

    private boolean requestAddressInWhiteList(HttpServletRequest request, BruteForcePreventionConfig config) {
        if (config.getWhitelistAddressMatchers() == null) {
            return false;
        }
        return config.getWhitelistAddressMatchers().stream().anyMatch(matcher -> matcher.matches(request));
    }

    private long computeDelay(BruteForcePreventionConfig config) {
        long min = config.getMinDelaySeconds() * 1000;
        long max = config.getMaxDelaySeconds() * 1000;
        return min + (long)((double)(max - min) * Math.random());
    }

    private String getUserName(Authentication authentication) {
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal != null) {
            if (principal instanceof UserDetails) {
                return ((UserDetails)principal).getUsername();
            }
            if (principal instanceof String) {
                return (String)principal;
            }
        }
        return authentication.getName();
    }

    private void logFailedRequest(HttpServletRequest request, String name, int count) {
        StringBuilder sb = new StringBuilder("Failed login, user ").append(name).append(" from ");
        sb.append(request.getRemoteAddr());
        String forwardedFor = request.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            sb.append(", forwarded for ").append(forwardedFor);
        }
        if (count > 0) {
            sb.append(", stopped ").append(count).append(" concurrent logins during authentication delay");
        }
        LOGGER.warning(sb.toString());
    }

    @Override
    public void onReset() {
        this.delayedUsers.clear();
    }

    @Override
    public void onDispose() {
    }

    @Override
    public void beforeReload() {
    }

    @Override
    public void onReload() {
        this.delayedUsers.clear();
    }
}

