/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ows.AbstractURLPublisher;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.URLs;
import org.springframework.web.context.support.ServletContextResourceLoader;

public class StylePublisher
extends AbstractURLPublisher {
    protected Catalog catalog;
    protected ServletContextResourceLoader scloader;

    public StylePublisher(Catalog catalog) {
        this.catalog = catalog;
    }

    protected URL getUrl(HttpServletRequest request) throws IOException {
        String ctxPath = request.getContextPath();
        String reqPath = request.getRequestURI();
        reqPath = URLDecoder.decode(reqPath, "UTF-8");
        if ((reqPath = reqPath.substring(ctxPath.length())).length() > 1 && reqPath.startsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        if (reqPath.startsWith("styles/") && reqPath.length() > 7) {
            String wsStylePath;
            String wsName;
            WorkspaceInfo workspace;
            Resource resource = null;
            GeoServerResourceLoader resources = this.catalog.getResourceLoader();
            GeoServerDataDirectory data = new GeoServerDataDirectory(resources);
            String stylePath = reqPath.substring(7);
            int slash = stylePath.indexOf(47);
            if (slash > -1 && stylePath.length() > slash + 1 && (workspace = this.catalog.getWorkspaceByName(wsName = stylePath.substring(0, slash))) != null && (resource = data.getStyles(workspace, wsStylePath = stylePath.substring(slash + 1))).getType() == Resource.Type.UNDEFINED) {
                resource = data.getStyles(wsStylePath);
            }
            if (resource == null || resource.getType() == Resource.Type.UNDEFINED) {
                resource = data.getStyles(stylePath);
            }
            switch (resource.getType()) {
                case RESOURCE: {
                    return URLs.fileToUrl((File)resource.file());
                }
            }
            return null;
        }
        return null;
    }
}

