/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;

public class LanguageURLMangler
implements URLMangler {
    public static final String ACCEPT_LANGUAGES = "AcceptLanguages";
    public static final String LANGUAGE = "Language";
    private final Predicate<Object> filterEmtpyString = language -> !((String)language).isEmpty();

    public void mangleURL(StringBuilder baseURL, StringBuilder path, Map<String, String> kvp, URLMangler.URLType type) {
        if (URLMangler.URLType.SERVICE.equals((Object)type)) {
            this.processLanguageParam().ifPresent(maybeLanguage -> kvp.put(LANGUAGE, (String)maybeLanguage));
        }
    }

    protected Optional<Object> processLanguageParam() {
        return Optional.ofNullable(Dispatcher.REQUEST.get()).map(Request::getRawKvp).map(rawKvp -> this.getLanguage((Map<String, Object>)rawKvp).orElse(this.getAcceptLanguages((Map<String, Object>)rawKvp).orElse(""))).filter(this.filterEmtpyString);
    }

    protected Optional<Object> getLanguage(Map<String, Object> rawKvp) {
        return Optional.ofNullable(rawKvp.get(LANGUAGE)).filter(this.filterEmtpyString);
    }

    protected Optional<String> getAcceptLanguages(Map<String, Object> rawKvp) {
        return Optional.ofNullable(rawKvp.get(ACCEPT_LANGUAGES)).flatMap(value -> Arrays.stream(((String)value).split("[\\s,]+")).findFirst().filter(language -> !language.isEmpty()));
    }
}

