/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.filters.BufferedRequestWrapper;
import org.geoserver.filters.GeoServerFilter;
import org.geoserver.ows.util.RequestUtils;
import org.geotools.util.logging.Logging;

public class LoggingFilter
implements GeoServerFilter {
    protected Logger logger = Logging.getLogger((String)"org.geoserver.filters");
    public static final String LOG_REQUESTS_ENABLED = "logRequestsEnabled";
    public static final String LOG_HEADERS_ENABLED = "logHeadersEnabled";
    public static final String LOG_BODIES_ENABLED = "logBodiesEnabled";
    public static final String REQUEST_LOG_BUFFER_SIZE = "requestLogBufferSize";
    public static final Integer REQUEST_LOG_BUFFER_SIZE_DEFAULT = 1024;
    protected boolean enabled = false;
    protected boolean logBodies = false;
    protected Integer requestLogBufferSize = REQUEST_LOG_BUFFER_SIZE_DEFAULT;
    protected boolean logHeaders = false;
    private final GeoServer geoServer;

    public LoggingFilter(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    protected boolean isBinary(String contentType) {
        String subType;
        if (contentType == null) {
            return true;
        }
        int sub = contentType.indexOf(47);
        String mimeType = sub == -1 ? contentType : contentType.substring(0, sub).toLowerCase();
        String string = subType = sub == -1 ? "" : contentType.substring(sub + 1).toLowerCase();
        if (mimeType.equals("image") && !subType.contains("svg")) {
            return true;
        }
        return "application".equals(mimeType) && !subType.contains("xml") && !subType.contains("json") && !subType.contains("gml");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        boolean geoServerHasMetadata;
        boolean bl = geoServerHasMetadata = this.geoServer != null && this.geoServer.getGlobal() != null && this.geoServer.getGlobal().getMetadata() != null;
        if (geoServerHasMetadata) {
            MetadataMap metadataMap = this.geoServer.getGlobal().getMetadata();
            this.enabled = metadataMap.containsKey(LOG_REQUESTS_ENABLED) && metadataMap.get(LOG_REQUESTS_ENABLED, Boolean.class) != false;
            this.logBodies = metadataMap.containsKey(LOG_BODIES_ENABLED) && metadataMap.get(LOG_BODIES_ENABLED, Boolean.class) != false;
            this.logHeaders = metadataMap.containsKey(LOG_HEADERS_ENABLED) && metadataMap.get(LOG_HEADERS_ENABLED, Boolean.class) != false;
            this.requestLogBufferSize = this.geoServer.getGlobal().getXmlPostRequestLogBufferSize() != null ? this.geoServer.getGlobal().getXmlPostRequestLogBufferSize() : REQUEST_LOG_BUFFER_SIZE_DEFAULT;
        }
        String message = "";
        String body = null;
        String path = "";
        if (this.enabled) {
            if (req instanceof HttpServletRequest) {
                HttpServletRequest hreq = (HttpServletRequest)req;
                path = RequestUtils.getRemoteAddr((HttpServletRequest)hreq) + " \"" + hreq.getMethod() + " " + hreq.getRequestURI();
                if (hreq.getQueryString() != null) {
                    path = path + "?" + hreq.getQueryString();
                }
                path = path + "\"";
                message = "" + path;
                message = message + " \"" + this.noNull(hreq.getHeader("User-Agent"));
                message = message + "\" \"" + this.noNull(hreq.getHeader("Referer"));
                message = message + "\" \"" + this.noNull(hreq.getHeader("Content-type")) + "\" ";
                if (this.logHeaders) {
                    Enumeration headerNames = hreq.getHeaderNames();
                    message = message + "\n  Headers:";
                    while (headerNames.hasMoreElements()) {
                        String headerName = (String)headerNames.nextElement();
                        message = message + "\n    " + headerName + ": " + hreq.getHeader(headerName);
                    }
                }
                if (this.logBodies && this.requestLogBufferSize > 0 && (hreq.getMethod().equals("PUT") || hreq.getMethod().equals("POST") || hreq.getMethod().equals("PATCH"))) {
                    message = message + " request-size: " + hreq.getContentLength();
                    message = message + " body: ";
                    String encoding = hreq.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = "ISO-8859-1";
                    }
                    ServletInputStream is = hreq.getInputStream();
                    Charset charset = Charset.defaultCharset();
                    try {
                        charset = Charset.forName(encoding);
                    }
                    catch (IllegalCharsetNameException icn) {
                        this.logger.info("Request character set not recognized, using default character set");
                    }
                    float maxBytesPerCharacter = charset.newEncoder().maxBytesPerChar();
                    int byteSize = (int)((double)this.requestLogBufferSize.intValue() * (double)maxBytesPerCharacter);
                    byte[] reqCharacters = new byte[byteSize];
                    BufferedInputStream bufferedStream = new BufferedInputStream((InputStream)is);
                    bufferedStream.mark(byteSize);
                    bufferedStream.read(reqCharacters, 0, byteSize);
                    body = new String(reqCharacters, encoding).trim();
                    bufferedStream.reset();
                    req = new BufferedRequestWrapper(hreq, encoding, bufferedStream);
                    message = this.isBinary(hreq.getHeader("Content-type")) ? message + " bytes (binary content)\n" : message + (body == null ? "" : "\n" + body + "\n");
                }
            } else {
                message = "" + req.getRemoteHost() + " made a non-HTTP request";
            }
            this.logger.info(message);
            long startTime = System.currentTimeMillis();
            chain.doFilter(req, res);
            long requestTime = System.currentTimeMillis() - startTime;
            this.logger.info(path + " took " + requestTime + "ms");
        } else {
            chain.doFilter(req, res);
        }
    }

    public void init(FilterConfig filterConfig) {
        this.enabled = this.getConfigBool("enabled", filterConfig);
        this.logBodies = this.getConfigBool("log-request-bodies", filterConfig);
        this.logHeaders = this.getConfigBool("log-request-headers", filterConfig);
    }

    protected boolean getConfigBool(String name, FilterConfig conf) {
        try {
            String value = conf.getInitParameter(name);
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String noNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public void destroy() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isLogBodies() {
        return this.logBodies;
    }

    public void setLogBodies(boolean logBodies) {
        this.logBodies = logBodies;
    }
}

