/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.feature.retype.FeatureTypeMap;
import org.geoserver.feature.retype.FidTransformerVisitor;
import org.geoserver.feature.retype.RetypingFeatureLocking;
import org.geoserver.feature.retype.RetypingFeatureSource;
import org.geoserver.feature.retype.RetypingFeatureStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Join;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.DecoratingDataStore;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;

public class RetypingDataStore
extends DecoratingDataStore {
    static final Logger LOGGER = Logging.getLogger(RetypingDataStore.class);
    private DataStore wrapped;
    protected volatile Map<String, FeatureTypeMap> forwardMap = new ConcurrentHashMap<String, FeatureTypeMap>();
    protected volatile Map<String, FeatureTypeMap> backwardsMap = new ConcurrentHashMap<String, FeatureTypeMap>();

    public RetypingDataStore(DataStore wrapped) throws IOException {
        super(wrapped);
        this.wrapped = wrapped;
        this.getTypeNames();
    }

    public DataStore getWrapped() {
        return (DataStore)this.unwrap(DataStore.class);
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("GeoServer does not support schema creation at the moment");
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("GeoServer does not support schema updates at the moment");
    }

    public void removeSchema(String typeName) throws IOException {
        throw new UnsupportedOperationException("GeoServer does not support schema removal at the moment");
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        FeatureTypeMap map = this.getTypeMapBackwards(typeName, true);
        this.updateMap(map, false);
        FeatureWriter writer = this.wrapped.getFeatureWriter(map.getOriginalName(), filter, transaction);
        if (map.isUnchanged()) {
            return writer;
        }
        return new RetypingFeatureCollection.RetypingFeatureWriter((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer, map.getFeatureType());
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        FeatureTypeMap map = this.getTypeMapBackwards(typeName, true);
        this.updateMap(map, false);
        FeatureWriter writer = this.wrapped.getFeatureWriter(map.getOriginalName(), transaction);
        if (map.isUnchanged()) {
            return writer;
        }
        return new RetypingFeatureCollection.RetypingFeatureWriter((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer, map.getFeatureType());
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        FeatureTypeMap map = this.getTypeMapBackwards(typeName, true);
        this.updateMap(map, false);
        FeatureWriter writer = this.wrapped.getFeatureWriterAppend(map.getOriginalName(), transaction);
        if (map.isUnchanged()) {
            return writer;
        }
        return new RetypingFeatureCollection.RetypingFeatureWriter((FeatureWriter<SimpleFeatureType, SimpleFeature>)writer, map.getFeatureType());
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        FeatureTypeMap map = this.getTypeMapBackwards(typeName, false);
        if (map == null) {
            throw new IOException("Unknown type " + typeName);
        }
        this.updateMap(map, true);
        return map.getFeatureType();
    }

    public String[] getTypeNames() throws IOException {
        String[] names = this.wrapped.getTypeNames();
        ArrayList<String> transformedNames = new ArrayList<String>();
        HashMap<String, FeatureTypeMap> backup = new HashMap<String, FeatureTypeMap>(this.forwardMap);
        ConcurrentHashMap<String, FeatureTypeMap> forwardMapLocal = new ConcurrentHashMap<String, FeatureTypeMap>();
        ConcurrentHashMap<String, FeatureTypeMap> backwardsMapLocal = new ConcurrentHashMap<String, FeatureTypeMap>();
        for (String original : names) {
            String transformedName = this.transformFeatureTypeName(original);
            if (transformedName == null) continue;
            transformedNames.add(transformedName);
            FeatureTypeMap map = (FeatureTypeMap)backup.get(original);
            if (map == null) {
                map = new FeatureTypeMap(original, transformedName);
            }
            forwardMapLocal.put(map.getOriginalName(), map);
            backwardsMapLocal.put(map.getName(), map);
        }
        this.forwardMap = forwardMapLocal;
        this.backwardsMap = backwardsMapLocal;
        return transformedNames.toArray(new String[transformedNames.size()]);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        FeatureTypeMap map = this.getTypeMapBackwards(query.getTypeName(), true);
        this.updateMap(map, false);
        FeatureReader reader = this.wrapped.getFeatureReader(this.retypeQuery(query, map), transaction);
        if (map.isUnchanged()) {
            return reader;
        }
        return new RetypingFeatureCollection.RetypingFeatureReader((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, map.getFeatureType(query));
    }

    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        FeatureTypeMap map = this.getTypeMapBackwards(typeName, true);
        this.updateMap(map, false);
        SimpleFeatureSource source = this.wrapped.getFeatureSource(map.getOriginalName());
        if (map.isUnchanged()) {
            return source;
        }
        if (source instanceof FeatureLocking) {
            SimpleFeatureLocking locking = DataUtilities.simple((FeatureLocking)((FeatureLocking)source));
            return new RetypingFeatureLocking(this, locking, map);
        }
        if (source instanceof FeatureStore) {
            SimpleFeatureStore store = DataUtilities.simple((FeatureStore)((FeatureStore)source));
            return new RetypingFeatureStore(this, store, map);
        }
        return new RetypingFeatureSource(this, source, map);
    }

    public LockingManager getLockingManager() {
        return this.wrapped.getLockingManager();
    }

    FeatureTypeMap getTypeMapBackwards(String externalTypeName, boolean checkMap) throws IOException {
        FeatureTypeMap map = this.backwardsMap.get(externalTypeName);
        if (map == null && checkMap) {
            throw new IOException("Type mapping has not been established for type  " + externalTypeName + ". Make sure you access types using getTypeNames() or getSchema() before trying to read/write onto them");
        }
        return map;
    }

    void updateMap(FeatureTypeMap map, boolean forceUpdate) throws IOException {
        try {
            if (map.getFeatureType() == null || forceUpdate) {
                SimpleFeatureType original = this.wrapped.getSchema(map.getOriginalName());
                SimpleFeatureType transformed = this.transformFeatureType(original);
                map.setFeatureTypes(original, transformed);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Failure to remap feature type " + map.getOriginalName() + ". The type will be ignored", e);
            this.backwardsMap.remove(map.getName());
            this.forwardMap.remove(map.getOriginalName());
        }
    }

    protected SimpleFeatureType transformFeatureType(SimpleFeatureType original) throws IOException {
        String transfomedName = this.transformFeatureTypeName(original.getTypeName());
        if (transfomedName.equals(original.getTypeName())) {
            return original;
        }
        try {
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.init(original);
            b.setName(transfomedName);
            return b.buildFeatureType();
        }
        catch (Exception e) {
            throw new DataSourceException("Could not build the renamed feature type.", (Throwable)e);
        }
    }

    protected String transformFeatureTypeName(String originalName) {
        return originalName.replaceAll(":", "_");
    }

    public void dispose() {
        this.wrapped.dispose();
    }

    Query retypeQuery(Query q, FeatureTypeMap typeMap) throws IOException {
        Query modified = new Query(q);
        modified.setTypeName(typeMap.getOriginalName());
        modified.setFilter(this.retypeFilter(q.getFilter(), typeMap));
        List joins = q.getJoins();
        if (!joins.isEmpty()) {
            modified.getJoins().clear();
            for (Join join : joins) {
                FeatureTypeMap map = this.backwardsMap.get(join.getTypeName());
                if (map == null) {
                    modified.getJoins().add(join);
                    continue;
                }
                FeatureTypeMap joinTypeMap = this.getTypeMapBackwards(join.getTypeName(), true);
                String originalName = joinTypeMap.getOriginalName();
                Join mj = new Join(originalName, join.getJoinFilter());
                mj.setType(join.getType());
                mj.setAlias(join.getAlias());
                mj.setProperties(join.getProperties());
                mj.setFilter(join.getFilter());
                modified.getJoins().add(mj);
            }
        }
        return modified;
    }

    Filter retypeFilter(Filter filter, FeatureTypeMap typeMap) {
        FidTransformerVisitor visitor = new FidTransformerVisitor(typeMap);
        return (Filter)filter.accept((FilterVisitor)visitor, null);
    }

    public ServiceInfo getInfo() {
        return this.wrapped.getInfo();
    }

    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return this.getFeatureSource(typeName.getLocalPart());
    }

    public List<Name> getNames() throws IOException {
        String[] typeNames = this.getTypeNames();
        ArrayList<Name> names = new ArrayList<Name>(typeNames.length);
        for (String typeName : typeNames) {
            names.add((Name)new NameImpl(typeName));
        }
        return names;
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        return this.getSchema(name.getLocalPart());
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.updateSchema(typeName.getLocalPart(), featureType);
    }

    public void removeSchema(Name typeName) throws IOException {
        this.removeSchema(typeName.getLocalPart());
    }
}

