/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import java.util.HashSet;
import java.util.Set;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.feature.retype.FeatureTypeMap;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

class FidTransformerVisitor
extends DuplicatingFilterVisitor {
    private FeatureTypeMap map;

    public FidTransformerVisitor(FeatureTypeMap map) {
        super(CommonFactoryFinder.getFilterFactory2(null));
        this.map = map;
    }

    public Object visit(Id filter, Object extraData) {
        Set ids = filter.getIDs();
        if (ids.isEmpty()) {
            throw new IllegalArgumentException("Invalid fid filter provides, has no fids inside");
        }
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        for (Object o : ids) {
            FeatureIdImpl id = new FeatureIdImpl((String)o);
            FeatureId retyped = RetypingFeatureCollection.reTypeId((FeatureId)id, this.map.getFeatureType(), this.map.getOriginalFeatureType());
            fids.add(retyped);
        }
        return this.ff.id(fids);
    }
}

