/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.filter.spatial.DefaultCRSFilterVisitor;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.ProgressListener;

public class ReprojectingFeatureCollection
extends DecoratingSimpleFeatureCollection {
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2(null);
    SimpleFeatureType schema;
    CoordinateReferenceSystem target;
    CoordinateReferenceSystem defaultSource;
    Map<CoordinateReferenceSystem, GeometryCoordinateSequenceTransformer> transformers;
    Hints hints = new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);

    public ReprojectingFeatureCollection(SimpleFeatureCollection delegate, CoordinateReferenceSystem target) throws SchemaException, OperationNotFoundException, FactoryRegistryException, FactoryException {
        super(delegate);
        this.target = target;
        this.schema = FeatureTypes.transform((SimpleFeatureType)((SimpleFeatureType)delegate.getSchema()), (CoordinateReferenceSystem)target);
        this.transformers = new HashMap<CoordinateReferenceSystem, GeometryCoordinateSequenceTransformer>();
        CoordinateReferenceSystem source = ((SimpleFeatureType)delegate.getSchema()).getCoordinateReferenceSystem();
        if (source == null) {
            throw new RuntimeException("Source was null in trying to create a reprojected feature collection!");
        }
        MathTransform tx = ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)this.hints).createOperation(source, target).getMathTransform();
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
        transformer.setMathTransform(tx);
        this.transformers.put(source, transformer);
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) {
        try (SimpleFeatureIterator it = this.features();){
            while (it.hasNext()) {
                visitor.visit(it.next());
            }
        }
    }

    public void setDefaultSource(CoordinateReferenceSystem defaultSource) {
        this.defaultSource = defaultSource;
    }

    public SimpleFeatureIterator features() {
        return new ReprojectingFeatureIterator(this.delegate.features());
    }

    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        SimpleFeatureCollection sub;
        CoordinateReferenceSystem crs = this.getSchema().getCoordinateReferenceSystem();
        CoordinateReferenceSystem crsDelegate = ((SimpleFeatureType)this.delegate.getSchema()).getCoordinateReferenceSystem();
        if (crs != null) {
            DefaultCRSFilterVisitor defaulter = new DefaultCRSFilterVisitor(FF, crs);
            filter = (Filter)filter.accept((FilterVisitor)defaulter, null);
            if (crsDelegate != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)crsDelegate)) {
                ReprojectingFilterVisitor reprojector = new ReprojectingFilterVisitor(FF, this.delegate.getSchema());
                filter = (Filter)filter.accept((FilterVisitor)reprojector, null);
            }
        }
        if ((sub = this.delegate.subCollection(filter)) != null) {
            try {
                ReprojectingFeatureCollection wrapper = new ReprojectingFeatureCollection(sub, this.target);
                wrapper.setDefaultSource(this.defaultSource);
                return wrapper;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public Object[] toArray() {
        Object[] array = this.delegate.toArray();
        for (int i = 0; i < array.length; ++i) {
            try {
                array[i] = this.reproject((SimpleFeature)array[i]);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return array;
    }

    public <F> F[] toArray(F[] a) {
        Object[] array = this.delegate.toArray((Object[])a);
        for (int i = 0; i < array.length; ++i) {
            try {
                SimpleFeature cast = this.reproject((SimpleFeature)array[i]);
                array[i] = cast;
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return array;
    }

    public ReferencedEnvelope getBounds() {
        ReferencedEnvelope bounds = null;
        try (SimpleFeatureIterator i = this.features();){
            if (!i.hasNext()) {
                bounds = new ReferencedEnvelope();
                bounds.setToNull();
            } else {
                SimpleFeature first = (SimpleFeature)i.next();
                bounds = new ReferencedEnvelope(first.getBounds());
            }
            while (i.hasNext()) {
                SimpleFeature f = (SimpleFeature)i.next();
                bounds.include(f.getBounds());
            }
            ReferencedEnvelope referencedEnvelope = bounds;
            return referencedEnvelope;
        }
    }

    public SimpleFeatureCollection collection() throws IOException {
        return this;
    }

    SimpleFeature reproject(SimpleFeature feature) throws IOException {
        Object[] attributes = new Object[this.schema.getAttributeCount()];
        for (int i = 0; i < attributes.length; ++i) {
            AttributeDescriptor type = this.schema.getDescriptor(i);
            Object object = feature.getAttribute(type.getName());
            if (object instanceof Geometry) {
                Geometry geometry = (Geometry)object;
                CoordinateReferenceSystem crs = (CoordinateReferenceSystem)geometry.getUserData();
                if (crs == null && this.defaultSource != null) {
                    crs = this.defaultSource;
                }
                if (crs != null && !crs.equals(this.target)) {
                    GeometryCoordinateSequenceTransformer transformer = this.transformers.get(crs);
                    if (transformer == null) {
                        MathTransform2D tx;
                        transformer = new GeometryCoordinateSequenceTransformer();
                        try {
                            tx = (MathTransform2D)ReferencingFactoryFinder.getCoordinateOperationFactory((Hints)this.hints).createOperation(crs, this.target).getMathTransform();
                        }
                        catch (Exception e) {
                            String msg = "Could not transform for crs: " + crs;
                            throw (IOException)new IOException(msg).initCause(e);
                        }
                        transformer.setMathTransform((MathTransform)tx);
                        this.transformers.put(crs, transformer);
                    }
                    try {
                        object = transformer.transform(geometry);
                    }
                    catch (TransformException e) {
                        String msg = "Error occured transforming " + geometry.toString();
                        throw (IOException)new IOException(msg).initCause(e);
                    }
                }
            }
            attributes[i] = object;
        }
        try {
            SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)this.schema, (Object[])attributes, (String)feature.getID());
            f.getUserData().putAll(feature.getUserData());
            return f;
        }
        catch (IllegalAttributeException e) {
            String msg = "Error creating reprojeced feature";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    class ReprojectingIterator
    implements Iterator<SimpleFeature> {
        Iterator<SimpleFeature> delegate;

        public ReprojectingIterator(Iterator<SimpleFeature> delegate) {
            this.delegate = delegate;
        }

        public Iterator<SimpleFeature> getDelegate() {
            return this.delegate;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public SimpleFeature next() {
            SimpleFeature feature = this.delegate.next();
            try {
                return ReprojectingFeatureCollection.this.reproject(feature);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    class ReprojectingFeatureIterator
    implements SimpleFeatureIterator {
        SimpleFeatureIterator delegate;

        public ReprojectingFeatureIterator(SimpleFeatureIterator delegate) {
            this.delegate = delegate;
        }

        public SimpleFeatureIterator getDelegate() {
            return this.delegate;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() throws NoSuchElementException {
            SimpleFeature feature = (SimpleFeature)this.delegate.next();
            try {
                return ReprojectingFeatureCollection.this.reproject(feature);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void close() {
            if (this.delegate != null) {
                this.delegate.close();
            }
            this.delegate = null;
        }
    }
}

