/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.util;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;

public class CoverageUtils {
    private static final Logger LOGGER = Logging.getLogger((String)CoverageUtils.class.toString());
    public static final int TRANSPARENT = 0;
    public static final int OPAQUE = 1;

    public static GeneralParameterValue[] getParameters(ParameterValueGroup params) {
        ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
        String readGeometryKey = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
        if (params != null && params.values().size() > 0) {
            List list2 = params.values();
            for (ParameterValue val : list2) {
                ParameterDescriptor descr;
                String _key;
                if (val == null || "namespace".equals(_key = (descr = val.getDescriptor()).getName().toString()) || _key.equalsIgnoreCase(readGeometryKey)) continue;
                Object value = val.getValue();
                ParameterValue pv = new DefaultParameterDescriptor(_key, value.getClass(), null, value).createValue();
                parameters.add(pv);
            }
            return !parameters.isEmpty() ? parameters.toArray(new GeneralParameterValue[parameters.size()]) : null;
        }
        return null;
    }

    public static GeneralParameterValue[] getParameters(ParameterValueGroup params, Map values) {
        return CoverageUtils.getParameters(params, values, false);
    }

    public static GeneralParameterValue[] getParameters(ParameterValueGroup params, Map values, boolean readGeom) {
        ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
        String readGeometryKey = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
        if (params != null && params.values().size() > 0) {
            List elements = params.values();
            for (GeneralParameterValue elem : elements) {
                ParameterDescriptor descr;
                String _key;
                ParameterValue val = (ParameterValue)elem;
                if (val == null || "namespace".equals(_key = (descr = val.getDescriptor()).getName().toString()) || _key.equalsIgnoreCase(readGeometryKey) && !readGeom) continue;
                Object value = CoverageUtils.getCvParamValue(_key, val, values);
                DefaultParameterDescriptor pd = new DefaultParameterDescriptor(_key, descr.getValueClass(), null, value);
                parameters.add(pd.createValue());
            }
            return !parameters.isEmpty() ? parameters.toArray(new GeneralParameterValue[parameters.size()]) : new GeneralParameterValue[]{};
        }
        return new GeneralParameterValue[0];
    }

    public static Map<String, Serializable> getParametersKVP(ParameterValueGroup params) {
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        String readGeometryKey = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
        if (params != null && params.values().size() > 0) {
            List list2 = params.values();
            for (ParameterValue val : list2) {
                ParameterDescriptor descr;
                String _key;
                if (val == null || "namespace".equals(_key = (descr = val.getDescriptor()).getName().toString()) || _key.equalsIgnoreCase(readGeometryKey)) continue;
                Object value = val.getValue();
                String text = "";
                text = value == null ? null : (value instanceof String ? (String)value : value.toString());
                parameters.put(_key, (Serializable)((Object)(text != null ? text : "")));
            }
            return parameters;
        }
        return parameters;
    }

    public static Object getCvParamValue(String key, ParameterValue param, List paramValues, int index) {
        Object value = null;
        try {
            if (key.equalsIgnoreCase("crs")) {
                if (CoverageUtils.getParamValue(paramValues, index) != null && CoverageUtils.getParamValue(paramValues, index).length() > 0) {
                    if (paramValues.get(index) != null && ((String)paramValues.get(index)).length() > 0) {
                        value = CRS.parseWKT((String)((String)paramValues.get(index)));
                    }
                } else {
                    LOGGER.info("Unable to find a crs for the coverage param, using EPSG:4326");
                    value = CRS.decode((String)"EPSG:4326");
                }
            } else if (key.equalsIgnoreCase("envelope")) {
                String tmp;
                if (CoverageUtils.getParamValue(paramValues, index) != null && CoverageUtils.getParamValue(paramValues, index).length() > 0 && (tmp = CoverageUtils.getParamValue(paramValues, index)).indexOf("[") > 0 && tmp.indexOf("]") > tmp.indexOf("[")) {
                    tmp = tmp.substring(tmp.indexOf("[") + 1, tmp.indexOf("]")).trim();
                    tmp = tmp.replaceAll(",", "");
                    String[] strCoords = tmp.split(" ");
                    double[] coords = new double[strCoords.length];
                    if (strCoords.length == 4) {
                        for (int iT = 0; iT < 4; ++iT) {
                            coords[iT] = Double.parseDouble(strCoords[iT].trim());
                        }
                        value = new GeneralEnvelope(new double[]{coords[0], coords[1]}, new double[]{coords[2], coords[3]});
                    }
                }
            } else {
                Class[] clArray = new Class[]{CoverageUtils.getParamValue(paramValues, index).getClass()};
                Object[] inArray = new Object[]{CoverageUtils.getParamValue(paramValues, index)};
                value = param.getValue().getClass().getConstructor(clArray).newInstance(inArray);
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            value = null;
        }
        return value;
    }

    private static String getParamValue(List paramValues, int index) {
        return (String)paramValues.get(index);
    }

    public static Object getCvParamValue(String key, ParameterValue param, Map params) {
        Object value = null;
        try {
            if (key.equalsIgnoreCase("crs")) {
                if (params.get(key) != null && ((String)params.get(key)).length() > 0) {
                    value = CRS.parseWKT((String)((String)params.get(key)));
                } else {
                    LOGGER.info("Unable to find a crs for the coverage param, using EPSG:4326");
                    value = CRS.decode((String)"EPSG:4326");
                }
            } else if (key.equalsIgnoreCase("envelope")) {
                String tmp;
                if (params.get(key) != null && ((String)params.get(key)).length() > 0 && (tmp = (String)params.get(key)).indexOf("[") > 0 && tmp.indexOf("]") > tmp.indexOf("[")) {
                    tmp = tmp.substring(tmp.indexOf("[") + 1, tmp.indexOf("]")).trim();
                    tmp = tmp.replaceAll(",", "");
                    String[] strCoords = tmp.split(" ");
                    double[] coords = new double[strCoords.length];
                    if (strCoords.length == 4) {
                        for (int iT = 0; iT < 4; ++iT) {
                            coords[iT] = Double.parseDouble(strCoords[iT].trim());
                        }
                        value = new GeneralEnvelope(new double[]{coords[0], coords[1]}, new double[]{coords[2], coords[3]});
                    }
                }
            } else if (key.equalsIgnoreCase(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                if (params.get(key) != null && params.get(key) instanceof String && ((String)params.get(key)).length() > 0) {
                    String tmp = (String)params.get(key);
                    if (tmp.indexOf("[") > 0 && tmp.indexOf("]") > tmp.indexOf("[")) {
                        tmp = tmp.substring(tmp.indexOf("[") + 1, tmp.indexOf("]")).trim();
                        tmp = tmp.replaceAll(",", "");
                        String[] strCoords = tmp.split(" ");
                        double[] coords = new double[strCoords.length];
                        if (strCoords.length == 4) {
                            for (int iT = 0; iT < 4; ++iT) {
                                coords[iT] = Double.parseDouble(strCoords[iT].trim());
                            }
                            value = new GeneralEnvelope(new double[]{coords[0], coords[1]}, new double[]{coords[2], coords[3]});
                        }
                    }
                } else if (params.get(key) != null && params.get(key) instanceof GeneralGridGeometry) {
                    value = params.get(key);
                }
            } else {
                Class target = param.getDescriptor().getValueClass();
                if (key.equalsIgnoreCase("InputTransparentColor") || key.equalsIgnoreCase("OutputTransparentColor")) {
                    if (params.get(key) != null) {
                        value = Color.decode((String)params.get(key));
                    } else {
                        Class[] clArray = new Class[]{Color.class};
                        Object[] inArray = new Object[]{params.get(key)};
                        value = target.getConstructor(clArray).newInstance(inArray);
                    }
                } else if (key.equalsIgnoreCase("BackgroundValues")) {
                    if (params.get(key) != null) {
                        String temp = (String)params.get(key);
                        String[] elements = temp.split(",");
                        double[] backgroundValues = new double[elements.length];
                        for (int i = 0; i < elements.length; ++i) {
                            backgroundValues[i] = Double.valueOf(elements[i]);
                        }
                        value = backgroundValues;
                    }
                } else if (key.equalsIgnoreCase("InputImageThresholdValue")) {
                    if (params.get(key) != null) {
                        String temp = (String)params.get(key);
                        value = Double.valueOf(temp);
                    }
                } else if (key.equalsIgnoreCase("Filter")) {
                    Object sfilter = params.get(key);
                    if (sfilter != null) {
                        if (sfilter instanceof String) {
                            value = ECQL.toFilter((String)((String)sfilter));
                        } else if (sfilter instanceof Filter) {
                            value = sfilter;
                        }
                    } else {
                        value = param.getValue();
                    }
                } else {
                    value = params.get(key);
                    if (value != null) {
                        Object converted = Converters.convert((Object)value, (Class)target);
                        if (converted == null) {
                            throw new RuntimeException("Failed to convert " + value + " to " + target.getName());
                        }
                        value = converted;
                    }
                }
            }
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            value = param.getValue();
        }
        return value;
    }

    public static GeneralParameterValue[] mergeParameter(List<GeneralParameterDescriptor> parameterDescriptors, GeneralParameterValue[] readParameters, Object value, String ... parameterAliases) {
        HashSet<String> aliases = new HashSet<String>(Arrays.asList(parameterAliases));
        for (GeneralParameterDescriptor pd : parameterDescriptors) {
            if (!aliases.contains(pd.getName().getCode())) continue;
            ParameterValue pv = (ParameterValue)pd.createValue();
            pv.setValue(value);
            int existingPvIndex = -1;
            for (int i = 0; i < readParameters.length && existingPvIndex < 0; ++i) {
                GeneralParameterValue oldPv = readParameters[i];
                if (!aliases.contains(oldPv.getDescriptor().getName().getCode())) continue;
                existingPvIndex = i;
            }
            if (existingPvIndex >= 0) {
                GeneralParameterValue[] clone = new GeneralParameterValue[readParameters.length];
                System.arraycopy(readParameters, 0, clone, 0, readParameters.length);
                clone[existingPvIndex] = pv;
                readParameters = clone;
                break;
            }
            GeneralParameterValue[] clone = new GeneralParameterValue[readParameters.length + 1];
            System.arraycopy(readParameters, 0, clone, 0, readParameters.length);
            clone[readParameters.length] = pv;
            readParameters = clone;
            break;
        }
        return readParameters;
    }
}

