/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public final class CoverageStoreUtils {
    public static final Format[] formats = GridFormatFinder.getFormatArray();

    private CoverageStoreUtils() {
    }

    public static Format acquireFormat(String type) throws IOException {
        Format format = null;
        for (Format value : GridFormatFinder.getFormatArray()) {
            if (!value.getName().equals(type)) continue;
            format = value;
            break;
        }
        if (format == null) {
            throw new IOException("Cannot handle format: " + type);
        }
        return format;
    }

    public static ParameterValue find(Format format, String key) {
        return CoverageStoreUtils.find(format.getReadParameters(), key);
    }

    public static ParameterValue find(ParameterValueGroup params, String key) {
        List list2 = params.values();
        for (ParameterValue val : list2) {
            ParameterDescriptor descr = val.getDescriptor();
            if (!key.equalsIgnoreCase(descr.getName().toString())) continue;
            return val;
        }
        return null;
    }

    public static Format aquireFactoryByType(String type) {
        Format[] formats = GridFormatFinder.getFormatArray();
        Format format = null;
        for (Format value : formats) {
            format = value;
            if (!format.getName().equals(type)) continue;
            return format;
        }
        return null;
    }

    public static Format aquireFactory(String description) {
        Format[] formats = GridFormatFinder.getFormatArray();
        Format format = null;
        for (Format value : formats) {
            format = value;
            if (!format.getDescription().equals(description)) continue;
            return format;
        }
        return null;
    }

    public static List<String> listDataFormatsDescriptions() {
        Format[] formats;
        ArrayList<String> list2 = new ArrayList<String>();
        for (Format format : formats = GridFormatFinder.getFormatArray()) {
            if (list2.contains(format.getDescription())) continue;
            list2.add(format.getDescription());
        }
        return Collections.synchronizedList(list2);
    }

    public static List<Format> listDataFormats() {
        Format[] formats;
        ArrayList<Format> list2 = new ArrayList<Format>();
        for (Format format : formats = GridFormatFinder.getFormatArray()) {
            if (list2.contains(format)) continue;
            list2.add(format);
        }
        return Collections.synchronizedList(list2);
    }

    public static Map defaultParams(String description) {
        return Collections.synchronizedMap(CoverageStoreUtils.defaultParams(CoverageStoreUtils.aquireFactory(description)));
    }

    public static Map<String, Object> defaultParams(Format factory) {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        ParameterValueGroup params = factory.getReadParameters();
        if (params != null) {
            List list2 = params.values();
            Iterator it = list2.iterator();
            ParameterDescriptor descr = null;
            ParameterValue val = null;
            while (it.hasNext()) {
                val = (ParameterValue)it.next();
                descr = val.getDescriptor();
                String key = descr.getName().toString();
                Object value = null;
                if (val.getValue() != null) {
                    value = "values_palette".equalsIgnoreCase(key) ? val.getValue() : val.getValue().toString();
                }
                if (value == null) {
                    value = "";
                }
                if (value == null) continue;
                defaults.put(key, value);
            }
        }
        return Collections.synchronizedMap(defaults);
    }

    public static Map<String, Object> toParams(GridFormatFactorySpi factory, Map<String, ?> params) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(params.size());
        ParameterValueGroup info = factory.createFormat().getReadParameters();
        for (String key : params.keySet()) {
            Object value = CoverageStoreUtils.find(info, key).getValue();
            if (value == null) continue;
            map.put(key, value);
        }
        return Collections.synchronizedMap(map);
    }

    public static GeneralEnvelope getWGS84LonLatEnvelope(GeneralEnvelope envelope) throws IndexOutOfBoundsException, FactoryException, TransformException {
        CoordinateReferenceSystem sourceCRS = envelope.getCoordinateReferenceSystem();
        if (CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)DefaultGeographicCRS.WGS84)) {
            return new GeneralEnvelope((Envelope)envelope);
        }
        DefaultGeographicCRS targetCRS = DefaultGeographicCRS.WGS84;
        GeneralEnvelope targetEnvelope = !CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)targetCRS) ? CRS.transform((Envelope)envelope, (CoordinateReferenceSystem)targetCRS) : new GeneralEnvelope((Envelope)envelope);
        targetEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)targetCRS);
        return targetEnvelope;
    }
}

