/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.json.JettisonMappedXmlDriver;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.mapped.Configuration;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterInitializer;
import org.geoserver.platform.GeoServerExtensions;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class XStreamPersisterFactory
implements ApplicationContextAware {
    private List<XStreamPersisterInitializer> initializers;
    private ApplicationContext applicationContext;

    public XStreamPersister createXMLPersister() {
        return this.buildPersister(null);
    }

    public XStreamPersister createJSONPersister() {
        boolean alwaysSerializeCollectionsAsArray = false;
        return this.createJSONPersister(alwaysSerializeCollectionsAsArray);
    }

    public XStreamPersister createJSONPersister(boolean alwaysSerializeCollectionsAsArray) {
        Configuration configuration = new Configuration();
        configuration.setRootElementArrayWrapper(false);
        JettisonMappedXmlDriver driver = new JettisonMappedXmlDriver(configuration, alwaysSerializeCollectionsAsArray);
        return this.buildPersister((HierarchicalStreamDriver)driver);
    }

    private XStreamPersister buildPersister(HierarchicalStreamDriver driver) {
        XStreamPersister persister = new XStreamPersister(driver);
        for (XStreamPersisterInitializer initializer : this.getInitializers()) {
            initializer.init(persister);
        }
        return persister;
    }

    private List<XStreamPersisterInitializer> getInitializers() {
        if (this.initializers == null || this.initializers.isEmpty()) {
            this.initializers = this.applicationContext == null ? new ArrayList<XStreamPersisterInitializer>(GeoServerExtensions.extensions(XStreamPersisterInitializer.class)) : new ArrayList<XStreamPersisterInitializer>(GeoServerExtensions.extensions(XStreamPersisterInitializer.class, (ApplicationContext)this.applicationContext));
        }
        return this.initializers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.initializers = new ArrayList<XStreamPersisterInitializer>(GeoServerExtensions.extensions(XStreamPersisterInitializer.class, (ApplicationContext)applicationContext));
    }

    public void addInitializer(XStreamPersisterInitializer initializer) {
        this.getInitializers().add(initializer);
    }

    public boolean removeInitializer(XStreamPersisterInitializer initializer) {
        return this.getInitializers().remove(initializer);
    }
}

