/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.impl;

import java.lang.reflect.Proxy;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFacade;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.CoverageAccessInfoImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.util.logging.Logging;

public class DefaultGeoServerFacade
implements GeoServerFacade {
    static final Logger LOGGER = Logging.getLogger(DefaultGeoServerFacade.class);
    GeoServerInfo global;
    SettingsInfoLookup settings = new SettingsInfoLookup();
    LoggingInfo logging;
    ServiceInfoLookup services = new ServiceInfoLookup();
    GeoServer geoServer;

    public DefaultGeoServerFacade(GeoServer geoServer) {
        this.geoServer = geoServer;
        this.global = geoServer.getFactory().createGlobal();
        this.logging = geoServer.getFactory().createLogging();
    }

    @Override
    public GeoServer getGeoServer() {
        return this.geoServer;
    }

    @Override
    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    @Override
    public GeoServerInfo getGlobal() {
        if (this.global == null) {
            return null;
        }
        return ModificationProxy.create(this.global, GeoServerInfo.class);
    }

    @Override
    public void setGlobal(GeoServerInfo global) {
        this.resolve(global);
        this.setId(global.getSettings());
        this.global = global;
    }

    @Override
    public void save(GeoServerInfo global) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(global);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        this.geoServer.fireGlobalModified(global, propertyNames, oldValues, newValues);
        proxy.commit();
    }

    @Override
    public SettingsInfo getSettings(WorkspaceInfo workspace) {
        SettingsInfo s = this.settings.findByWorkspace(workspace.getId());
        return s == null ? null : ModificationProxy.create(s, SettingsInfo.class);
    }

    @Override
    public void add(SettingsInfo s) {
        s = DefaultGeoServerFacade.unwrap(s);
        this.setId(s);
        this.settings.add(s);
    }

    @Override
    public void save(SettingsInfo settings) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(settings);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        settings = (SettingsInfo)proxy.getProxyObject();
        this.geoServer.fireSettingsModified(settings, propertyNames, oldValues, newValues);
        proxy.commit();
    }

    @Override
    public void remove(SettingsInfo s) {
        s = DefaultGeoServerFacade.unwrap(s);
        this.settings.remove(s.getId());
    }

    @Override
    public LoggingInfo getLogging() {
        if (this.logging == null) {
            return null;
        }
        return ModificationProxy.create(this.logging, LoggingInfo.class);
    }

    @Override
    public void setLogging(LoggingInfo logging) {
        this.logging = logging;
    }

    @Override
    public void save(LoggingInfo logging) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(logging);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        this.geoServer.fireLoggingModified(logging, propertyNames, oldValues, newValues);
        proxy.commit();
    }

    @Override
    public void add(ServiceInfo service) {
        service = DefaultGeoServerFacade.unwrap(service);
        this.setId(service);
        service.setGeoServer(this.geoServer);
        this.services.add(service);
    }

    @Override
    public void save(ServiceInfo service) {
        ModificationProxy proxy = (ModificationProxy)Proxy.getInvocationHandler(service);
        List<String> propertyNames = proxy.getPropertyNames();
        List<Object> oldValues = proxy.getOldValues();
        List<Object> newValues = proxy.getNewValues();
        this.geoServer.fireServiceModified(service, propertyNames, oldValues, newValues);
        proxy.commit();
    }

    @Override
    public void remove(ServiceInfo service) {
        this.services.remove(service.getId());
    }

    @Override
    public <T extends ServiceInfo> T getService(Class<T> clazz) {
        return this.getService((WorkspaceInfo)null, clazz);
    }

    @Override
    public <T extends ServiceInfo> T getService(WorkspaceInfo workspace, Class<T> clazz) {
        List<ServiceInfo> wsServices = this.services.findByWorkspace(workspace);
        Optional<ServiceInfo> found = wsServices.stream().filter(clazz::isInstance).map(clazz::cast).findFirst().map(s -> ModificationProxy.create(s, clazz));
        if (!found.isPresent()) {
            LOGGER.log(Level.FINE, "Could not locate service of type {0} in workspace {1}, available services were {2}", new Object[]{clazz, workspace, wsServices});
        }
        return (T)((ServiceInfo)found.orElse(null));
    }

    @Override
    public <T extends ServiceInfo> T getService(String id, Class<T> clazz) {
        ServiceInfo serviceInfo = this.services.get(id);
        if (clazz.isInstance(serviceInfo)) {
            return (T)((ServiceInfo)ModificationProxy.create(clazz.cast(serviceInfo), clazz));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Could not locate service of type {0} and id {1}, got {2}", new Object[]{clazz, id, serviceInfo});
        }
        return null;
    }

    @Override
    public <T extends ServiceInfo> T getServiceByName(String name, Class<T> clazz) {
        return this.getServiceByName(name, null, clazz);
    }

    @Override
    public <T extends ServiceInfo> T getServiceByName(String name, WorkspaceInfo workspace, Class<T> clazz) {
        List<ServiceInfo> wsServices = this.services.findByWorkspace(workspace);
        Optional<ServiceInfo> found = wsServices.stream().filter(s -> name.equals(s.getName())).filter(clazz::isInstance).map(clazz::cast).findFirst().map(s -> ModificationProxy.create(s, clazz));
        if (!found.isPresent() && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Could not locate service of type {0} in workspace {1} and name '{2}', available services were {3}", new Object[]{clazz, workspace, name, wsServices});
        }
        return (T)((ServiceInfo)found.orElse(null));
    }

    @Override
    public Collection<? extends ServiceInfo> getServices() {
        return this.getServices(null);
    }

    @Override
    public Collection<? extends ServiceInfo> getServices(WorkspaceInfo workspace) {
        return ModificationProxy.createList(this.services.findByWorkspace(workspace), ServiceInfo.class);
    }

    @Override
    public void dispose() {
        if (this.global != null) {
            this.global.dispose();
        }
        if (this.settings != null) {
            this.settings.clear();
        }
        if (this.services != null) {
            this.services.clear();
        }
    }

    public static <T> T unwrap(T obj) {
        return ModificationProxy.unwrap(obj);
    }

    protected void resolve(GeoServerInfo info) {
        GeoServerInfoImpl global = (GeoServerInfoImpl)info;
        if (global.getMetadata() == null) {
            global.setMetadata(new MetadataMap());
        }
        if (global.getClientProperties() == null) {
            global.setClientProperties(new HashMap<Object, Object>());
        }
        if (global.getCoverageAccess() == null) {
            global.setCoverageAccess(new CoverageAccessInfoImpl());
        }
    }

    public List<ServiceInfo> filter(Collection<ServiceInfo> services, WorkspaceInfo workspace) {
        ArrayList<ServiceInfo> list2 = new ArrayList<ServiceInfo>();
        for (ServiceInfo si : services) {
            if (!this.wsEquals(workspace, si.getWorkspace())) continue;
            list2.add(si);
        }
        return list2;
    }

    boolean wsEquals(WorkspaceInfo ws1, WorkspaceInfo ws2) {
        if (ws1 == null) {
            return ws2 == null;
        }
        return ws1.equals(ws2);
    }

    protected void setId(Object o) {
        if (OwsUtils.get((Object)o, (String)"id") == null) {
            String uid = new UID().toString();
            OwsUtils.set((Object)o, (String)"id", (Object)(o.getClass().getSimpleName() + "-" + uid));
        }
    }

    private static class ServiceInfoLookup {
        private static final String NULL_WORKSPACE_ID = "";
        private Map<String, ServiceInfo> idMap = new ConcurrentHashMap<String, ServiceInfo>();
        private Map<String, Map<String, ServiceInfo>> workspaceIdMap = new ConcurrentHashMap<String, Map<String, ServiceInfo>>();
        private Lock wsLock = new ReentrantLock();

        private ServiceInfoLookup() {
        }

        public void add(ServiceInfo s) {
            this.idMap.put(s.getId(), s);
            String wsId = this.workspaceId(s.getWorkspace());
            this.wsLock.lock();
            try {
                this.workspaceIdMap.computeIfAbsent(wsId, id -> new ConcurrentHashMap()).put(s.getId(), s);
            }
            finally {
                this.wsLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(String id) {
            ServiceInfo s = this.idMap.remove(id);
            if (null != s) {
                String wsid = this.workspaceId(s.getWorkspace());
                this.wsLock.lock();
                try {
                    Map<String, ServiceInfo> byWs = this.workspaceIdMap.get(wsid);
                    byWs.remove(s.getId());
                    if (byWs.isEmpty()) {
                        this.workspaceIdMap.remove(wsid);
                    }
                }
                finally {
                    this.wsLock.unlock();
                }
            }
        }

        public ServiceInfo get(String id) {
            return this.idMap.get(id);
        }

        public void clear() {
            this.idMap.clear();
            this.workspaceIdMap.clear();
        }

        public List<ServiceInfo> findByWorkspace(WorkspaceInfo workspace) {
            String workspaceId = this.workspaceId(workspace);
            return new ArrayList<ServiceInfo>(this.workspaceIdMap.getOrDefault(workspaceId, Collections.emptyMap()).values());
        }

        private String workspaceId(WorkspaceInfo ws) {
            return ws == null ? NULL_WORKSPACE_ID : ws.getId();
        }
    }

    private static class SettingsInfoLookup {
        protected ConcurrentMap<String, SettingsInfo> idMap = new ConcurrentHashMap<String, SettingsInfo>();
        protected ConcurrentMap<String, SettingsInfo> workspaceIdMap = new ConcurrentHashMap<String, SettingsInfo>();

        private SettingsInfoLookup() {
        }

        public SettingsInfo findByWorkspace(String workspaceId) {
            return (SettingsInfo)this.workspaceIdMap.get(workspaceId);
        }

        public void remove(String id) {
            WorkspaceInfo ws;
            SettingsInfo s = (SettingsInfo)this.idMap.remove(id);
            if (null != s && (ws = s.getWorkspace()) != null) {
                this.workspaceIdMap.remove(ws.getId());
            }
        }

        public void clear() {
            this.idMap.clear();
            this.workspaceIdMap.clear();
        }

        public void add(SettingsInfo s) {
            Objects.requireNonNull(s.getWorkspace());
            Objects.requireNonNull(s.getWorkspace().getId());
            this.idMap.put(s.getId(), s);
            this.workspaceIdMap.put(s.getWorkspace().getId(), s);
        }
    }
}

