/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.SpringResourceAdaptor;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.logging.Logging;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

public class GeoServerPropertyConfigurer
extends PropertySourcesPlaceholderConfigurer {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.config");
    Resource configFile;
    protected GeoServerDataDirectory data;
    boolean copyOutTemplate = true;
    String comments;

    public GeoServerPropertyConfigurer(GeoServerDataDirectory data) {
        this.data = data;
    }

    public void setCopyOutTemplate(boolean copyOutTemplate) {
        this.copyOutTemplate = copyOutTemplate;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Resource getConfigFile() {
        return this.configFile;
    }

    public void setLocation(org.springframework.core.io.Resource location) {
        try {
            location = SpringResourceAdaptor.relative(location, this.data.getResourceStore());
            if (location instanceof SpringResourceAdaptor) {
                this.configFile = ((SpringResourceAdaptor)location).getResource();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error reading resource " + location, e);
        }
        super.setLocation(location);
    }

    public void setLocations(org.springframework.core.io.Resource ... locations) {
        throw new UnsupportedOperationException("Only a single location is supported");
    }

    protected void loadProperties(Properties props) throws IOException {
        block14: {
            try {
                super.loadProperties(props);
            }
            catch (FileNotFoundException e) {
                if (this.configFile == null || !this.copyOutTemplate) break block14;
                try (OutputStream fout = this.configFile.out();){
                    props.store(fout, this.comments);
                    fout.flush();
                }
            }
        }
    }

    public void reload() throws IOException {
        if (this.localProperties != null) {
            for (Properties props : this.localProperties) {
                this.loadProperties(props);
            }
        }
    }

    protected String convertPropertyValue(String property) {
        return property.replace("${GEOSERVER_DATA_DIR}", this.data.root().getPath());
    }
}

