/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.MetadataMap;

public class FeatureTypeDimensionsAccessor {
    public static final String DIMENSION_PREFIX = "dim_";
    private final FeatureTypeInfo typeInfo;

    public FeatureTypeDimensionsAccessor(FeatureTypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    public Map<String, DimensionInfo> getCustomDimensions() {
        return this.getCustomDimensions(true);
    }

    public Map<String, DimensionInfo> getCustomDimensions(boolean removePrefix) {
        return this.typeInfo.getMetadata().entrySet().stream().filter(e -> e.getValue() instanceof DimensionInfo && e.getKey() != null && ((String)e.getKey()).startsWith(DIMENSION_PREFIX) && !"elevation".equals(e.getKey()) && !"time".equals(e.getKey())).map(e -> Pair.of((Object)(removePrefix ? ((String)e.getKey()).replaceFirst(DIMENSION_PREFIX, "") : (String)e.getKey()), (Object)((DimensionInfo)e.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (DimensionInfo)e.getValue()));
    }

    public Optional<Class> getBinding(String dimensionName) {
        Optional<Map.Entry<String, DimensionInfo>> dimEntry = this.getCustomDimensionByName(dimensionName);
        Optional<String> attributeNameOpt = dimEntry.map(x -> (DimensionInfo)x.getValue()).map(x -> x.getAttribute());
        if (!attributeNameOpt.isPresent()) {
            return Optional.empty();
        }
        return this.typeInfo.getAttributes().stream().filter(a -> Objects.equals(a.getName(), attributeNameOpt.get())).map(a -> this.getBinding((AttributeTypeInfo)a)).findFirst();
    }

    private Class<?> getBinding(AttributeTypeInfo attributeTypeInfo) {
        try {
            return attributeTypeInfo.getAttribute().getType().getBinding();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MetadataMap getMetadataMap() {
        MetadataMap metadataMap = this.typeInfo.getMetadata();
        if (metadataMap == null) {
            throw new IllegalStateException("Unable to get MetadataMap for feature info: " + this.typeInfo);
        }
        return metadataMap;
    }

    public Optional<Map.Entry<String, DimensionInfo>> getCustomDimensionByName(String dimensionName) {
        if (dimensionName == null) {
            return Optional.empty();
        }
        Serializable dimension = this.getMetadataMap().get(DIMENSION_PREFIX + dimensionName);
        if (!(dimension instanceof DimensionInfo)) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)dimensionName, (Object)((DimensionInfo)dimension)));
    }
}

