/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.impl.LegendInfoImpl;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.styling.NamedStyleImpl;
import org.geotools.styling.Style;
import org.opengis.util.ProgressListener;

public class WMSLayerInfoImpl
extends ResourceInfoImpl
implements WMSLayerInfo {
    public static StyleInfo DEFAULT_ON_REMOTE = new StyleInfoImpl();
    public static String DEFAULT_FORMAT;
    protected String forcedRemoteStyle = "";
    protected String preferredFormat = DEFAULT_FORMAT;
    private List<String> selectedRemoteFormats = new ArrayList<String>();
    private List<String> selectedRemoteStyles = new ArrayList<String>();
    private Double minScale = null;
    private Double maxScale = null;
    private boolean metadataBBoxRespected = false;
    private List<StyleInfo> allAvailableRemoteStyles = new ArrayList<StyleInfo>();

    protected WMSLayerInfoImpl() {
    }

    public WMSLayerInfoImpl(Catalog catalog) {
        super(catalog);
    }

    @Override
    public Layer getWMSLayer(ProgressListener listener) throws IOException {
        return this.catalog.getResourcePool().getWMSLayer(this);
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public WMSStoreInfo getStore() {
        return (WMSStoreInfo)super.getStore();
    }

    @Override
    public void reset() {
        this.selectedRemoteStyles.clear();
        this.selectedRemoteFormats.clear();
        this.forcedRemoteStyle = DEFAULT_ON_REMOTE.getName();
        this.selectedRemoteFormats.addAll(this.availableFormats());
        this.getAllAvailableRemoteStyles().clear();
        this.getAllAvailableRemoteStyles().addAll(this.getRemoteStyleInfos());
        this.selectedRemoteStyles.addAll(this.remoteStyles());
    }

    @Override
    public List<String> remoteStyles() {
        try {
            return this.allAvailableRemoteStyles.stream().map(s -> s.getName()).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to fetch styles for cascaded wms layer " + this.getNativeName());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getForcedRemoteStyle() {
        return this.forcedRemoteStyle;
    }

    @Override
    public void setForcedRemoteStyle(String forcedRemoteStyle) {
        this.forcedRemoteStyle = forcedRemoteStyle == null ? DEFAULT_ON_REMOTE.getName() : forcedRemoteStyle;
    }

    @Override
    public List<String> availableFormats() {
        try {
            return this.getStore().getWebMapServer(null).getCapabilities().getRequest().getGetMap().getFormats().stream().filter(WMSLayerInfoImpl::isImage).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to fetch available formats for cascaded layer " + this.getNativeName());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getPreferredFormat() {
        return this.preferredFormat;
    }

    @Override
    public void setPreferredFormat(String preferredFormat) {
        this.preferredFormat = preferredFormat == null ? DEFAULT_FORMAT : preferredFormat;
    }

    @Override
    public boolean isFormatValid(String format) {
        if (this.preferredFormat.equalsIgnoreCase(format)) {
            return true;
        }
        return this.selectedRemoteFormats.contains(format);
    }

    public static boolean isImage(String format) {
        return format.startsWith("image") && !format.contains("xml") && !format.contains("svg");
    }

    @Override
    public Set<StyleInfo> getStyles() {
        if (this.allAvailableRemoteStyles == null) {
            return null;
        }
        return this.allAvailableRemoteStyles.stream().filter(s -> !this.forcedRemoteStyle.equalsIgnoreCase(s.getName())).filter(s -> this.selectedRemoteStyles.contains(s.getName())).collect(Collectors.toSet());
    }

    @Override
    public StyleInfo getDefaultStyle() {
        if (this.forcedRemoteStyle != null) {
            if (!this.forcedRemoteStyle.isEmpty()) {
                Optional<StyleInfo> defaultRemoteStyle = this.getAllAvailableRemoteStyles().stream().filter(s -> s.getName().equalsIgnoreCase(this.forcedRemoteStyle)).findFirst();
                if (defaultRemoteStyle.isPresent()) {
                    return defaultRemoteStyle.get();
                }
                return DEFAULT_ON_REMOTE;
            }
            return DEFAULT_ON_REMOTE;
        }
        return null;
    }

    @Override
    public Set<StyleInfo> getRemoteStyleInfos() {
        try {
            return this.getWMSLayer(null).getStyles().stream().map(WMSLayerInfoImpl::getStyleInfo).collect(Collectors.toSet());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to fetch available styles for cascaded layer " + this.getNativeName());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            return Collections.emptySet();
        }
    }

    @Override
    public Optional<Style> findRemoteStyleByName(String name) {
        NamedStyleImpl style = new NamedStyleImpl();
        style.setName(name);
        try {
            return this.getWMSLayer(null).getStyles().stream().filter(s -> s.getName().equalsIgnoreCase(name)).map(arg_0 -> WMSLayerInfoImpl.lambda$findRemoteStyleByName$5((Style)style, arg_0)).findFirst();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to fetch available styles for cascaded layer " + this.getNativeName());
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public static StyleInfo getStyleInfo(StyleImpl gtWmsStyle) {
        StyleInfoImpl styleInfo = new StyleInfoImpl();
        styleInfo.setName(gtWmsStyle.getName());
        styleInfo.getMetadata().put("isRemote", Boolean.valueOf(true));
        LegendInfoImpl remoteLegendInfo = new LegendInfoImpl();
        remoteLegendInfo.setOnlineResource((String)gtWmsStyle.getLegendURLs().get(0));
        remoteLegendInfo.setHeight(20);
        remoteLegendInfo.setWidth(20);
        remoteLegendInfo.setFormat("image/png");
        styleInfo.setLegend(remoteLegendInfo);
        return styleInfo;
    }

    public static Style getStyleInfo(StyleInfo styleInfo) {
        NamedStyleImpl gtStyle = new NamedStyleImpl();
        gtStyle.setName(styleInfo.getName());
        return gtStyle;
    }

    @Override
    public boolean isSelectedRemoteStyles(String name) {
        if (name == null) {
            return false;
        }
        if (name.isEmpty()) {
            return true;
        }
        if (this.forcedRemoteStyle.equalsIgnoreCase(name)) {
            return true;
        }
        return this.selectedRemoteStyles.contains(name);
    }

    @Override
    public List<String> getSelectedRemoteFormats() {
        return this.selectedRemoteFormats;
    }

    @Override
    public void setSelectedRemoteFormats(List<String> selectedRemoteFormats) {
        this.selectedRemoteFormats = selectedRemoteFormats;
    }

    @Override
    public List<String> getSelectedRemoteStyles() {
        return this.selectedRemoteStyles;
    }

    @Override
    public void setSelectedRemoteStyles(List<String> selectedRemoteStyles) {
        this.selectedRemoteStyles = selectedRemoteStyles;
    }

    @Override
    public Double getMinScale() {
        return this.minScale;
    }

    @Override
    public void setMinScale(Double minScale) {
        this.minScale = minScale;
    }

    @Override
    public Double getMaxScale() {
        return this.maxScale;
    }

    @Override
    public void setMaxScale(Double maxScale) {
        this.maxScale = maxScale;
    }

    @Override
    public List<StyleInfo> getAllAvailableRemoteStyles() {
        if (this.allAvailableRemoteStyles == null) {
            this.allAvailableRemoteStyles = new ArrayList<StyleInfo>();
        }
        return this.allAvailableRemoteStyles;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.forcedRemoteStyle == null ? 0 : this.forcedRemoteStyle.hashCode());
        result = 31 * result + (this.preferredFormat == null ? 0 : this.preferredFormat.hashCode());
        result = 31 * result + (this.selectedRemoteFormats == null ? 0 : this.selectedRemoteFormats.hashCode());
        result = 31 * result + (this.selectedRemoteStyles == null ? 0 : this.selectedRemoteStyles.hashCode());
        result = 31 * result + (this.allAvailableRemoteStyles == null ? 0 : this.allAvailableRemoteStyles.hashCode());
        result = 31 * result + (this.minScale == null ? 0 : this.minScale.hashCode());
        result = 31 * result + (this.maxScale == null ? 0 : this.maxScale.hashCode());
        result = 31 * result + Boolean.hashCode(this.metadataBBoxRespected);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof WMSLayerInfo)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        WMSLayerInfo other = (WMSLayerInfo)obj;
        if (!Objects.equal((Object)this.forcedRemoteStyle, (Object)other.getForcedRemoteStyle())) {
            return false;
        }
        if (!Objects.equal((Object)this.preferredFormat, (Object)other.getPreferredFormat())) {
            return false;
        }
        if (!Objects.equal(this.selectedRemoteFormats, other.getSelectedRemoteFormats())) {
            return false;
        }
        if (!Objects.equal(this.selectedRemoteStyles, other.getSelectedRemoteStyles())) {
            return false;
        }
        if (!Objects.equal(this.allAvailableRemoteStyles, other.getAllAvailableRemoteStyles())) {
            return false;
        }
        if (!Objects.equal((Object)this.minScale, (Object)other.getMinScale())) {
            return false;
        }
        if (!Objects.equal((Object)this.maxScale, (Object)other.getMaxScale())) {
            return false;
        }
        return other.isMetadataBBoxRespected() == this.metadataBBoxRespected;
    }

    @Override
    public boolean isMetadataBBoxRespected() {
        return this.metadataBBoxRespected;
    }

    @Override
    public void setMetadataBBoxRespected(boolean metadataBBoxRespected) {
        this.metadataBBoxRespected = metadataBBoxRespected;
    }

    private static /* synthetic */ Style lambda$findRemoteStyleByName$5(Style style, StyleImpl s) {
        return style;
    }

    static {
        DEFAULT_ON_REMOTE.setName("");
        DEFAULT_ON_REMOTE.getMetadata().put("isRemote", Boolean.valueOf(true));
        DEFAULT_FORMAT = "image/png";
    }
}

