/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.platform.GeoServerExtensions;
import org.opengis.filter.Filter;

public class LayerGroupStyleListener
implements CatalogListener {
    @Override
    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
    }

    @Override
    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
    }

    @Override
    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
    }

    private void updateLayerGroupStyleNames(LayerGroupInfo groupInfo, List<Pair<StyleInfo, StyleInfo>> changedNameStyles) {
        Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        for (Pair<StyleInfo, StyleInfo> oldAndNew : changedNameStyles) {
            StyleInfo oldStyleName = (StyleInfo)oldAndNew.getLeft();
            Filter containsGroup = Predicates.equal("layers.id", groupInfo.getId());
            Filter stylesContainsGroup = Predicates.contains("layerGroupStyles.layers.id", groupInfo.getId());
            Filter or = Predicates.or(containsGroup, stylesContainsGroup);
            CloseableIterator<LayerGroupInfo> it = catalog.list(LayerGroupInfo.class, or);
            Throwable throwable = null;
            try {
                while (it.hasNext()) {
                    LayerGroupInfo toUpdate = (LayerGroupInfo)it.next();
                    this.updateStyleName(toUpdate.getLayers(), toUpdate.getStyles(), groupInfo, oldStyleName, (StyleInfo)oldAndNew.getRight());
                    for (LayerGroupStyle s : toUpdate.getLayerGroupStyles()) {
                        this.updateStyleName(s.getLayers(), s.getStyles(), groupInfo, oldStyleName, (StyleInfo)oldAndNew.getRight());
                    }
                    catalog.save(toUpdate);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (it == null) continue;
                if (throwable != null) {
                    try {
                        it.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                it.close();
            }
        }
    }

    private void updateStyleName(List<PublishedInfo> publishedInfos, List<StyleInfo> styles, LayerGroupInfo groupInfo, StyleInfo oldStyleName, StyleInfo newStyleName) {
        StyleInfo styleInfo;
        int groupIndex = publishedInfos.indexOf(groupInfo);
        if (groupIndex != -1 && (styleInfo = styles.get(groupIndex)).getName().equals(oldStyleName.getName())) {
            StyleInfo newName = newStyleName;
            styles.set(groupIndex, newName);
        }
    }

    private List<Pair<StyleInfo, StyleInfo>> findChangedNameStyles(List<LayerGroupStyle> news) {
        Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        ArrayList<Pair<StyleInfo, StyleInfo>> changedStylesNames = new ArrayList<Pair<StyleInfo, StyleInfo>>();
        for (LayerGroupStyle groupStyle : news) {
            Object newNameInfo;
            ModificationProxy nameProxy;
            int index;
            ModificationProxy styleProxy = this.getModificationProxy(groupStyle);
            if (styleProxy == null || (index = styleProxy.getPropertyNames().indexOf("name")) == -1 || (index = (nameProxy = this.getModificationProxy(newNameInfo = styleProxy.getNewValues().get(index))).getPropertyNames().indexOf("name")) == -1) continue;
            String oldName = (String)nameProxy.getOldValues().get(index);
            String newName = (String)nameProxy.getNewValues().get(index);
            if (oldName == null || newName == null) continue;
            StyleInfoImpl oldStyleInfo = new StyleInfoImpl(catalog);
            oldStyleInfo.setName(oldName);
            StyleInfoImpl newStyleInfo = new StyleInfoImpl(catalog);
            newStyleInfo.setName(newName);
            changedStylesNames.add((Pair<StyleInfo, StyleInfo>)new ImmutablePair((Object)oldStyleInfo, (Object)newStyleInfo));
        }
        return changedStylesNames;
    }

    private ModificationProxy getModificationProxy(Object o) {
        ModificationProxy modProxy = null;
        if (o instanceof Proxy) {
            modProxy = (ModificationProxy)Proxy.getInvocationHandler(o);
        }
        return modProxy;
    }

    @Override
    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        CatalogInfo source = event.getSource();
        if (source instanceof LayerGroupInfo) {
            List newStyles;
            List<Pair<StyleInfo, StyleInfo>> changedNames;
            LayerGroupInfo lg = (LayerGroupInfo)event.getSource();
            int nameIdx = event.getPropertyNames().indexOf("layerGroupStyles");
            if (nameIdx != -1 && !(changedNames = this.findChangedNameStyles(newStyles = (List)event.getNewValues().get(nameIdx))).isEmpty()) {
                this.updateLayerGroupStyleNames(lg, changedNames);
            }
        }
    }

    @Override
    public void reloaded() {
    }
}

