/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ValidationException;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.filter.visitor.ExpressionTypeVisitor;
import org.geotools.util.Converters;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

class FeatureTypeValidator {
    FeatureTypeValidator() {
    }

    public void validate(FeatureTypeInfo fti) {
        List<AttributeTypeInfo> attributes = fti.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        try {
            DataAccess<? extends FeatureType, ? extends Feature> access = fti.getStore().getDataStore(null);
            if (!(access instanceof DataStore)) {
                return;
            }
            DataStore ds = (DataStore)access;
            SimpleFeatureType ft = ds.getSchema(fti.getNativeName());
            Map<String, AttributeDescriptor> nativeAttributes = ft.getAttributeDescriptors().stream().collect(Collectors.toMap(ad -> ad.getLocalName(), ad -> ad));
            HashSet<String> names = new HashSet<String>();
            for (AttributeTypeInfo attribute : attributes) {
                this.validate(attribute, ft, nativeAttributes);
                String name = attribute.getName();
                if (names.contains(name)) {
                    throw new ValidationException("multiAttributeSameName", "Found multiple definitions for output attribute {0}", name);
                }
                names.add(name);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to access data source to check attribute customization", e);
        }
    }

    private void validate(AttributeTypeInfo attribute, SimpleFeatureType schema, Map<String, AttributeDescriptor> nativeAttributes) {
        try {
            ExpressionTypeVisitor typeVisitor;
            Class expressionType;
            if (attribute.getName() == null || attribute.getName().isEmpty()) {
                throw new ValidationException("attributeNullName", "Attribute name must not be null or empty", new Object[0]);
            }
            if (attribute.getSource() == null || attribute.getSource().isEmpty()) {
                throw new ValidationException("attributeNullSource", "Attribute source must not be null or empty", new Object[0]);
            }
            Expression expression = ECQL.toExpression((String)attribute.getSource());
            FilterAttributeExtractor extractor = new FilterAttributeExtractor(schema);
            expression.accept((ExpressionVisitor)extractor, null);
            HashSet usedSourceAttributes = new HashSet(extractor.getAttributeNameSet());
            usedSourceAttributes.removeAll(nativeAttributes.keySet());
            if (!usedSourceAttributes.isEmpty()) {
                throw new ValidationException("cqlUsesInvalidAttribute", "The CQL source expression for attribute {0} refers to attributes unavailable in the data source: {1}", attribute.getName(), usedSourceAttributes);
            }
            Class<?> binding = attribute.getBinding();
            if (binding != null && !Object.class.equals((Object)(expressionType = (Class)expression.accept((ExpressionVisitor)(typeVisitor = new ExpressionTypeVisitor((FeatureType)schema)), null))) && !expressionType.equals(binding) && !binding.equals(String.class) && Converters.getConverterFactories((Class)expressionType, binding).isEmpty()) {
                throw new ValidationException("attributeInvalidConversion", "Issue found in attribute {0}, unable to convert from native type, {1}, to target type, {2}", attribute.getName(), expressionType.getName(), binding.getName());
            }
        }
        catch (CQLException e) {
            throw new ValidationException("attributeInvalidCQL", "Invalid CQL for {0} source. {1}", attribute.getName(), e.getMessage());
        }
    }
}

