/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogCapabilities;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CatalogValidator;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LockingCatalogFacade;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.SLDNamedLayerValidator;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.catalog.ValidationResult;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogBeforeAddEvent;
import org.geoserver.catalog.event.CatalogEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.event.impl.CatalogAddEventImpl;
import org.geoserver.catalog.event.impl.CatalogBeforeAddEventImpl;
import org.geoserver.catalog.event.impl.CatalogModifyEventImpl;
import org.geoserver.catalog.event.impl.CatalogPostModifyEventImpl;
import org.geoserver.catalog.event.impl.CatalogRemoveEventImpl;
import org.geoserver.catalog.impl.CatalogFactoryImpl;
import org.geoserver.catalog.impl.CoverageDimensionImpl;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.DefaultCatalogFacade;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeValidator;
import org.geoserver.catalog.impl.IsolatedCatalogFacade;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.catalog.impl.WMSLayerInfoImpl;
import org.geoserver.catalog.impl.WMTSLayerInfoImpl;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class CatalogImpl
implements Catalog {
    private static final Logger LOGGER = Logging.getLogger(CatalogImpl.class);
    protected CatalogFacade facade;
    protected List<CatalogListener> listeners = new CopyOnWriteArrayList<CatalogListener>();
    protected ResourcePool resourcePool;
    protected GeoServerResourceLoader resourceLoader;
    protected boolean extendedValidation = true;

    public CatalogImpl() {
        this.facade = new DefaultCatalogFacade(this);
        this.facade = new IsolatedCatalogFacade(this.facade);
        this.setFacade(this.facade);
        this.resourcePool = ResourcePool.create(this);
    }

    @Override
    public CatalogFacade getFacade() {
        return this.facade;
    }

    public void setExtendedValidation(boolean extendedValidation) {
        this.extendedValidation = extendedValidation;
    }

    public boolean isExtendedValidation() {
        return this.extendedValidation;
    }

    public Iterable<CatalogValidator> getValidators() {
        return GeoServerExtensions.extensions(CatalogValidator.class);
    }

    public void setFacade(CatalogFacade facade) {
        GeoServerConfigurationLock configurationLock = (GeoServerConfigurationLock)GeoServerExtensions.bean(GeoServerConfigurationLock.class);
        if (configurationLock != null) {
            facade = LockingCatalogFacade.create(facade, configurationLock);
        }
        this.facade = facade;
        facade.setCatalog(this);
    }

    @Override
    public String getId() {
        return "catalog";
    }

    @Override
    public CatalogFactory getFactory() {
        return new CatalogFactoryImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(StoreInfo store) {
        StoreInfo added;
        if (store.getWorkspace() == null) {
            store.setWorkspace(this.getDefaultWorkspace());
        }
        this.validate(store, true);
        CatalogFacade catalogFacade = this.facade;
        synchronized (catalogFacade) {
            StoreInfo resolved = this.resolve(store);
            this.beforeadded(resolved);
            added = this.facade.add(resolved);
            if (this.getDefaultDataStore(store.getWorkspace()) == null && store instanceof DataStoreInfo) {
                this.setDefaultDataStore(store.getWorkspace(), (DataStoreInfo)store);
            }
        }
        this.added(added);
    }

    @Override
    public ValidationResult validate(StoreInfo store, boolean isNew) {
        if (this.isNull(store.getName())) {
            throw new IllegalArgumentException("Store name must not be null");
        }
        if (store.getWorkspace() == null) {
            throw new IllegalArgumentException("Store must be part of a workspace");
        }
        WorkspaceInfo workspace = store.getWorkspace();
        StoreInfo existing = this.getStoreByName(workspace, store.getName(), StoreInfo.class);
        if (existing != null && (isNew || !existing.getId().equals(store.getId()))) {
            String msg = "Store '" + store.getName() + "' already exists in workspace '" + workspace.getName() + "'";
            throw new IllegalArgumentException(msg);
        }
        return this.postValidate(store, isNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public void remove(StoreInfo store) {
        if (!this.getResourcesByStore(store, ResourceInfo.class).isEmpty()) {
            throw new IllegalArgumentException("Unable to delete non-empty store.");
        }
        CatalogFacade catalogFacade = this.facade;
        synchronized (catalogFacade) {
            this.facade.remove(store);
            WorkspaceInfo workspace = store.getWorkspace();
            DataStoreInfo defaultStore = this.getDefaultDataStore(workspace);
            if (store.equals(defaultStore) || defaultStore == null) {
                this.setDefaultDataStore(workspace, null);
                List<DataStoreInfo> dstores = this.getStoresByWorkspace(workspace, DataStoreInfo.class);
                if (!dstores.isEmpty()) {
                    this.setDefaultDataStore(workspace, dstores.get(0));
                }
            }
        }
        this.removed(store);
    }

    @Override
    public void save(StoreInfo store) {
        if (store.getId() == null) {
            this.add(store);
            return;
        }
        this.validate(store, false);
        this.facade.save(store);
    }

    @Override
    public <T extends StoreInfo> T detach(T store) {
        return this.detached(store, this.facade.detach(store));
    }

    @Override
    public <T extends StoreInfo> T getStore(String id, Class<T> clazz) {
        return this.facade.getStore(id, clazz);
    }

    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public <T extends StoreInfo> T getStoreByName(String name, Class<T> clazz) {
        return this.getStoreByName((WorkspaceInfo)null, name, clazz);
    }

    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public <T extends StoreInfo> T getStoreByName(WorkspaceInfo workspace, String name, Class<T> clazz) {
        WorkspaceInfo ws = workspace;
        if (ws == null) {
            ws = this.getDefaultWorkspace();
        }
        if (clazz != null && clazz.isAssignableFrom(DataStoreInfo.class) && (name == null || name.equals("default"))) {
            DataStoreInfo cast = this.getDefaultDataStore(workspace);
            return (T)cast;
        }
        T store = this.facade.getStoreByName(ws, name, clazz);
        if (store == null && workspace == null) {
            store = this.facade.getStoreByName(CatalogFacade.ANY_WORKSPACE, name, clazz);
        }
        return store;
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(String workspaceName, String name, Class<T> clazz) {
        WorkspaceInfo workspace = this.getWorkspaceByName(workspaceName);
        if (workspace != null) {
            return this.getStoreByName(workspace, name, clazz);
        }
        return null;
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(String workspaceName, Class<T> clazz) {
        WorkspaceInfo workspace = null;
        if (workspaceName != null && (workspace = this.getWorkspaceByName(workspaceName)) == null) {
            return Collections.emptyList();
        }
        return this.getStoresByWorkspace(workspace, clazz);
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(WorkspaceInfo workspace, Class<T> clazz) {
        return this.facade.getStoresByWorkspace(workspace, clazz);
    }

    @Override
    public <T extends StoreInfo> List<T> getStores(Class<T> clazz) {
        return this.facade.getStores(clazz);
    }

    @Override
    public WMSStoreInfo getWMSStore(String id) {
        return this.getStore(id, WMSStoreInfo.class);
    }

    @Override
    public WMSStoreInfo getWMSStoreByName(String name) {
        return this.getStoreByName(name, WMSStoreInfo.class);
    }

    @Override
    public WMTSStoreInfo getWMTSStore(String id) {
        return this.getStore(id, WMTSStoreInfo.class);
    }

    @Override
    public WMTSStoreInfo getWMTSStoreByName(String name) {
        return this.getStoreByName(name, WMTSStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDataStore(String id) {
        return this.getStore(id, DataStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDataStoreByName(String name) {
        return this.getStoreByName(name, DataStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDataStoreByName(String workspaceName, String name) {
        return this.getStoreByName(workspaceName, name, DataStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDataStoreByName(WorkspaceInfo workspace, String name) {
        return this.getStoreByName(workspace, name, DataStoreInfo.class);
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(String workspaceName) {
        return this.getStoresByWorkspace(workspaceName, DataStoreInfo.class);
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(WorkspaceInfo workspace) {
        return this.getStoresByWorkspace(workspace, DataStoreInfo.class);
    }

    @Override
    public List<DataStoreInfo> getDataStores() {
        return this.getStores(DataStoreInfo.class);
    }

    @Override
    public DataStoreInfo getDefaultDataStore(WorkspaceInfo workspace) {
        return this.facade.getDefaultDataStore(workspace);
    }

    @Override
    public void setDefaultDataStore(WorkspaceInfo workspace, DataStoreInfo store) {
        if (store != null) {
            if (store.getWorkspace() == null) {
                throw new IllegalArgumentException("The store has not been assigned a workspace");
            }
            if (!store.getWorkspace().equals(workspace)) {
                throw new IllegalArgumentException("Trying to mark as default for workspace " + workspace.getName() + " a store that is contained in " + store.getWorkspace().getName());
            }
        }
        this.facade.setDefaultDataStore(workspace, store);
    }

    @Override
    public CoverageStoreInfo getCoverageStore(String id) {
        return this.getStore(id, CoverageStoreInfo.class);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String name) {
        return this.getStoreByName(name, CoverageStoreInfo.class);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String workspaceName, String name) {
        return this.getStoreByName(workspaceName, name, CoverageStoreInfo.class);
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(WorkspaceInfo workspace, String name) {
        return this.getStoreByName(workspace, name, CoverageStoreInfo.class);
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(String workspaceName) {
        return this.getStoresByWorkspace(workspaceName, CoverageStoreInfo.class);
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(WorkspaceInfo workspace) {
        return this.getStoresByWorkspace(workspace, CoverageStoreInfo.class);
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStores() {
        return this.getStores(CoverageStoreInfo.class);
    }

    @Override
    public void add(ResourceInfo resource) {
        if (resource.getNamespace() == null) {
            resource.setNamespace(this.getDefaultNamespace());
        }
        if (resource.getNativeName() == null) {
            resource.setNativeName(resource.getName());
        }
        ResourceInfo resolved = this.resolve(resource);
        this.validate(resolved, true);
        this.beforeadded(resolved);
        ResourceInfo added = this.facade.add(resolved);
        this.added(added);
    }

    @Override
    public ValidationResult validate(ResourceInfo resource, boolean isNew) {
        if (this.isNull(resource.getName())) {
            throw new NullPointerException("Resource name must not be null");
        }
        if (this.isNull(resource.getNativeName()) && (!(resource instanceof CoverageInfo) || ((CoverageInfo)resource).getNativeCoverageName() == null)) {
            throw new NullPointerException("Resource native name must not be null");
        }
        if (resource.getStore() == null) {
            throw new IllegalArgumentException("Resource must be part of a store");
        }
        if (resource.getNamespace() == null) {
            throw new IllegalArgumentException("Resource must be part of a namespace");
        }
        StoreInfo store = resource.getStore();
        ResourceInfo existing = this.getResourceByStore(store, resource.getName(), ResourceInfo.class);
        if (existing != null && !existing.getId().equals(resource.getId())) {
            String msg = "Resource named '" + resource.getName() + "' already exists in store: '" + store.getName() + "'";
            throw new IllegalArgumentException(msg);
        }
        NamespaceInfo namespace = resource.getNamespace();
        existing = this.getResourceByName(namespace, resource.getName(), ResourceInfo.class);
        if (existing != null && !existing.getId().equals(resource.getId())) {
            String msg = "Resource named '" + resource.getName() + "' already exists in namespace: '" + namespace.getPrefix() + "'";
            throw new IllegalArgumentException(msg);
        }
        CatalogImpl.validateKeywords(resource.getKeywords());
        if (resource instanceof FeatureTypeInfo && this.extendedValidation) {
            new FeatureTypeValidator().validate((FeatureTypeInfo)resource);
        }
        return this.postValidate(resource, isNew);
    }

    @Override
    public void remove(ResourceInfo resource) {
        if (!this.getLayers(resource).isEmpty()) {
            throw new IllegalArgumentException("Unable to delete resource referenced by layer");
        }
        this.facade.remove(resource);
        this.removed(resource);
    }

    @Override
    public void save(ResourceInfo resource) {
        this.validate(resource, false);
        this.facade.save(resource);
    }

    @Override
    public <T extends ResourceInfo> T detach(T resource) {
        return this.detached(resource, this.facade.detach(resource));
    }

    @Override
    public <T extends ResourceInfo> T getResource(String id, Class<T> clazz) {
        return this.facade.getResource(id, clazz);
    }

    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public <T extends ResourceInfo> T getResourceByName(String ns, String name, Class<T> clazz) {
        if ("".equals(ns)) {
            ns = null;
        }
        if (ns != null) {
            NamespaceInfo namespace = this.getNamespaceByPrefix(ns);
            if (namespace == null) {
                namespace = this.getNamespaceByURI(ns);
            }
            if (namespace != null) {
                return this.getResourceByName(namespace, name, clazz);
            }
            return null;
        }
        return this.getResourceByName((NamespaceInfo)null, name, clazz);
    }

    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public <T extends ResourceInfo> T getResourceByName(NamespaceInfo ns, String name, Class<T> clazz) {
        T resource;
        NamespaceInfo namespace = ns;
        if (namespace == null) {
            namespace = this.getDefaultNamespace();
        }
        if ((resource = this.facade.getResourceByName(namespace, name, clazz)) == null && ns == null) {
            resource = this.facade.getResourceByName(CatalogFacade.ANY_NAMESPACE, name, clazz);
        }
        return resource;
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(Name name, Class<T> clazz) {
        return this.getResourceByName(name.getNamespaceURI(), name.getLocalPart(), clazz);
    }

    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public <T extends ResourceInfo> T getResourceByName(String name, Class<T> clazz) {
        int colon = name.indexOf(58);
        if (colon != -1) {
            String ns = name.substring(0, colon);
            String localName = name.substring(colon + 1);
            return this.getResourceByName(ns, localName, clazz);
        }
        return this.getResourceByName((String)null, name, clazz);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResources(Class<T> clazz) {
        return this.facade.getResources(clazz);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(NamespaceInfo namespace, Class<T> clazz) {
        return this.facade.getResourcesByNamespace(namespace, clazz);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(String namespace, Class<T> clazz) {
        if (namespace == null) {
            return this.getResourcesByNamespace((NamespaceInfo)null, clazz);
        }
        NamespaceInfo ns = this.getNamespaceByPrefix(namespace);
        if (ns == null) {
            ns = this.getNamespaceByURI(namespace);
        }
        if (ns == null) {
            return Collections.emptyList();
        }
        return this.getResourcesByNamespace(ns, clazz);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByStore(StoreInfo store, String name, Class<T> clazz) {
        return this.facade.getResourceByStore(store, name, clazz);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByStore(StoreInfo store, Class<T> clazz) {
        return this.facade.getResourcesByStore(store, clazz);
    }

    @Override
    public FeatureTypeInfo getFeatureType(String id) {
        return this.getResource(id, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String ns, String name) {
        return this.getResourceByName(ns, name, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(NamespaceInfo ns, String name) {
        return this.getResourceByName(ns, name, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(Name name) {
        return this.getResourceByName(name, FeatureTypeInfo.class);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String name) {
        return this.getResourceByName(name, FeatureTypeInfo.class);
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypes() {
        return this.getResources(FeatureTypeInfo.class);
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByNamespace(NamespaceInfo namespace) {
        return this.getResourcesByNamespace(namespace, FeatureTypeInfo.class);
    }

    public FeatureTypeInfo getFeatureTypeByStore(DataStoreInfo dataStore, String name) {
        return this.getFeatureTypeByDataStore(dataStore, name);
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByDataStore(DataStoreInfo dataStore, String name) {
        return this.getResourceByStore(dataStore, name, FeatureTypeInfo.class);
    }

    public List<FeatureTypeInfo> getFeatureTypesByStore(DataStoreInfo store) {
        return this.getFeatureTypesByDataStore(store);
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByDataStore(DataStoreInfo store) {
        return this.getResourcesByStore(store, FeatureTypeInfo.class);
    }

    @Override
    public CoverageInfo getCoverage(String id) {
        return this.getResource(id, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByName(String ns, String name) {
        return this.getResourceByName(ns, name, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByName(NamespaceInfo ns, String name) {
        return this.getResourceByName(ns, name, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByName(Name name) {
        return this.getResourceByName(name, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByName(String name) {
        return this.getResourceByName(name, CoverageInfo.class);
    }

    @Override
    public List<CoverageInfo> getCoverages() {
        return this.getResources(CoverageInfo.class);
    }

    @Override
    public List<CoverageInfo> getCoveragesByNamespace(NamespaceInfo namespace) {
        return this.getResourcesByNamespace(namespace, CoverageInfo.class);
    }

    @Override
    public List<CoverageInfo> getCoveragesByStore(CoverageStoreInfo store) {
        return this.getResourcesByStore(store, CoverageInfo.class);
    }

    @Override
    public CoverageInfo getCoverageByCoverageStore(CoverageStoreInfo coverageStore, String name) {
        return this.getResourceByStore(coverageStore, name, CoverageInfo.class);
    }

    @Override
    public List<CoverageInfo> getCoveragesByCoverageStore(CoverageStoreInfo store) {
        return this.getResourcesByStore(store, CoverageInfo.class);
    }

    @Override
    public void add(LayerInfo layer) {
        layer = this.resolve(layer);
        this.validate(layer, true);
        if (layer.getType() == null) {
            if (layer.getResource() instanceof FeatureTypeInfo) {
                layer.setType(PublishedType.VECTOR);
            } else if (layer.getResource() instanceof CoverageInfo) {
                layer.setType(PublishedType.RASTER);
            } else if (layer.getResource() instanceof WMTSLayerInfo) {
                layer.setType(PublishedType.WMTS);
            } else if (layer.getResource() instanceof WMSLayerInfo) {
                layer.setType(PublishedType.WMS);
            } else {
                String msg = "Layer type not set and can't be derived from resource";
                throw new IllegalArgumentException(msg);
            }
        }
        this.beforeadded(layer);
        LayerInfo added = this.facade.add(layer);
        this.added(added);
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public ValidationResult validate(LayerInfo layer, boolean isNew) {
        if (layer.getResource() == null) {
            throw new NullPointerException("Layer resource must not be null");
        }
        NamespaceInfo ns = layer.getResource().getNamespace();
        if (null == this.getResourceByName(ns, layer.getResource().getName(), ResourceInfo.class)) {
            throw new IllegalStateException("Found no resource named " + layer.prefixedName() + " , Layer with that name can't be added");
        }
        String prefix = ns != null ? ns.getPrefix() : null;
        LayerInfo existing = this.getLayerByName(prefix, layer.getName());
        if (existing != null && !existing.getId().equals(layer.getId())) {
            throw new IllegalArgumentException("Layer named '" + layer.getName() + "' in workspace '" + prefix + "' already exists.");
        }
        if (layer.getDefaultStyle() == null) {
            try {
                LOGGER.log(Level.INFO, "Layer " + layer.prefixedName() + " is missing the default style, assigning one automatically");
                StyleInfo style = new CatalogBuilder(this).getDefaultStyle(layer.getResource());
                layer.setDefaultStyle(style);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Layer " + layer.prefixedName() + " is missing the default style, failed to associate one automatically", e);
            }
        }
        Set<StyleInfo> styles = layer.getStyles();
        Iterator<StyleInfo> it = styles.iterator();
        while (it.hasNext()) {
            StyleInfo styleInfo = it.next();
            if (styleInfo != null) continue;
            it.remove();
        }
        return this.postValidate(layer, isNew);
    }

    @Override
    public void remove(LayerInfo layer) {
        for (LayerGroupInfo lg : this.facade.getLayerGroups()) {
            if (!lg.getLayers().contains(layer) && !layer.equals(lg.getRootLayer())) continue;
            String msg = "Unable to delete layer referenced by layer group '" + lg.getName() + "'";
            throw new IllegalArgumentException(msg);
        }
        this.facade.remove(layer);
        this.removed(layer);
    }

    @Override
    public void save(LayerInfo layer) {
        this.validate(layer, false);
        this.facade.save(layer);
    }

    @Override
    public LayerInfo detach(LayerInfo layer) {
        return this.detached(layer, this.facade.detach(layer));
    }

    @Override
    public LayerInfo getLayer(String id) {
        return this.facade.getLayer(id);
    }

    @Override
    public LayerInfo getLayerByName(Name name) {
        NamespaceInfo ns;
        if (name.getNamespaceURI() != null && (ns = this.getNamespaceByURI(name.getNamespaceURI())) != null) {
            return this.getLayerByName(ns.getPrefix() + ":" + name.getLocalPart());
        }
        return this.getLayerByName(name.getLocalPart());
    }

    @Override
    public LayerInfo getLayerByName(String name) {
        LayerInfo result = null;
        int colon = name.indexOf(58);
        if (colon != -1) {
            String prefix = name.substring(0, colon);
            String resource = name.substring(colon + 1);
            result = this.getLayerByName(prefix, resource);
        } else {
            WorkspaceInfo ws = this.getDefaultWorkspace();
            if (ws != null) {
                result = this.getLayerByName(ws.getName(), name);
            }
        }
        if (result == null) {
            result = this.facade.getLayerByName(name);
        }
        return result;
    }

    private LayerInfo getLayerByName(String workspace, String resourceName) {
        ResourceInfo r = this.getResourceByName(workspace, resourceName, ResourceInfo.class);
        if (r == null) {
            return null;
        }
        List<LayerInfo> layers = this.getLayers(r);
        if (layers.size() == 1) {
            return layers.get(0);
        }
        return null;
    }

    @Override
    public List<LayerInfo> getLayers(ResourceInfo resource) {
        return this.facade.getLayers(resource);
    }

    @Override
    public List<LayerInfo> getLayers(StyleInfo style) {
        return this.facade.getLayers(style);
    }

    @Override
    public List<LayerInfo> getLayers() {
        return this.facade.getLayers();
    }

    @Override
    public MapInfo getMap(String id) {
        return this.facade.getMap(id);
    }

    @Override
    public MapInfo getMapByName(String name) {
        return this.facade.getMapByName(name);
    }

    @Override
    public List<MapInfo> getMaps() {
        return this.facade.getMaps();
    }

    @Override
    public void add(LayerGroupInfo layerGroup) {
        layerGroup = this.resolve(layerGroup);
        this.validate(layerGroup, true);
        if (layerGroup.getStyles().isEmpty()) {
            for (PublishedInfo l : layerGroup.getLayers()) {
                layerGroup.getStyles().add(null);
            }
        }
        this.beforeadded(layerGroup);
        LayerGroupInfo added = this.facade.add(layerGroup);
        this.added(added);
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    public ValidationResult validate(LayerGroupInfo layerGroup, boolean isNew) {
        if (this.isNull(layerGroup.getName())) {
            throw new NullPointerException("Layer group name must not be null");
        }
        WorkspaceInfo ws = layerGroup.getWorkspace();
        LayerGroupInfo existing = this.getLayerGroupByName(ws, layerGroup.getName());
        if (existing != null && !existing.getId().equals(layerGroup.getId())) {
            WorkspaceInfo ews = existing.getWorkspace();
            if (ws == null && ews == null || ws != null && ws.equals(ews)) {
                String msg = "Layer group named '" + layerGroup.getName() + "' already exists";
                if (ws != null) {
                    msg = msg + " in workspace " + ws.getName();
                }
                throw new IllegalArgumentException(msg);
            }
        }
        List<PublishedInfo> layers = layerGroup.getLayers();
        List<StyleInfo> styles = layerGroup.getStyles();
        int i = 0;
        while (i < layers.size()) {
            if (layers != null && styles != null && layers.get(i) == null && styles.get(i) == null) {
                layers.remove(i);
                styles.remove(i);
                continue;
            }
            if (layers.get(i) == null) {
                try {
                    StyledLayerDescriptor sld = styles.get(i).getSLD();
                    List<Exception> errors = SLDNamedLayerValidator.validate(this, sld);
                    if (!errors.isEmpty()) {
                        throw new IllegalArgumentException("Invalid style group: " + errors.get(0).getMessage(), errors.get(0));
                    }
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Error validating style group: " + e.getMessage(), e);
                }
            }
            ++i;
        }
        if (layerGroup.getLayers() == null || layerGroup.getLayers().isEmpty()) {
            throw new IllegalArgumentException("Layer group must not be empty");
        }
        if (layerGroup.getStyles() != null && !layerGroup.getStyles().isEmpty() && layerGroup.getStyles().size() != layerGroup.getLayers().size()) {
            throw new IllegalArgumentException("Layer group has different number of styles than layers");
        }
        LayerGroupHelper helper = new LayerGroupHelper(layerGroup);
        Stack<LayerGroupInfo> loopPath = helper.checkLoops();
        if (loopPath != null) {
            throw new IllegalArgumentException("Layer group is in a loop: " + helper.getLoopAsString(loopPath));
        }
        if (ws != null) {
            this.checkLayerGroupResourceIsInWorkspace(layerGroup, ws);
        }
        if (layerGroup.getMode() == null) {
            throw new IllegalArgumentException("Layer group mode must not be null");
        }
        if (LayerGroupInfo.Mode.EO.equals((Object)layerGroup.getMode())) {
            if (layerGroup.getRootLayer() == null) {
                throw new IllegalArgumentException("Layer group in mode " + LayerGroupInfo.Mode.EO.getName() + " must have a root layer");
            }
            if (layerGroup.getRootLayerStyle() == null) {
                throw new IllegalArgumentException("Layer group in mode " + LayerGroupInfo.Mode.EO.getName() + " must have a root layer style");
            }
        } else {
            if (layerGroup.getRootLayer() != null) {
                throw new IllegalArgumentException("Layer group in mode " + layerGroup.getMode().getName() + " must not have a root layer");
            }
            if (layerGroup.getRootLayerStyle() != null) {
                throw new IllegalArgumentException("Layer group in mode " + layerGroup.getMode().getName() + " must not have a root layer style");
            }
        }
        return this.postValidate(layerGroup, isNew);
    }

    private void checkLayerGroupResourceIsInWorkspace(LayerGroupInfo layerGroup, WorkspaceInfo ws) {
        if (layerGroup == null) {
            return;
        }
        if (layerGroup.getWorkspace() != null && !ws.equals(layerGroup.getWorkspace())) {
            throw new IllegalArgumentException("Layer group within a workspace (" + ws.getName() + ") can not contain resources from other workspace: " + layerGroup.getWorkspace().getName());
        }
        this.checkLayerGroupResourceIsInWorkspace(layerGroup, layerGroup.getRootLayer(), ws);
        this.checkLayerGroupResourceIsInWorkspace(layerGroup.getRootLayerStyle(), ws);
        List<PublishedInfo> layers = layerGroup.getLayers();
        if (layers != null) {
            for (PublishedInfo p : layers) {
                if (p instanceof LayerGroupInfo) {
                    this.checkLayerGroupResourceIsInWorkspace((LayerGroupInfo)p, ws);
                    continue;
                }
                if (!(p instanceof LayerInfo)) continue;
                this.checkLayerGroupResourceIsInWorkspace(layerGroup, (LayerInfo)p, ws);
            }
        }
        if (layerGroup.getStyles() != null) {
            for (StyleInfo s : layerGroup.getStyles()) {
                this.checkLayerGroupResourceIsInWorkspace(s, ws);
            }
        }
    }

    private void checkLayerGroupResourceIsInWorkspace(StyleInfo style, WorkspaceInfo ws) {
        if (style == null) {
            return;
        }
        if (style.getWorkspace() != null && !ws.equals(style.getWorkspace())) {
            throw new IllegalArgumentException("Layer group within a workspace (" + ws.getName() + ") can not contain styles from other workspace: " + style.getWorkspace());
        }
    }

    private void checkLayerGroupResourceIsInWorkspace(LayerGroupInfo layerGroup, LayerInfo layer, WorkspaceInfo ws) {
        if (layer == null) {
            return;
        }
        ResourceInfo r = layer.getResource();
        if (r == null) {
            throw new IllegalArgumentException("Layer group " + layerGroup.getName() + " references a layer (" + layer.getId() + ") without a proper Resource attached");
        }
        if (r.getStore().getWorkspace() != null && !ws.equals(r.getStore().getWorkspace())) {
            throw new IllegalArgumentException("Layer group within a workspace (" + ws.getName() + ") can not contain resources from other workspace: " + r.getStore().getWorkspace().getName());
        }
    }

    @Override
    public void remove(LayerGroupInfo layerGroup) {
        for (LayerGroupInfo lg : this.facade.getLayerGroups()) {
            if (!lg.getLayers().contains(layerGroup)) continue;
            String msg = "Unable to delete layer group referenced by layer group '" + lg.getName() + "'";
            throw new IllegalArgumentException(msg);
        }
        this.facade.remove(layerGroup);
        this.removed(layerGroup);
    }

    @Override
    public void save(LayerGroupInfo layerGroup) {
        this.validate(layerGroup, false);
        this.facade.save(layerGroup);
    }

    @Override
    public LayerGroupInfo detach(LayerGroupInfo layerGroup) {
        return this.detached(layerGroup, this.facade.detach(layerGroup));
    }

    @Override
    public List<LayerGroupInfo> getLayerGroups() {
        return this.facade.getLayerGroups();
    }

    @Override
    public List<LayerGroupInfo> getLayerGroupsByWorkspace(String workspaceName) {
        WorkspaceInfo workspace = null;
        if (workspaceName != null && (workspace = this.getWorkspaceByName(workspaceName)) == null) {
            return Collections.emptyList();
        }
        return this.getLayerGroupsByWorkspace(workspace);
    }

    @Override
    public List<LayerGroupInfo> getLayerGroupsByWorkspace(WorkspaceInfo workspace) {
        return this.facade.getLayerGroupsByWorkspace(workspace);
    }

    @Override
    public LayerGroupInfo getLayerGroup(String id) {
        return this.facade.getLayerGroup(id);
    }

    @Override
    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public LayerGroupInfo getLayerGroupByName(String name) {
        LayerGroupInfo layerGroup = this.getLayerGroupByName((String)null, name);
        if (layerGroup != null) {
            return layerGroup;
        }
        String workspaceName = null;
        String layerGroupName = null;
        int colon = name.indexOf(58);
        if (colon == -1) {
            WorkspaceInfo defaultWs = this.getDefaultWorkspace();
            workspaceName = defaultWs == null ? null : defaultWs.getName();
            layerGroupName = name;
        }
        if (colon != -1) {
            workspaceName = name.substring(0, colon);
            layerGroupName = name.substring(colon + 1);
        }
        return this.getLayerGroupByName(workspaceName, layerGroupName);
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String workspaceName, String name) {
        WorkspaceInfo workspace = null;
        if (workspaceName != null && (workspace = this.getWorkspaceByName(workspaceName)) == null) {
            return null;
        }
        return this.getLayerGroupByName(workspace, name);
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(WorkspaceInfo workspace, String name) {
        if (null == workspace) {
            workspace = DefaultCatalogFacade.NO_WORKSPACE;
        }
        LayerGroupInfo layerGroup = this.facade.getLayerGroupByName(workspace, name);
        return layerGroup;
    }

    @Override
    public void add(MapInfo map) {
        this.beforeadded(map);
        MapInfo added = this.facade.add(this.resolve(map));
        this.added(added);
    }

    @Override
    public void remove(MapInfo map) {
        this.facade.remove(map);
        this.removed(map);
    }

    @Override
    public void save(MapInfo map) {
        this.facade.save(map);
    }

    @Override
    public MapInfo detach(MapInfo map) {
        return this.detached(map, this.facade.detach(map));
    }

    @Override
    public NamespaceInfo getNamespace(String id) {
        return this.facade.getNamespace(id);
    }

    @Override
    public NamespaceInfo getNamespaceByPrefix(String prefix) {
        NamespaceInfo ns;
        if ((prefix == null || "default".equals(prefix)) && (ns = this.getDefaultNamespace()) != null) {
            prefix = ns.getPrefix();
        }
        return this.facade.getNamespaceByPrefix(prefix);
    }

    @Override
    public NamespaceInfo getNamespaceByURI(String uri) {
        return this.facade.getNamespaceByURI(uri);
    }

    @Override
    public List<NamespaceInfo> getNamespaces() {
        return this.facade.getNamespaces();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(NamespaceInfo namespace) {
        NamespaceInfo added;
        this.validate(namespace, true);
        CatalogFacade catalogFacade = this.facade;
        synchronized (catalogFacade) {
            NamespaceInfo resolved = this.resolve(namespace);
            this.beforeadded(namespace);
            added = this.facade.add(resolved);
            if (this.getDefaultNamespace() == null) {
                this.setDefaultNamespace(resolved);
            }
        }
        this.added(added);
    }

    @Override
    public ValidationResult validate(NamespaceInfo namespace, boolean isNew) {
        if (namespace.isIsolated() && !this.getCatalogCapabilities().supportsIsolatedWorkspaces()) {
            throw new IllegalArgumentException(String.format("Namespace '%s:%s' is isolated but isolated workspaces are not supported by this catalog.", namespace.getPrefix(), namespace.getURI()));
        }
        if (this.isNull(namespace.getPrefix())) {
            throw new NullPointerException("Namespace prefix must not be null");
        }
        if (namespace.getPrefix().equals("default")) {
            throw new IllegalArgumentException("default is a reserved keyword, can't be used as the namespace prefix");
        }
        NamespaceInfo existing = this.getNamespaceByPrefix(namespace.getPrefix());
        if (existing != null && !existing.getId().equals(namespace.getId())) {
            throw new IllegalArgumentException("Namespace with prefix '" + namespace.getPrefix() + "' already exists.");
        }
        if (!namespace.isIsolated() && (existing = this.getNamespaceByURI(namespace.getURI())) != null && !existing.getId().equals(namespace.getId())) {
            throw new IllegalArgumentException("Namespace with URI '" + namespace.getURI() + "' already exists.");
        }
        if (this.isNull(namespace.getURI())) {
            throw new NullPointerException("Namespace uri must not be null");
        }
        try {
            new URI(namespace.getURI());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid URI syntax for '" + namespace.getURI() + "' in namespace '" + namespace.getPrefix() + "'");
        }
        return this.postValidate(namespace, isNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    public void remove(NamespaceInfo namespace) {
        if (!this.getResourcesByNamespace(namespace, ResourceInfo.class).isEmpty()) {
            throw new IllegalArgumentException("Unable to delete non-empty namespace.");
        }
        CatalogFacade catalogFacade = this.facade;
        synchronized (catalogFacade) {
            this.facade.remove(namespace);
            NamespaceInfo defaultNamespace = this.getDefaultNamespace();
            if (namespace.equals(defaultNamespace) || defaultNamespace == null) {
                WorkspaceInfo defaultWorkspace;
                List<NamespaceInfo> namespaces = this.facade.getNamespaces();
                defaultNamespace = null;
                if (!namespaces.isEmpty()) {
                    defaultNamespace = namespaces.get(0);
                }
                this.setDefaultNamespace(defaultNamespace);
                if (defaultNamespace != null && (defaultWorkspace = this.getWorkspaceByName(defaultNamespace.getPrefix())) != null) {
                    this.setDefaultWorkspace(defaultWorkspace);
                }
            }
        }
        this.removed(namespace);
    }

    @Override
    public void save(NamespaceInfo namespace) {
        this.validate(namespace, false);
        this.facade.save(namespace);
    }

    @Override
    public NamespaceInfo detach(NamespaceInfo namespace) {
        return this.detached(namespace, this.facade.detach(namespace));
    }

    @Override
    public NamespaceInfo getDefaultNamespace() {
        return this.facade.getDefaultNamespace();
    }

    @Override
    public void setDefaultNamespace(NamespaceInfo defaultNamespace) {
        if (defaultNamespace != null) {
            NamespaceInfo ns = this.getNamespaceByPrefix(defaultNamespace.getPrefix());
            if (ns == null) {
                throw new IllegalArgumentException("No such namespace: '" + defaultNamespace.getPrefix() + "'");
            }
            defaultNamespace = ns;
        }
        this.facade.setDefaultNamespace(defaultNamespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(WorkspaceInfo workspace) {
        WorkspaceInfo added;
        workspace = this.resolve(workspace);
        this.validate(workspace, true);
        if (this.getWorkspaceByName(workspace.getName()) != null) {
            throw new IllegalArgumentException("Workspace with name '" + workspace.getName() + "' already exists.");
        }
        CatalogFacade catalogFacade = this.facade;
        synchronized (catalogFacade) {
            this.beforeadded(workspace);
            added = this.facade.add(workspace);
            if (this.getDefaultWorkspace() == null) {
                this.setDefaultWorkspace(workspace);
            }
        }
        this.added(added);
    }

    @Override
    public ValidationResult validate(WorkspaceInfo workspace, boolean isNew) {
        if (workspace.isIsolated() && !this.getCatalogCapabilities().supportsIsolatedWorkspaces()) {
            throw new IllegalArgumentException(String.format("Workspace '%s' is isolated but isolated workspaces are not supported by this catalog.", workspace.getName()));
        }
        if (this.isNull(workspace.getName())) {
            throw new NullPointerException("workspace name must not be null");
        }
        if (workspace.getName().equals("default")) {
            throw new IllegalArgumentException("default is a reserved keyword, can't be used as the workspace name");
        }
        WorkspaceInfo existing = this.getWorkspaceByName(workspace.getName());
        if (existing != null && !existing.getId().equals(workspace.getId())) {
            throw new IllegalArgumentException("Workspace named '" + workspace.getName() + "' already exists.");
        }
        return this.postValidate(workspace, isNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    public void remove(WorkspaceInfo workspace) {
        if (this.getNamespaceByPrefix(workspace.getName()) != null) {
            throw new IllegalArgumentException("Cannot delete workspace with linked namespace");
        }
        if (!this.getStoresByWorkspace(workspace, StoreInfo.class).isEmpty()) {
            throw new IllegalArgumentException("Cannot delete non-empty workspace.");
        }
        CatalogFacade catalogFacade = this.facade;
        synchronized (catalogFacade) {
            this.facade.remove(workspace);
            WorkspaceInfo defaultWorkspace = this.getDefaultWorkspace();
            if (workspace.equals(defaultWorkspace) || defaultWorkspace == null) {
                NamespaceInfo defaultNamespace;
                List<WorkspaceInfo> workspaces = this.facade.getWorkspaces();
                defaultWorkspace = null;
                if (!workspaces.isEmpty()) {
                    defaultWorkspace = workspaces.get(0);
                }
                this.setDefaultWorkspace(defaultWorkspace);
                if (defaultWorkspace != null && (defaultNamespace = this.getNamespaceByPrefix(defaultWorkspace.getName())) != null) {
                    this.setDefaultNamespace(defaultNamespace);
                }
            }
        }
        this.removed(workspace);
    }

    @Override
    public void save(WorkspaceInfo workspace) {
        this.validate(workspace, false);
        this.facade.save(workspace);
    }

    @Override
    public WorkspaceInfo detach(WorkspaceInfo workspace) {
        return this.detached(workspace, this.facade.detach(workspace));
    }

    @Override
    public WorkspaceInfo getDefaultWorkspace() {
        return this.facade.getDefaultWorkspace();
    }

    @Override
    public void setDefaultWorkspace(WorkspaceInfo defaultWorkspace) {
        if (defaultWorkspace != null) {
            WorkspaceInfo ws = this.facade.getWorkspaceByName(defaultWorkspace.getName());
            if (ws == null) {
                throw new IllegalArgumentException("No such workspace: '" + defaultWorkspace.getName() + "'");
            }
            defaultWorkspace = ws;
        }
        this.facade.setDefaultWorkspace(defaultWorkspace);
    }

    @Override
    public List<WorkspaceInfo> getWorkspaces() {
        return this.facade.getWorkspaces();
    }

    @Override
    public WorkspaceInfo getWorkspace(String id) {
        return this.facade.getWorkspace(id);
    }

    @Override
    public WorkspaceInfo getWorkspaceByName(String name) {
        WorkspaceInfo ws;
        if ((name == null || "default".equals(name)) && (ws = this.getDefaultWorkspace()) != null) {
            name = ws.getName();
        }
        return this.facade.getWorkspaceByName(name);
    }

    @Override
    public StyleInfo getStyle(String id) {
        return this.facade.getStyle(id);
    }

    @Override
    public StyleInfo getStyleByName(String name) {
        StyleInfo result = null;
        int colon = name.indexOf(58);
        if (colon != -1) {
            String prefix = name.substring(0, colon);
            String resource = name.substring(colon + 1);
            result = this.getStyleByName(prefix, resource);
        } else {
            WorkspaceInfo ws = this.getDefaultWorkspace();
            if (ws != null) {
                result = this.getStyleByName(ws, name);
            }
        }
        if (result == null) {
            result = this.facade.getStyleByName(name);
        }
        return result;
    }

    @Override
    public StyleInfo getStyleByName(String workspaceName, String name) {
        if (workspaceName == null) {
            return this.getStyleByName((WorkspaceInfo)null, name);
        }
        WorkspaceInfo workspace = this.getWorkspaceByName(workspaceName);
        if (workspace != null) {
            return this.getStyleByName(workspace, name);
        }
        return null;
    }

    @Override
    public StyleInfo getStyleByName(WorkspaceInfo workspace, String name) {
        if (workspace == null) {
            workspace = DefaultCatalogFacade.NO_WORKSPACE;
        }
        StyleInfo style = this.facade.getStyleByName(workspace, name);
        return style;
    }

    @Override
    public List<StyleInfo> getStyles() {
        return this.facade.getStyles();
    }

    @Override
    public List<StyleInfo> getStylesByWorkspace(String workspaceName) {
        WorkspaceInfo workspace = null;
        if (workspaceName != null && (workspace = this.getWorkspaceByName(workspaceName)) == null) {
            return Collections.emptyList();
        }
        return this.getStylesByWorkspace(workspace);
    }

    @Override
    public List<StyleInfo> getStylesByWorkspace(WorkspaceInfo workspace) {
        return this.facade.getStylesByWorkspace(workspace);
    }

    @Override
    public void add(StyleInfo style) {
        style = this.resolve(style);
        this.validate(style, true);
        this.beforeadded(style);
        StyleInfo added = this.facade.add(style);
        this.added(added);
    }

    @Override
    public ValidationResult validate(StyleInfo style, boolean isNew) {
        StyleInfo current;
        if (this.isNull(style.getName())) {
            throw new NullPointerException("Style name must not be null");
        }
        if (this.isNull(style.getFilename())) {
            throw new NullPointerException("Style fileName must not be null");
        }
        WorkspaceInfo ws = style.getWorkspace();
        StyleInfo existing = this.getStyleByName(ws, style.getName());
        if (existing != null && (isNew || !existing.getId().equals(style.getId()))) {
            WorkspaceInfo ews = existing.getWorkspace();
            String msg = "Style named '" + style.getName() + "' already exists";
            if (ews != null) {
                msg = msg + " in workspace " + ews.getName();
            }
            throw new IllegalArgumentException(msg);
        }
        if (!isNew && this.isDefaultStyle(current = this.getStyle(style.getId()))) {
            if (!current.getName().equals(style.getName())) {
                throw new IllegalArgumentException("Cannot rename default styles");
            }
            if (null != style.getWorkspace()) {
                throw new IllegalArgumentException("Cannot change the workspace of default styles");
            }
        }
        return this.postValidate(style, isNew);
    }

    @Override
    public void remove(StyleInfo style) {
        Iterator<PublishedInfo> iterator = this.facade.getLayers(style).iterator();
        if (iterator.hasNext()) {
            LayerInfo l = iterator.next();
            throw new IllegalArgumentException("Unable to delete style referenced by '" + l.getName() + "'");
        }
        for (LayerGroupInfo lg : this.facade.getLayerGroups()) {
            if (!lg.getStyles().contains(style) && !style.equals(lg.getRootLayerStyle())) continue;
            String msg = "Unable to delete style referenced by layer group '" + lg.getName() + "'";
            throw new IllegalArgumentException(msg);
        }
        if (this.isDefaultStyle(style)) {
            throw new IllegalArgumentException("Unable to delete a default style");
        }
        this.facade.remove(style);
        this.removed(style);
    }

    private boolean isDefaultStyle(StyleInfo s) {
        return s.getWorkspace() == null && ("point".equals(s.getName()) || "line".equals(s.getName()) || "polygon".equals(s.getName()) || "raster".equals(s.getName()) || "generic".equals(s.getName()));
    }

    @Override
    public void save(StyleInfo style) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(style);
        this.validate(style, false);
        int i = h.getPropertyNames().indexOf("name");
        if (i > -1 && !h.getNewValues().get(i).equals(h.getOldValues().get(i))) {
            String newName = (String)h.getNewValues().get(i);
            try {
                this.renameStyle(style, newName);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to rename style file along with name.", e);
            }
        }
        this.facade.save(style);
    }

    private void renameStyle(StyleInfo s, String newName) throws IOException {
        Resource sld;
        Resource style = new GeoServerDataDirectory(this.resourceLoader).style(s);
        StyleHandler format = Styles.handler(s.getFormat());
        Resource target = Resources.uniqueResource((Resource)style, (String)newName, (String)format.getFileExtension());
        style.renameTo(target);
        s.setFilename(target.name());
        if (!"sld".equals(format.getFormat()) && (sld = style.parent().get(FilenameUtils.getBaseName((String)style.name()) + ".sld")).getType() == Resource.Type.RESOURCE) {
            LOGGER.fine("Renaming style resource " + s.getName() + " to " + newName);
            Resource generated = Resources.uniqueResource((Resource)sld, (String)newName, (String)"sld");
            sld.renameTo(generated);
        }
    }

    @Override
    public StyleInfo detach(StyleInfo style) {
        return this.detached(style, this.facade.detach(style));
    }

    @Override
    public Collection<CatalogListener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners);
    }

    @Override
    public void addListener(CatalogListener listener) {
        this.listeners.add(listener);
        Collections.sort(this.listeners, ExtensionPriority.COMPARATOR);
    }

    @Override
    public void removeListener(CatalogListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void removeListeners(Class<? extends CatalogListener> listenerClass) {
        new ArrayList<CatalogListener>(this.listeners).stream().filter(l -> listenerClass.isInstance(l)).forEach(l -> this.listeners.remove(l));
    }

    public Iterator search(String cql) {
        return null;
    }

    @Override
    public ResourcePool getResourcePool() {
        return this.resourcePool;
    }

    @Override
    public void setResourcePool(ResourcePool resourcePool) {
        this.resourcePool = resourcePool;
    }

    @Override
    public GeoServerResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @Override
    public void setResourceLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Override
    public void dispose() {
        if (this.resourcePool != null) {
            this.resourcePool.dispose();
        }
        this.facade.dispose();
    }

    protected void added(CatalogInfo object) {
        this.fireAdded(object);
    }

    protected void beforeadded(CatalogInfo object) {
        this.fireBeforeAdded(object);
    }

    protected void removed(CatalogInfo object) {
        this.fireRemoved(object);
    }

    public void fireBeforeAdded(CatalogInfo object) {
        CatalogBeforeAddEventImpl event = new CatalogBeforeAddEventImpl();
        event.setSource(object);
        this.event(event);
    }

    @Override
    public void fireAdded(CatalogInfo object) {
        CatalogAddEventImpl event = new CatalogAddEventImpl();
        event.setSource(object);
        this.event(event);
    }

    @Override
    public void fireModified(CatalogInfo object, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
        CatalogModifyEventImpl event = new CatalogModifyEventImpl();
        event.setSource(object);
        event.setPropertyNames(propertyNames);
        event.setOldValues(oldValues);
        event.setNewValues(newValues);
        this.event(event);
    }

    @Override
    public void firePostModified(CatalogInfo object, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
        CatalogPostModifyEventImpl event = new CatalogPostModifyEventImpl();
        event.setSource(object);
        event.setPropertyNames(propertyNames);
        event.setOldValues(oldValues);
        event.setNewValues(newValues);
        this.event(event);
    }

    @Override
    public void fireRemoved(CatalogInfo object) {
        CatalogRemoveEventImpl event = new CatalogRemoveEventImpl();
        event.setSource(object);
        this.event(event);
    }

    protected void event(CatalogEvent event) {
        CatalogException toThrow = null;
        for (CatalogListener listener : this.listeners) {
            try {
                if (event instanceof CatalogAddEvent) {
                    listener.handleAddEvent((CatalogAddEvent)event);
                    continue;
                }
                if (event instanceof CatalogRemoveEvent) {
                    listener.handleRemoveEvent((CatalogRemoveEvent)event);
                    continue;
                }
                if (event instanceof CatalogModifyEvent) {
                    listener.handleModifyEvent((CatalogModifyEvent)event);
                    continue;
                }
                if (event instanceof CatalogPostModifyEvent) {
                    listener.handlePostModifyEvent((CatalogPostModifyEvent)event);
                    continue;
                }
                if (!(event instanceof CatalogBeforeAddEvent)) continue;
                listener.handlePreAddEvent((CatalogBeforeAddEvent)event);
            }
            catch (Throwable t) {
                if (t instanceof CatalogException && toThrow == null) {
                    toThrow = (CatalogException)t;
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Catalog listener threw exception handling event.", t);
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public static Object unwrap(Object obj) {
        return obj;
    }

    public static void validateKeywords(List<KeywordInfo> keywords) {
        if (keywords != null) {
            for (KeywordInfo kw : keywords) {
                Matcher m = KeywordInfo.RE.matcher(kw.getValue());
                if (!m.matches()) {
                    throw new IllegalArgumentException("Illegal keyword '" + kw + "'. Keywords must not be empty and must not contain the '\\' character");
                }
                if (kw.getVocabulary() == null || (m = KeywordInfo.RE.matcher(kw.getVocabulary())).matches()) continue;
                throw new IllegalArgumentException("Keyword vocbulary must not contain the '\\' character");
            }
        }
    }

    public void resolve() {
        this.facade.setCatalog(this);
        this.facade.resolve();
        if (this.listeners == null) {
            this.listeners = new ArrayList<CatalogListener>();
        }
        if (this.resourcePool == null) {
            this.resourcePool = ResourcePool.create(this);
        }
    }

    protected WorkspaceInfo resolve(WorkspaceInfo workspace) {
        this.resolveCollections(workspace);
        return workspace;
    }

    protected NamespaceInfo resolve(NamespaceInfo namespace) {
        this.resolveCollections(namespace);
        return namespace;
    }

    protected StoreInfo resolve(StoreInfo store) {
        this.resolveCollections(store);
        StoreInfoImpl s = (StoreInfoImpl)store;
        s.setCatalog(this);
        return store;
    }

    protected ResourceInfo resolve(ResourceInfo resource) {
        ResourceInfoImpl r = (ResourceInfoImpl)resource;
        r.setCatalog(this);
        if (resource instanceof FeatureTypeInfo) {
            this.resolve((FeatureTypeInfo)resource);
        }
        if (r instanceof CoverageInfo) {
            this.resolve((CoverageInfo)resource);
        }
        if (r instanceof WMSLayerInfo) {
            this.resolve((WMSLayerInfo)resource);
        }
        if (r instanceof WMTSLayerInfo) {
            this.resolve((WMTSLayerInfo)resource);
        }
        return resource;
    }

    private CoverageInfo resolve(CoverageInfo r) {
        CoverageInfoImpl c = (CoverageInfoImpl)r;
        if (c.getDimensions() != null) {
            for (CoverageDimensionInfo dim : c.getDimensions()) {
                if (dim.getNullValues() != null) continue;
                ((CoverageDimensionImpl)dim).setNullValues(new ArrayList<Double>());
            }
        }
        this.resolveCollections(r);
        return r;
    }

    private FeatureTypeInfo resolve(FeatureTypeInfo featureType) {
        FeatureTypeInfoImpl ft = (FeatureTypeInfoImpl)featureType;
        this.resolveCollections(ft);
        return ft;
    }

    private WMSLayerInfo resolve(WMSLayerInfo wmsLayer) {
        WMSLayerInfoImpl impl = (WMSLayerInfoImpl)wmsLayer;
        this.resolveCollections(impl);
        return wmsLayer;
    }

    private WMTSLayerInfo resolve(WMTSLayerInfo wmtsLayer) {
        WMTSLayerInfoImpl impl = (WMTSLayerInfoImpl)wmtsLayer;
        this.resolveCollections(impl);
        return wmtsLayer;
    }

    protected LayerInfo resolve(LayerInfo layer) {
        if (layer.getAttribution() == null) {
            layer.setAttribution(this.getFactory().createAttribution());
        }
        this.resolveCollections(layer);
        return layer;
    }

    protected LayerGroupInfo resolve(LayerGroupInfo layerGroup) {
        this.resolveCollections(layerGroup);
        return layerGroup;
    }

    protected StyleInfo resolve(StyleInfo style) {
        ((StyleInfoImpl)style).setCatalog(this);
        return style;
    }

    protected MapInfo resolve(MapInfo map) {
        this.resolveCollections(map);
        return map;
    }

    protected void resolveCollections(Object object) {
        OwsUtils.resolveCollections((Object)object);
    }

    protected boolean isNull(String string) {
        return string == null || "".equals(string.trim());
    }

    <T extends CatalogInfo> T detached(T original, T detached) {
        return detached != null ? detached : original;
    }

    protected ValidationResult postValidate(CatalogInfo info, boolean isNew) {
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        if (!this.extendedValidation) {
            return new ValidationResult(null);
        }
        for (CatalogValidator constraint : this.getValidators()) {
            try {
                info.accept(new CatalogValidatorVisitor(constraint, isNew));
            }
            catch (RuntimeException e) {
                errors.add(e);
            }
        }
        return new ValidationResult(errors);
    }

    public void sync(CatalogImpl other) {
        other.facade.syncTo(this.facade);
        this.listeners = other.listeners;
        if (this.resourcePool != other.resourcePool) {
            this.resourcePool.dispose();
            this.resourcePool = other.resourcePool;
            this.resourcePool.setCatalog(this);
        }
        this.resourceLoader = other.resourceLoader;
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        visitor.visit(this);
    }

    public void resolve(CatalogInfo info) {
        if (info instanceof LayerGroupInfo) {
            this.resolve((LayerGroupInfo)info);
        } else if (info instanceof LayerInfo) {
            this.resolve((LayerInfo)info);
        } else if (info instanceof MapInfo) {
            this.resolve((MapInfo)info);
        } else if (info instanceof NamespaceInfo) {
            this.resolve((NamespaceInfo)info);
        } else if (info instanceof ResourceInfo) {
            this.resolve((ResourceInfo)info);
        } else if (info instanceof StoreInfo) {
            this.resolve((StoreInfo)info);
        } else if (info instanceof StyleInfo) {
            this.resolve((StyleInfo)info);
        } else if (info instanceof WorkspaceInfo) {
            this.resolve((WorkspaceInfo)info);
        } else {
            throw new IllegalArgumentException("Unknown resource type: " + info);
        }
    }

    @Override
    public <T extends CatalogInfo> int count(Class<T> of, Filter filter) {
        CatalogFacade facade = this.getFacade();
        return facade.count(of, filter);
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter) {
        return this.list(of, filter, null, null, null);
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter, Integer offset, Integer count, SortBy sortOrder) {
        CatalogFacade facade = this.getFacade();
        if (sortOrder != null && !facade.canSort(of, sortOrder.getPropertyName().getPropertyName())) {
            throw new UnsupportedOperationException("Catalog backend can't sort on property " + sortOrder.getPropertyName() + " in-process sorting is pending implementation");
        }
        if (sortOrder != null) {
            return facade.list(of, filter, offset, count, sortOrder);
        }
        return facade.list(of, filter, offset, count, new SortBy[0]);
    }

    @Override
    public <T extends CatalogInfo> T get(Class<T> type, Filter filter) throws IllegalArgumentException {
        Integer limit = 2;
        CatalogInfo result = null;
        try (CloseableIterator<T> it = this.list(type, filter, null, limit, null);){
            if (it.hasNext()) {
                result = (CatalogInfo)it.next();
                if (it.hasNext()) {
                    throw new IllegalArgumentException("Specified query predicate resulted in more than one object");
                }
            }
        }
        return (T)result;
    }

    @Override
    public CatalogCapabilities getCatalogCapabilities() {
        return this.facade.getCatalogCapabilities();
    }

    static class CatalogValidatorVisitor
    implements CatalogVisitor {
        CatalogValidator validator;
        boolean isNew;

        CatalogValidatorVisitor(CatalogValidator validator, boolean isNew) {
            this.validator = validator;
            this.isNew = isNew;
        }

        @Override
        public void visit(Catalog catalog) {
        }

        @Override
        public void visit(WorkspaceInfo workspace) {
            this.validator.validate(workspace, this.isNew);
        }

        @Override
        public void visit(NamespaceInfo namespace) {
            this.validator.validate(namespace, this.isNew);
        }

        @Override
        public void visit(DataStoreInfo dataStore) {
            this.validator.validate(dataStore, this.isNew);
        }

        @Override
        public void visit(CoverageStoreInfo coverageStore) {
            this.validator.validate(coverageStore, this.isNew);
        }

        @Override
        public void visit(WMSStoreInfo wmsStore) {
            this.validator.validate(wmsStore, this.isNew);
        }

        @Override
        public void visit(WMTSStoreInfo wmtsStore) {
            this.validator.validate(wmtsStore, this.isNew);
        }

        @Override
        public void visit(FeatureTypeInfo featureType) {
            this.validator.validate(featureType, this.isNew);
        }

        @Override
        public void visit(CoverageInfo coverage) {
            this.validator.validate(coverage, this.isNew);
        }

        @Override
        public void visit(LayerInfo layer) {
            this.validator.validate(layer, this.isNew);
        }

        @Override
        public void visit(StyleInfo style) {
            this.validator.validate(style, this.isNew);
        }

        @Override
        public void visit(LayerGroupInfo layerGroup) {
            this.validator.validate(layerGroup, this.isNew);
        }

        @Override
        public void visit(WMSLayerInfo wmsLayer) {
            this.validator.validate(wmsLayer, this.isNew);
        }

        @Override
        public void visit(WMTSLayerInfo wmtsLayer) {
            this.validator.validate(wmtsLayer, this.isNew);
        }
    }
}

