/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.Objects;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.MetadataMap;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.feature.type.AttributeDescriptor;

public class AttributeTypeInfoImpl
implements AttributeTypeInfo {
    protected String id;
    protected String name;
    protected int minOccurs;
    protected int maxOccurs;
    protected Boolean nillable;
    protected transient AttributeDescriptor attribute;
    protected MetadataMap metadata = new MetadataMap();
    protected FeatureTypeInfo featureType;
    protected Class<?> binding;
    protected Integer length;
    protected String source;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    @Override
    public boolean isNillable() {
        return this.nillable == null || this.nillable != false;
    }

    @Override
    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    @Override
    public FeatureTypeInfo getFeatureType() {
        return this.featureType;
    }

    @Override
    public void setFeatureType(FeatureTypeInfo featureType) {
        this.featureType = featureType;
    }

    @Override
    public AttributeDescriptor getAttribute() {
        return this.attribute;
    }

    @Override
    public void setAttribute(AttributeDescriptor attribute) {
        this.attribute = attribute;
    }

    public MetadataMap getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataMap metadata) {
        this.metadata = metadata;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Class<?> getBinding() {
        return this.binding;
    }

    @Override
    public void setBinding(Class<?> binding) {
        this.binding = binding;
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer length) {
        this.length = length;
    }

    @Override
    public String getSource() {
        if (this.source == null && this.name != null) {
            try {
                ECQL.toExpression((String)this.name);
                if (this.name.contains(".")) {
                    return "\"" + this.name + "\"";
                }
                return this.name;
            }
            catch (CQLException e) {
                return "\"" + this.name + "\"";
            }
        }
        return this.source;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        return this.equalsIngnoreFeatureType(o) && Objects.equals(this.featureType, ((AttributeTypeInfoImpl)o).featureType);
    }

    public int hashCode() {
        String source = this.source == null ? this.name : this.source;
        return Objects.hash(this.id, this.name, this.minOccurs, this.maxOccurs, this.isNillable(), this.attribute, this.metadata, this.binding, this.length, source);
    }

    @Override
    public boolean equalsIngnoreFeatureType(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeTypeInfoImpl that = (AttributeTypeInfoImpl)o;
        return this.minOccurs == that.minOccurs && this.maxOccurs == that.maxOccurs && Objects.equals(this.isNillable(), that.isNillable()) && Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.attribute, that.attribute) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.binding, that.binding) && Objects.equals(this.length, that.length) && (Objects.equals(this.source, that.source) || Objects.equals(this.getSource(), that.getSource()));
    }
}

