/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.lang.reflect.Proxy;
import java.rmi.server.UID;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.ResolvingProxy;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.util.logging.Logging;

public abstract class AbstractCatalogFacade
implements CatalogFacade {
    private static final Logger LOGGER = Logging.getLogger(AbstractCatalogFacade.class);

    public static <T> T unwrap(T obj) {
        return ModificationProxy.unwrap(obj);
    }

    protected void beforeSaved(CatalogInfo object, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
        CatalogInfo real = ModificationProxy.unwrap(object);
        this.getCatalog().fireModified(real, propertyNames, oldValues, newValues);
    }

    protected <T extends CatalogInfo> T commitProxy(T object) {
        ModificationProxy h = (ModificationProxy)Proxy.getInvocationHandler(object);
        CatalogInfo real = (CatalogInfo)h.getProxyObject();
        h.commit();
        return (T)real;
    }

    protected void afterSaved(CatalogInfo object, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
        CatalogInfo real = ModificationProxy.unwrap(object);
        this.getCatalog().firePostModified(real, propertyNames, oldValues, newValues);
    }

    protected void resolve(LayerInfo layer) {
        StyleInfo style;
        this.setId(layer);
        ResourceInfo resource = ResolvingProxy.resolve(this.getCatalog(), layer.getResource());
        if (resource != null) {
            resource = AbstractCatalogFacade.unwrap(resource);
            layer.setResource(resource);
        }
        if ((style = ResolvingProxy.resolve(this.getCatalog(), layer.getDefaultStyle())) != null) {
            style = AbstractCatalogFacade.unwrap(style);
            layer.setDefaultStyle(style);
        }
        LinkedHashSet<StyleInfo> styles = new LinkedHashSet<StyleInfo>();
        for (StyleInfo s : layer.getStyles()) {
            s = ResolvingProxy.resolve(this.getCatalog(), s);
            s = AbstractCatalogFacade.unwrap(s);
            styles.add(s);
        }
        ((LayerInfoImpl)layer).setStyles(styles);
    }

    protected void resolve(LayerGroupInfo layerGroup) {
        this.setId(layerGroup);
        LayerGroupInfoImpl lg = (LayerGroupInfoImpl)layerGroup;
        this.resolveLayerGroupLayers(lg.getLayers());
        this.resolveLayerGroupStyles(lg.getLayers(), lg.getStyles());
        for (LayerGroupStyle groupStyle : lg.getLayerGroupStyles()) {
            this.resolveLayerGroupLayers(groupStyle.getLayers());
            this.resolveLayerGroupStyles(groupStyle.getLayers(), groupStyle.getStyles());
        }
    }

    private void resolveLayerGroupStyles(List<PublishedInfo> assignedLayers, List<StyleInfo> styles) {
        for (int i = 0; i < styles.size(); ++i) {
            String ref;
            StyleInfo s = styles.get(i);
            if (s == null) continue;
            PublishedInfo assignedLayer = assignedLayers.get(i);
            StyleInfo resolved = null;
            if (assignedLayer instanceof LayerGroupInfo && (ref = ResolvingProxy.getRef(s)) != null) {
                StyleInfoImpl styleInfo = new StyleInfoImpl(this.getCatalog());
                styleInfo.setName(ref);
                resolved = styleInfo;
            }
            if (resolved == null) {
                resolved = AbstractCatalogFacade.unwrap(ResolvingProxy.resolve(this.getCatalog(), s));
            }
            styles.set(i, resolved);
        }
    }

    private void resolveLayerGroupLayers(List<PublishedInfo> layers) {
        for (int i = 0; i < layers.size(); ++i) {
            PublishedInfo resolved;
            PublishedInfo l = layers.get(i);
            if (l == null) continue;
            if (l instanceof LayerGroupInfo) {
                resolved = AbstractCatalogFacade.unwrap(ResolvingProxy.resolve(this.getCatalog(), (LayerGroupInfo)l));
                if (resolved == null) {
                    resolved = l;
                }
            } else if (l instanceof LayerInfo) {
                resolved = AbstractCatalogFacade.unwrap(ResolvingProxy.resolve(this.getCatalog(), (LayerInfo)l));
                if (resolved == null) {
                    resolved = l;
                }
            } else {
                resolved = AbstractCatalogFacade.unwrap(ResolvingProxy.resolve(this.getCatalog(), l));
            }
            layers.set(i, resolved);
        }
    }

    protected void resolve(StyleInfo style) {
        this.setId(style);
        WorkspaceInfo ws = style.getWorkspace();
        if (ws != null) {
            WorkspaceInfo resolved = ResolvingProxy.resolve(this.getCatalog(), ws);
            if (resolved != null) {
                resolved = AbstractCatalogFacade.unwrap(resolved);
                style.setWorkspace(resolved);
            } else {
                LOGGER.log(Level.INFO, "Failed to resolve workspace for style \"" + style.getName() + "\". This means the workspace has not yet been added to the catalog, keep the proxy around");
            }
        }
    }

    protected void resolve(MapInfo map) {
        this.setId(map);
    }

    protected void resolve(WorkspaceInfo workspace) {
        this.setId(workspace);
    }

    protected void resolve(NamespaceInfo namespace) {
        this.setId(namespace);
    }

    protected void resolve(StoreInfo store) {
        this.setId(store);
        StoreInfoImpl s = (StoreInfoImpl)store;
        WorkspaceInfo resolved = ResolvingProxy.resolve(this.getCatalog(), s.getWorkspace());
        if (resolved != null) {
            resolved = AbstractCatalogFacade.unwrap(resolved);
            s.setWorkspace(resolved);
        } else {
            LOGGER.log(Level.INFO, "Failed to resolve workspace for store \"" + store.getName() + "\". This means the workspace has not yet been added to the catalog, keep the proxy around");
        }
    }

    protected void resolve(ResourceInfo resource) {
        NamespaceInfo namespace;
        this.setId(resource);
        ResourceInfoImpl r = (ResourceInfoImpl)resource;
        StoreInfo store = ResolvingProxy.resolve(this.getCatalog(), r.getStore());
        if (store != null) {
            store = AbstractCatalogFacade.unwrap(store);
            r.setStore(store);
        }
        if ((namespace = ResolvingProxy.resolve(this.getCatalog(), r.getNamespace())) != null) {
            namespace = AbstractCatalogFacade.unwrap(namespace);
            r.setNamespace(namespace);
        }
    }

    protected void setId(Object o) {
        if (OwsUtils.get((Object)o, (String)"id") == null) {
            String uid = new UID().toString();
            OwsUtils.set((Object)o, (String)"id", (Object)(o.getClass().getSimpleName() + "-" + uid));
        }
    }
}

