/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.platform.ServiceException;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.transform.Definition;
import org.geotools.data.transform.TransformFactory;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.expression.Expression;

public class TransformFeatureTypeCallback {
    public FeatureType retypeFeatureType(FeatureTypeInfo fti, FeatureType schema) throws IOException {
        List<AttributeTypeInfo> attributes = fti.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return schema;
        }
        SimpleFeatureSource fs = this.getDataStore(fti).getFeatureSource(fti.getNativeName());
        SimpleFeatureSource tfs = this.getTransformedSource(fti, attributes, fs);
        return tfs.getSchema();
    }

    public <T extends FeatureType, U extends Feature> FeatureSource<T, U> wrapFeatureSource(FeatureTypeInfo fti, FeatureSource<T, U> fs) throws IOException {
        List<AttributeTypeInfo> attributes = fti.getAttributes();
        if (attributes == null || attributes.isEmpty()) {
            return fs;
        }
        return this.getTransformedSource(fti, attributes, (SimpleFeatureSource)fs);
    }

    private SimpleFeatureSource getTransformedSource(FeatureTypeInfo fti, List<AttributeTypeInfo> attributes, SimpleFeatureSource fs) throws IOException {
        List definitions = attributes.stream().map(ati -> this.toDefinition((AttributeTypeInfo)ati)).collect(Collectors.toList());
        SimpleFeatureSource tfs = TransformFactory.transform((SimpleFeatureSource)fs, (String)fti.getName(), definitions);
        return tfs;
    }

    private DataStore getDataStore(FeatureTypeInfo fti) throws IOException {
        DataAccess<? extends FeatureType, ? extends Feature> da = fti.getStore().getDataStore(null);
        if (da instanceof DataStore) {
            return (DataStore)da;
        }
        throw new ServiceException("Cannot apply feature type customization on complex features, the server is mis-configured");
    }

    private Definition toDefinition(AttributeTypeInfo ati) {
        try {
            String name = ati.getName();
            Expression source = ECQL.toExpression((String)ati.getSource());
            Class<?> binding = ati.getBinding();
            return new Definition(name, source, binding);
        }
        catch (CQLException e) {
            throw new ServiceException("Failed to parse the attribute source definition to a valid OGC Expression", (Throwable)e);
        }
    }
}

