/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.CascadeDeleteVisitor;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupHelper;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.SingleGridCoverage2DReader;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.FeatureTypeInfoImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureTypes;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.measure.UnitFormat;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.NumberRange;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class CatalogBuilder {
    static final Logger LOGGER = Logging.getLogger(CatalogBuilder.class);
    public static final String DEFAULT_SRS = "EPSG:404000";
    Catalog catalog;
    WorkspaceInfo workspace;
    StoreInfo store;

    public CatalogBuilder(Catalog catalog) {
        this.catalog = catalog;
    }

    public void setWorkspace(WorkspaceInfo workspace) {
        this.workspace = workspace;
    }

    public void setStore(StoreInfo store) {
        this.store = store;
    }

    public void updateWorkspace(WorkspaceInfo original, WorkspaceInfo update) {
        this.update(original, update, WorkspaceInfo.class);
    }

    public void updateNamespace(NamespaceInfo original, NamespaceInfo update) {
        this.update(original, update, NamespaceInfo.class);
    }

    public void updateDataStore(DataStoreInfo original, DataStoreInfo update) {
        this.update(original, update, DataStoreInfo.class);
    }

    public void updateWMSStore(WMSStoreInfo original, WMSStoreInfo update) {
        this.update(original, update, WMSStoreInfo.class);
    }

    public void updateWMTSStore(WMTSStoreInfo original, WMTSStoreInfo update) {
        this.update(original, update, WMTSStoreInfo.class);
    }

    public void updateCoverageStore(CoverageStoreInfo original, CoverageStoreInfo update) {
        this.update(original, update, CoverageStoreInfo.class);
    }

    public void updateFeatureType(FeatureTypeInfo original, FeatureTypeInfo update) {
        this.update(original, update, FeatureTypeInfo.class);
    }

    public void updateCoverage(CoverageInfo original, CoverageInfo update) {
        this.update(original, update, CoverageInfo.class);
    }

    public void updateWMSLayer(WMSLayerInfo original, WMSLayerInfo update) {
        this.update(original, update, WMSLayerInfo.class);
    }

    public void updateWMTSLayer(WMTSLayerInfo original, WMTSLayerInfo update) {
        this.update(original, update, WMTSLayerInfo.class);
    }

    public void updateLayer(LayerInfo original, LayerInfo update) {
        this.update(original, update, LayerInfo.class);
    }

    public void updateLayerGroup(LayerGroupInfo original, LayerGroupInfo update) {
        this.update(original, update, LayerGroupInfo.class);
    }

    public void updateStyle(StyleInfo original, StyleInfo update) {
        this.update(original, update, StyleInfo.class);
    }

    <T> void update(T original, T update, Class<T> clazz) {
        OwsUtils.copy(update, original, clazz);
    }

    public DataStoreInfo buildDataStore(String name) {
        DataStoreInfo info = this.catalog.getFactory().createDataStore();
        this.buildStore(info, name);
        return info;
    }

    public CoverageStoreInfo buildCoverageStore(String name) {
        CoverageStoreInfo info = this.catalog.getFactory().createCoverageStore();
        this.buildStore(info, name);
        return info;
    }

    public WMSStoreInfo buildWMSStore(String name) throws IOException {
        WMSStoreInfo info = this.catalog.getFactory().createWebMapServer();
        this.buildStore(info, name);
        info.setType("WMS");
        info.setMaxConnections(6);
        info.setConnectTimeout(30);
        info.setReadTimeout(60);
        return info;
    }

    public WMTSStoreInfo buildWMTSStore(String name) throws IOException {
        WMTSStoreInfo info = this.catalog.getFactory().createWebMapTileServer();
        this.buildStore(info, name);
        info.setType("WMTS");
        info.setMaxConnections(6);
        info.setConnectTimeout(30);
        info.setReadTimeout(60);
        return info;
    }

    void buildStore(StoreInfo info, String name) {
        info.setName(name);
        info.setEnabled(true);
        if (this.workspace != null) {
            info.setWorkspace(this.workspace);
        } else {
            info.setWorkspace(this.catalog.getDefaultWorkspace());
        }
    }

    public FeatureTypeInfo buildFeatureType(Name typeName) throws Exception {
        if (this.store == null || !(this.store instanceof DataStoreInfo)) {
            throw new IllegalStateException("Data store not set.");
        }
        DataStoreInfo dstore = (DataStoreInfo)this.store;
        return this.buildFeatureType(dstore.getDataStore(null).getFeatureSource(typeName));
    }

    public FeatureTypeInfo buildFeatureType(FeatureSource featureSource) {
        if (this.store == null || !(this.store instanceof DataStoreInfo)) {
            throw new IllegalStateException("Data store not set.");
        }
        FeatureType featureType = featureSource.getSchema();
        FeatureTypeInfo ftinfo = this.catalog.getFactory().createFeatureType();
        ftinfo.setStore(this.store);
        ftinfo.setEnabled(true);
        Name name = featureSource.getName();
        if (name == null) {
            name = featureType.getName();
        }
        ftinfo.setNativeName(name.getLocalPart());
        ftinfo.setName(name.getLocalPart());
        WorkspaceInfo workspace = this.store.getWorkspace();
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            namespace = this.catalog.getDefaultNamespace();
        }
        ftinfo.setNamespace(namespace);
        CoordinateReferenceSystem crs = featureType.getCoordinateReferenceSystem();
        if (crs == null && featureType.getGeometryDescriptor() != null) {
            crs = featureType.getGeometryDescriptor().getCoordinateReferenceSystem();
        }
        ftinfo.setNativeCRS(crs);
        try {
            this.lookupSRS(ftinfo, false);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "SRS lookup failed", e);
        }
        this.setupProjectionPolicy(ftinfo);
        try {
            this.setupMetadata(ftinfo, featureSource);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Metadata lookup failed", e);
        }
        try {
            org.geotools.data.wfs.internal.FeatureTypeInfo info;
            if (featureSource.getInfo() instanceof org.geotools.data.wfs.internal.FeatureTypeInfo && (info = (org.geotools.data.wfs.internal.FeatureTypeInfo)featureSource.getInfo()).getOtherSRS() != null && !info.getOtherSRS().isEmpty()) {
                ftinfo.getMetadata().put("OTHER_SRS", (Serializable)((Object)String.join((CharSequence)",", info.getOtherSRS())));
            }
        }
        catch (UnsupportedOperationException ue) {
            LOGGER.warning("Other SRS not read from Feature Source");
        }
        return ftinfo;
    }

    public void setupProjectionPolicy(ResourceInfo rinfo) {
        if (rinfo.getSRS() != null) {
            rinfo.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        } else {
            rinfo.setProjectionPolicy(ProjectionPolicy.NONE);
        }
    }

    public void setupBounds(FeatureTypeInfo ftinfo, FeatureSource featureSource) throws IOException {
        this.doSetupBounds(ftinfo, featureSource);
    }

    public void setupBounds(CoverageInfo cinfo, GridCoverage2DReader coverageReader) throws IOException {
        this.doSetupBounds(cinfo, coverageReader);
    }

    public void setupBounds(ResourceInfo rinfo) throws IOException {
        this.doSetupBounds(rinfo, null);
    }

    void doSetupBounds(ResourceInfo rinfo, Object data) throws IOException {
        if (rinfo.getNativeBoundingBox() == null) {
            ReferencedEnvelope bounds = this.getNativeBounds(rinfo, data);
            rinfo.setNativeBoundingBox(bounds);
        }
        rinfo.setLatLonBoundingBox(this.getLatLonBounds(rinfo.getNativeBoundingBox(), rinfo.getCRS()));
    }

    public void setupMetadata(FeatureTypeInfo ftinfo, FeatureSource featureSource) throws IOException {
        org.geotools.data.ResourceInfo rinfo;
        block8: {
            rinfo = null;
            try {
                rinfo = featureSource.getInfo();
            }
            catch (Exception ignore) {
                if (!LOGGER.isLoggable(Level.FINE)) break block8;
                LOGGER.log(Level.FINE, "Unable to get resource info from feature source", ignore);
            }
        }
        if (ftinfo.getTitle() == null) {
            ftinfo.setTitle(rinfo != null ? rinfo.getTitle() : ftinfo.getName());
        }
        if (rinfo != null && ftinfo.getDescription() == null) {
            ftinfo.setDescription(rinfo.getDescription());
        }
        if (rinfo != null && (ftinfo.getKeywords() == null || ftinfo.getKeywords().isEmpty()) && rinfo.getKeywords() != null) {
            if (ftinfo.getKeywords() == null) {
                ((FeatureTypeInfoImpl)ftinfo).setKeywords(new ArrayList<KeywordInfo>());
            }
            for (String kw : rinfo.getKeywords()) {
                if (kw == null || "".equals(kw.trim())) {
                    LOGGER.fine("Empty keyword ignored");
                    continue;
                }
                ftinfo.getKeywords().add(new Keyword(kw));
            }
        }
    }

    public ReferencedEnvelope getLatLonBounds(ReferencedEnvelope nativeBounds, CoordinateReferenceSystem declaredCRS) throws IOException {
        if (nativeBounds != null && declaredCRS != null) {
            if (!CRS.equalsIgnoreMetadata((Object)DefaultGeographicCRS.WGS84, (Object)declaredCRS)) {
                try {
                    ReferencedEnvelope bounds = new ReferencedEnvelope((org.locationtech.jts.geom.Envelope)nativeBounds, (CoordinateReferenceSystem)CRS.getHorizontalCRS((CoordinateReferenceSystem)declaredCRS));
                    return bounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                }
                catch (Exception e) {
                    throw (IOException)new IOException("transform error").initCause(e);
                }
            }
            return new ReferencedEnvelope((org.locationtech.jts.geom.Envelope)nativeBounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        }
        return null;
    }

    public ReferencedEnvelope getNativeBounds(ResourceInfo rinfo) throws IOException {
        return this.getNativeBounds(rinfo, null);
    }

    ReferencedEnvelope getNativeBounds(ResourceInfo rinfo, Object data) throws IOException {
        ResourceInfo rebuilt;
        ReferencedEnvelope bounds = null;
        if (rinfo instanceof FeatureTypeInfo) {
            FeatureTypeInfo ftinfo = (FeatureTypeInfo)rinfo;
            bounds = data instanceof FeatureSource ? ((FeatureSource)data).getBounds() : ftinfo.getFeatureSource(null, null).getBounds();
            CoordinateReferenceSystem crs = ftinfo.getNativeCRS();
            if (bounds != null && bounds.getCoordinateReferenceSystem() == null && crs != null) {
                bounds = new ReferencedEnvelope((org.locationtech.jts.geom.Envelope)bounds, crs);
            }
            if (bounds != null) {
                double expandBy = 1.0;
                if (bounds.getCoordinateReferenceSystem() instanceof GeographicCRS) {
                    expandBy = 1.0E-4;
                }
                if (bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
                    bounds.expandBy(expandBy);
                }
            }
        } else if (rinfo instanceof CoverageInfo) {
            CoverageInfo cinfo = (CoverageInfo)rinfo;
            GridCoverage2DReader reader = null;
            reader = data instanceof GridCoverage2DReader ? (GridCoverage2DReader)data : (GridCoverage2DReader)cinfo.getGridCoverageReader(null, GeoTools.getDefaultHints());
            bounds = new ReferencedEnvelope((Envelope)reader.getOriginalEnvelope());
        } else if (rinfo instanceof WMSLayerInfo) {
            rebuilt = this.buildWMSLayer(rinfo.getStore(), rinfo.getNativeName());
            bounds = rebuilt.getNativeBoundingBox();
        } else if (rinfo instanceof WMTSLayerInfo) {
            rebuilt = this.buildWMTSLayer(rinfo.getStore(), rinfo.getNativeName(), rinfo.getNativeCRS());
            bounds = rebuilt.getNativeBoundingBox();
        }
        if (rinfo.getProjectionPolicy() == ProjectionPolicy.REPROJECT_TO_DECLARED && bounds != null) {
            try {
                bounds = bounds.transform(rinfo.getCRS(), true);
            }
            catch (Exception e) {
                throw (IOException)new IOException("transform error").initCause(e);
            }
        }
        return bounds;
    }

    public CoordinateReferenceSystem getNativeCRS(ResourceInfo rinfo) throws Exception {
        CoordinateReferenceSystem nativeCRS = null;
        if (rinfo instanceof FeatureTypeInfo) {
            FeatureTypeInfo ftinfo = (FeatureTypeInfo)rinfo;
            nativeCRS = ftinfo.getStore().getDataStore(null).getFeatureSource(rinfo.getQualifiedNativeName()).getSchema().getCoordinateReferenceSystem();
        } else {
            if (rinfo instanceof CoverageInfo) {
                CoverageInfo cinfo = this.buildCoverage(rinfo.getNativeName());
                return cinfo.getNativeCRS();
            }
            if (rinfo instanceof WMSLayerInfo) {
                WMSLayerInfo rebuilt = this.buildWMSLayer(rinfo.getStore(), rinfo.getNativeName());
                nativeCRS = rebuilt.getNativeCRS();
            } else if (rinfo instanceof WMTSLayerInfo) {
                WMTSLayerInfo rebuilt = this.buildWMTSLayer(rinfo.getStore(), rinfo.getNativeName(), rinfo.getNativeCRS());
                return rebuilt.getNativeCRS();
            }
        }
        return nativeCRS;
    }

    public void lookupSRS(FeatureTypeInfo ftinfo, boolean extensive) throws IOException {
        this.lookupSRS(ftinfo, null, extensive);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void lookupSRS(FeatureTypeInfo ftinfo, FeatureSource data, boolean extensive) throws IOException {
        CoordinateReferenceSystem crs = ftinfo.getNativeCRS();
        if (crs == null) {
            crs = data != null ? data.getSchema().getCoordinateReferenceSystem() : ftinfo.getFeatureType().getCoordinateReferenceSystem();
        }
        if (crs != null) {
            try {
                Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)extensive);
                if (code == null) return;
                ftinfo.setSRS("EPSG:" + code);
                return;
            }
            catch (FactoryException e) {
                throw (IOException)new IOException().initCause(e);
            }
        } else {
            ftinfo.setSRS(DEFAULT_SRS);
        }
    }

    private void initResourceInfo(ResourceInfo resInfo) throws Exception {
        if (resInfo.getNativeName() == null && resInfo.getName() != null) {
            resInfo.setNativeName(resInfo.getName());
        }
        if (resInfo.getNativeName() != null && resInfo.getName() == null) {
            resInfo.setName(resInfo.getNativeName());
        }
    }

    public void initFeatureType(FeatureTypeInfo featureType) throws Exception {
        if (featureType.getCatalog() == null) {
            featureType.setCatalog(this.catalog);
        }
        this.initResourceInfo(featureType);
        if (featureType.getSRS() == null) {
            this.lookupSRS(featureType, true);
        }
        if (featureType.getProjectionPolicy() == null) {
            this.setupProjectionPolicy(featureType);
        }
        CoordinateReferenceSystem crs = featureType.getCRS();
        if (featureType.getLatLonBoundingBox() == null && featureType.getNativeBoundingBox() == null) {
            this.setupBounds(featureType);
        } else if (featureType.getLatLonBoundingBox() == null) {
            this.setupBounds(featureType);
        } else if (featureType.getNativeBoundingBox() == null && crs != null) {
            ReferencedEnvelope boundsLatLon = featureType.getLatLonBoundingBox();
            featureType.setNativeBoundingBox(boundsLatLon.transform(crs, true));
        }
    }

    public void initWMSLayer(WMSLayerInfo wmsLayer) throws Exception {
        wmsLayer.setCatalog(this.catalog);
        this.initResourceInfo(wmsLayer);
        OwsUtils.resolveCollections((Object)wmsLayer);
        WMSLayerInfo full = this.buildWMSLayer(this.store, wmsLayer.getNativeName());
        if (wmsLayer.getSRS() == null) {
            wmsLayer.setSRS(full.getSRS());
        }
        if (wmsLayer.getNativeCRS() == null) {
            wmsLayer.setNativeCRS(full.getNativeCRS());
        }
        if (wmsLayer.getProjectionPolicy() == null) {
            wmsLayer.setProjectionPolicy(full.getProjectionPolicy());
        }
        if (wmsLayer.getLatLonBoundingBox() == null && wmsLayer.getNativeBoundingBox() == null) {
            wmsLayer.setLatLonBoundingBox(full.getLatLonBoundingBox());
            wmsLayer.setNativeBoundingBox(full.getNativeBoundingBox());
        } else if (wmsLayer.getLatLonBoundingBox() == null) {
            this.setupBounds(wmsLayer);
        } else if (wmsLayer.getNativeBoundingBox() == null && wmsLayer.getNativeCRS() != null) {
            ReferencedEnvelope boundsLatLon = wmsLayer.getLatLonBoundingBox();
            wmsLayer.setNativeBoundingBox(boundsLatLon.transform(wmsLayer.getNativeCRS(), true));
        }
        if (wmsLayer.getTitle() == null) {
            wmsLayer.setTitle(full.getTitle());
        }
        if (wmsLayer.getDescription() == null) {
            wmsLayer.setDescription(full.getDescription());
        }
        if (wmsLayer.getAbstract() == null) {
            wmsLayer.setAbstract(full.getAbstract());
        }
        if (wmsLayer.getKeywords().isEmpty()) {
            wmsLayer.getKeywords().addAll(full.getKeywords());
        }
    }

    public void initWMTSLayer(WMTSLayerInfo layer) throws Exception {
        layer.setCatalog(this.catalog);
        this.initResourceInfo(layer);
        OwsUtils.resolveCollections((Object)layer);
        WMTSLayerInfo full = this.buildWMTSLayer(this.store, layer.getNativeName(), layer.getNativeCRS());
        if (layer.getSRS() == null) {
            layer.setSRS(full.getSRS());
        }
        if (layer.getNativeCRS() == null) {
            layer.setNativeCRS(full.getNativeCRS());
        }
        if (layer.getProjectionPolicy() == null) {
            layer.setProjectionPolicy(full.getProjectionPolicy());
        }
        if (layer.getLatLonBoundingBox() == null && layer.getNativeBoundingBox() == null) {
            layer.setLatLonBoundingBox(full.getLatLonBoundingBox());
            layer.setNativeBoundingBox(full.getNativeBoundingBox());
        } else if (layer.getLatLonBoundingBox() == null) {
            this.setupBounds(layer);
        } else if (layer.getNativeBoundingBox() == null && layer.getNativeCRS() != null) {
            ReferencedEnvelope boundsLatLon = layer.getLatLonBoundingBox();
            layer.setNativeBoundingBox(boundsLatLon.transform(layer.getNativeCRS(), true));
        }
        if (layer.getTitle() == null) {
            layer.setTitle(full.getTitle());
        }
        if (layer.getDescription() == null) {
            layer.setDescription(full.getDescription());
        }
        if (layer.getAbstract() == null) {
            layer.setAbstract(full.getAbstract());
        }
        if (layer.getKeywords().isEmpty()) {
            layer.getKeywords().addAll(full.getKeywords());
        }
    }

    public void initCoverage(CoverageInfo cinfo) throws Exception {
        this.initCoverage(cinfo, null);
    }

    public void initCoverage(CoverageInfo cinfo, String coverageName) throws Exception {
        CoordinateReferenceSystem nativeCRS;
        CoverageStoreInfo csinfo = (CoverageStoreInfo)this.store;
        GridCoverage2DReader reader = (GridCoverage2DReader)this.catalog.getResourcePool().getGridCoverageReader(cinfo, GeoTools.getDefaultHints());
        if (coverageName != null) {
            reader = SingleGridCoverage2DReader.wrap(reader, coverageName);
        }
        this.initResourceInfo(cinfo);
        if (reader == null) {
            throw new Exception("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
        }
        if (cinfo.getNativeCRS() == null) {
            cinfo.setNativeCRS(reader.getCoordinateReferenceSystem());
        }
        if ((nativeCRS = cinfo.getNativeCRS()) != null && cinfo.getSRS() == null) {
            try {
                Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)nativeCRS, (boolean)false);
                if (code != null) {
                    cinfo.setSRS("EPSG:" + code);
                    cinfo.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
                }
            }
            catch (FactoryException e) {
                LOGGER.log(Level.WARNING, "SRS lookup failed", e);
            }
        }
        if (cinfo.getProjectionPolicy() == null) {
            if (nativeCRS != null && !nativeCRS.getIdentifiers().isEmpty()) {
                cinfo.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
            }
            if (nativeCRS == null) {
                cinfo.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
            }
        }
        if (cinfo.getLatLonBoundingBox() == null && cinfo.getNativeBoundingBox() == null) {
            GeneralEnvelope envelope = reader.getOriginalEnvelope();
            cinfo.setNativeBoundingBox(new ReferencedEnvelope((Envelope)envelope));
            cinfo.setLatLonBoundingBox(new ReferencedEnvelope((Envelope)CoverageStoreUtils.getWGS84LonLatEnvelope(envelope)));
        } else if (cinfo.getLatLonBoundingBox() == null) {
            this.setupBounds(cinfo);
        } else if (cinfo.getNativeBoundingBox() == null && cinfo.getNativeCRS() != null) {
            ReferencedEnvelope boundsLatLon = cinfo.getLatLonBoundingBox();
            cinfo.setNativeBoundingBox(boundsLatLon.transform(cinfo.getNativeCRS(), true));
        }
        if (cinfo.getGrid() == null) {
            GridEnvelope originalRange = reader.getOriginalGridRange();
            cinfo.setGrid((GridGeometry)new GridGeometry2D(originalRange, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), nativeCRS));
        }
    }

    public CoverageInfo buildCoverage() throws Exception {
        return this.buildCoverage(null);
    }

    public CoverageInfo buildCoverage(String coverageName) throws Exception {
        if (this.store == null || !(this.store instanceof CoverageStoreInfo)) {
            throw new IllegalStateException("Coverage store not set.");
        }
        CoverageStoreInfo csinfo = (CoverageStoreInfo)this.store;
        GridCoverage2DReader reader = (GridCoverage2DReader)this.catalog.getResourcePool().getGridCoverageReader(csinfo, GeoTools.getDefaultHints());
        if (reader == null) {
            throw new Exception("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
        }
        return this.buildCoverage(reader, coverageName, null);
    }

    public CoverageInfo buildCoverageByName(String nativeCoverageName, String specifiedName) throws Exception {
        if (this.store == null || !(this.store instanceof CoverageStoreInfo)) {
            throw new IllegalStateException("Coverage store not set.");
        }
        CoverageStoreInfo csinfo = (CoverageStoreInfo)this.store;
        GridCoverage2DReader reader = (GridCoverage2DReader)this.catalog.getResourcePool().getGridCoverageReader(csinfo, GeoTools.getDefaultHints());
        if (reader == null) {
            throw new Exception("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
        }
        return this.buildCoverageInternal(reader, nativeCoverageName, null, specifiedName);
    }

    public CoverageInfo buildCoverage(GridCoverage2DReader reader, Map<String, Serializable> customParameters) throws Exception {
        return this.buildCoverage(reader, null, customParameters);
    }

    public CoverageInfo buildCoverage(GridCoverage2DReader reader, String coverageName, Map<String, Serializable> customParameters) throws Exception {
        return this.buildCoverageInternal(reader, coverageName, customParameters, null);
    }

    private CoverageInfo buildCoverageInternal(GridCoverage2DReader reader, String nativeCoverageName, Map<String, Serializable> customParameters, String specifiedName) throws Exception {
        if (this.store == null || !(this.store instanceof CoverageStoreInfo)) {
            throw new IllegalStateException("Coverage store not set.");
        }
        if (nativeCoverageName != null) {
            reader = SingleGridCoverage2DReader.wrap(reader, nativeCoverageName);
        }
        CoverageStoreInfo csinfo = (CoverageStoreInfo)this.store;
        CoverageInfo cinfo = this.catalog.getFactory().createCoverage();
        cinfo.setStore(csinfo);
        cinfo.setEnabled(true);
        WorkspaceInfo wspace = this.store.getWorkspace();
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(wspace.getName());
        if (namespace == null) {
            namespace = this.catalog.getDefaultNamespace();
        }
        cinfo.setNamespace(namespace);
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        CoordinateReferenceSystem nativeCRS = envelope.getCoordinateReferenceSystem();
        cinfo.setNativeCRS(nativeCRS);
        if (nativeCRS != null) {
            try {
                Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)nativeCRS, (boolean)false);
                if (code != null) {
                    cinfo.setSRS("EPSG:" + code);
                    cinfo.setProjectionPolicy(ProjectionPolicy.REPROJECT_TO_DECLARED);
                }
            }
            catch (FactoryException e) {
                LOGGER.log(Level.WARNING, "SRS lookup failed", e);
            }
        }
        if (nativeCRS == null) {
            cinfo.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        }
        cinfo.setNativeBoundingBox(new ReferencedEnvelope((Envelope)envelope));
        cinfo.setLatLonBoundingBox(new ReferencedEnvelope((Envelope)CoverageStoreUtils.getWGS84LonLatEnvelope(envelope)));
        GridEnvelope originalRange = reader.getOriginalGridRange();
        cinfo.setGrid((GridGeometry)new GridGeometry2D(originalRange, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), nativeCRS));
        AbstractGridFormat format = csinfo.getFormat();
        ParameterValueGroup readParams = format.getReadParameters();
        GridSampleDimension[] sampleDimensions = this.getCoverageSampleDimensions(reader, customParameters);
        List<CoverageDimensionInfo> coverageDimensions = this.getCoverageDimensions(sampleDimensions);
        cinfo.getDimensions().addAll(coverageDimensions);
        if (specifiedName != null) {
            cinfo.setName(specifiedName);
            cinfo.setTitle(specifiedName);
            cinfo.getKeywords().add(new Keyword(specifiedName));
        } else {
            String name = reader.getGridCoverageNames()[0];
            cinfo.setName(name);
            cinfo.setTitle(name);
            cinfo.getKeywords().add(new Keyword(name));
        }
        cinfo.setNativeCoverageName(nativeCoverageName);
        cinfo.setDescription("Generated from " + format.getName());
        cinfo.getKeywords().add(new Keyword("WCS"));
        cinfo.getKeywords().add(new Keyword(format.getName()));
        cinfo.setNativeFormat(format.getName());
        cinfo.getMetadata().put("dirName", (Serializable)((Object)(this.store.getName() + "_" + nativeCoverageName)));
        if (nativeCRS != null && nativeCRS.getIdentifiers() != null && !nativeCRS.getIdentifiers().isEmpty()) {
            cinfo.getRequestSRS().add(nativeCRS.getIdentifiers().toArray()[0].toString());
            cinfo.getResponseSRS().add(nativeCRS.getIdentifiers().toArray()[0].toString());
        }
        List<Format> formats = CoverageStoreUtils.listDataFormats();
        for (Format o : formats) {
            Format fTmp = o;
            String fName = fTmp.getName();
            if (fName.equalsIgnoreCase("WorldImage")) {
                cinfo.getSupportedFormats().add("GIF");
                cinfo.getSupportedFormats().add("PNG");
                cinfo.getSupportedFormats().add("JPEG");
                cinfo.getSupportedFormats().add("TIFF");
                continue;
            }
            if (fName.toLowerCase().startsWith("geotiff")) {
                cinfo.getSupportedFormats().add("GEOTIFF");
                continue;
            }
            cinfo.getSupportedFormats().add(fName);
        }
        cinfo.setDefaultInterpolationMethod("nearest neighbor");
        cinfo.getInterpolationMethods().add("nearest neighbor");
        cinfo.getInterpolationMethods().add("bilinear");
        cinfo.getInterpolationMethods().add("bicubic");
        cinfo.getParameters().putAll(CoverageUtils.getParametersKVP(readParams));
        return cinfo;
    }

    public void reloadDimensions(CoverageInfo ci) throws Exception {
        CoverageInfo rebuilt;
        String nativeName = ci.getNativeCoverageName();
        this.setStore(ci.getStore());
        MetadataMap metadata = ci.getMetadata();
        if (metadata != null && metadata.containsKey(CoverageView.COVERAGE_VIEW)) {
            GridCoverage2DReader reader = (GridCoverage2DReader)this.catalog.getResourcePool().getGridCoverageReader(ci, nativeName, GeoTools.getDefaultHints());
            rebuilt = this.buildCoverage(reader, nativeName, null);
        } else {
            rebuilt = this.buildCoverage(nativeName);
        }
        if (ci instanceof CoverageInfoImpl) {
            ((CoverageInfoImpl)ci).setDimensions(rebuilt.getDimensions());
        } else {
            ci.getDimensions().clear();
            ci.getDimensions().addAll(rebuilt.getDimensions());
        }
    }

    private GridSampleDimension[] getCoverageSampleDimensions(GridCoverage2DReader reader, Map<String, Serializable> customParameters) throws TransformException, IOException, Exception {
        GridSampleDimension[] sampleDimensions;
        GridEnvelope originalRange = reader.getOriginalGridRange();
        Format format = reader.getFormat();
        ParameterValueGroup readParams = format.getReadParameters();
        Map<String, Serializable> parameters = CoverageUtils.getParametersKVP(readParams);
        int minX = originalRange.getLow(0);
        int minY = originalRange.getLow(1);
        int width = originalRange.getSpan(0);
        int height = originalRange.getSpan(1);
        int maxX = minX + (width <= 5 ? width : 5);
        int maxY = minY + (height <= 5 ? height : 5);
        GridEnvelope2D testRange = new GridEnvelope2D(minX, minY, maxX, maxY);
        MathTransform gridToWorldCorner = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        GeneralEnvelope testEnvelope = CRS.transform((MathTransform)gridToWorldCorner, (Envelope)new GeneralEnvelope((Rectangle2D)testRange.getBounds()));
        testEnvelope.setCoordinateReferenceSystem(reader.getCoordinateReferenceSystem());
        if (customParameters != null) {
            parameters.putAll(customParameters);
        }
        String maxAllowedTiles = ImageMosaicFormat.MAX_ALLOWED_TILES.getName().toString();
        if (parameters.keySet().contains(maxAllowedTiles)) {
            parameters.put(maxAllowedTiles, Integer.valueOf(1));
        }
        String useJaiImageRead = ImageMosaicFormat.USE_JAI_IMAGEREAD.getName().toString();
        if (parameters.keySet().contains(useJaiImageRead)) {
            parameters.put(useJaiImageRead, Boolean.valueOf(false));
        }
        parameters.put(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), (Serializable)new GridGeometry2D((GridEnvelope)testRange, (Envelope)testEnvelope));
        GridCoverage2D gc = reader.read(CoverageUtils.getParameters(readParams, parameters, true));
        if (gc != null) {
            parameters.remove(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString());
            sampleDimensions = gc.getSampleDimensions();
            gc.dispose(true);
            if (gc.getRenderedImage() instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)gc.getRenderedImage()));
            }
        } else {
            ImageLayout imageLayout = reader.getImageLayout();
            if (imageLayout == null) {
                throw new Exception("Unable to acquire test coverage and image layout for format:" + format.getName());
            }
            ColorModel cm = imageLayout.getColorModel(null);
            if (cm == null) {
                throw new Exception("Unable to acquire test coverage and color model for format:" + format.getName());
            }
            SampleModel sm = imageLayout.getSampleModel(null);
            if (cm == null) {
                throw new Exception("Unable to acquire test coverage and sample model for format:" + format.getName());
            }
            int numBands = sm.getNumBands();
            sampleDimensions = new GridSampleDimension[numBands];
            for (int i = 0; i < numBands; ++i) {
                ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
                if (colorInterpretation == null) {
                    throw new IOException("Unrecognized sample dimension type for band number " + (i + 1));
                }
                sampleDimensions[i] = new GridSampleDimension((CharSequence)colorInterpretation.name());
            }
        }
        return sampleDimensions;
    }

    List<CoverageDimensionInfo> getCoverageDimensions(GridSampleDimension[] sampleDimensions) {
        ArrayList<CoverageDimensionInfo> dims = new ArrayList<CoverageDimensionInfo>();
        for (GridSampleDimension sampleDimension : sampleDimensions) {
            CoverageDimensionInfo dim = this.catalog.getFactory().createCoverageDimension();
            GridSampleDimension sd = sampleDimension;
            String name = sd.getDescription().toString(Locale.getDefault());
            dim.setName(name);
            StringBuilder label = new StringBuilder("GridSampleDimension".intern());
            Unit uom = sd.getUnits();
            String uName = name.toUpperCase();
            if (uom != null) {
                label.append("(".intern());
                this.formatUOM(label, uom);
                label.append(")".intern());
                dim.setUnit(UnitFormat.getInstance().format(uom));
            } else if (uName.startsWith("RED") || uName.startsWith("GREEN") || uName.startsWith("BLUE")) {
                dim.setUnit("W.m-2.Sr-1");
            }
            dim.setDimensionType(sd.getSampleDimensionType());
            double sdMin = sd.getMinimumValue();
            double sdMax = sd.getMaximumValue();
            label.append("[".intern());
            label.append(sdMin);
            label.append(",".intern());
            label.append(sdMax);
            label.append("]".intern());
            dim.setDescription(label.toString());
            dim.setRange((NumberRange<? extends Number>)NumberRange.create((double)sdMin, (double)sdMax));
            List categories = sd.getCategories();
            if (categories != null) {
                for (Category cat : categories) {
                    if (cat == null || !cat.getName().toString(Locale.ENGLISH).equalsIgnoreCase("no data")) continue;
                    double min = cat.getRange().getMinimum();
                    double max = cat.getRange().getMaximum();
                    dim.getNullValues().add(min);
                    if (min == max) continue;
                    dim.getNullValues().add(max);
                }
            }
            dims.add(dim);
        }
        return dims;
    }

    public WMSLayerInfo buildWMSLayer(String layerName) throws IOException {
        return this.buildWMSLayer(this.store, layerName);
    }

    WMSLayerInfo buildWMSLayer(StoreInfo store, String layerName) throws IOException {
        String published;
        CRSEnvelope llbbox;
        if (store == null || !(store instanceof WMSStoreInfo)) {
            throw new IllegalStateException("WMS store not set.");
        }
        WMSLayerInfo wli = this.catalog.getFactory().createWMSLayer();
        wli.setName(layerName);
        wli.setNativeName(layerName);
        wli.setStore(store);
        wli.setEnabled(true);
        WorkspaceInfo workspace = store.getWorkspace();
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            namespace = this.catalog.getDefaultNamespace();
        }
        wli.setNamespace(namespace);
        Layer layer = wli.getWMSLayer(null);
        for (String srs : layer.getBoundingBoxes().keySet()) {
            try {
                CoordinateReferenceSystem crs = CRS.decode((String)srs);
                wli.setSRS(srs);
                wli.setNativeCRS(crs);
                break;
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Skipping " + srs + " definition, it was not recognized by the referencing subsystem");
            }
        }
        String srs = wli.getSRS();
        try {
            if (srs == null || srs.equals("CRS:84")) {
                wli.setSRS("EPSG:4326");
                srs = "EPSG:4326";
                wli.setNativeCRS(CRS.decode((String)"EPSG:4326"));
            } else if (srs.equals("CRS:83")) {
                wli.setSRS("EPSG:4269");
                srs = "EPSG:4269";
                wli.setNativeCRS(CRS.decode((String)"EPSG:4269"));
            } else if (srs.equals("CRS:27")) {
                wli.setSRS("EPSG:4267");
                srs = "EPSG:4267";
                wli.setNativeCRS(CRS.decode((String)"EPSG:4267"));
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException("Failed to compute the layer declared SRS code").initCause(e);
        }
        wli.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        GeneralEnvelope envelope = layer.getEnvelope(wli.getNativeCRS());
        if (envelope != null) {
            ReferencedEnvelope re = new ReferencedEnvelope(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1), wli.getNativeCRS());
            wli.setNativeBoundingBox(re);
        }
        if ((llbbox = layer.getLatLonBoundingBox()) != null) {
            ReferencedEnvelope re = new ReferencedEnvelope(llbbox.getMinX(), llbbox.getMaxX(), llbbox.getMinY(), llbbox.getMaxY(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            wli.setLatLonBoundingBox(re);
        } else if (wli.getNativeBoundingBox() != null) {
            try {
                wli.setLatLonBoundingBox(wli.getNativeBoundingBox().transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true));
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Could not transform native bbox into a lat/lon one", e);
            }
        }
        wli.setAbstract(layer.get_abstract());
        wli.setDescription(layer.get_abstract());
        wli.setTitle(layer.getTitle());
        if (layer.getKeywords() != null) {
            for (String kw : layer.getKeywords()) {
                if (kw == null) continue;
                wli.getKeywords().add(new Keyword(kw));
            }
        }
        if ((published = wli.getName()).contains(":")) {
            wli.setName(published.substring(published.lastIndexOf(58) + 1));
        }
        return wli;
    }

    public WMTSLayerInfo buildWMTSLayer(String layerName) throws IOException {
        return this.buildWMTSLayer(this.store, layerName);
    }

    WMTSLayerInfo buildWMTSLayer(StoreInfo store, String layerName) throws IOException {
        return this.buildWMTSLayer(store, layerName, null);
    }

    WMTSLayerInfo buildWMTSLayer(StoreInfo store, String layerName, CoordinateReferenceSystem nativeCRS) throws IOException {
        String published;
        CRSEnvelope llbbox;
        if (store == null || !(store instanceof WMTSStoreInfo)) {
            throw new IllegalStateException("WMTS store not set.");
        }
        WMTSLayerInfo wli = this.catalog.getFactory().createWMTSLayer();
        wli.setName(layerName);
        wli.setNativeName(layerName);
        wli.setStore(store);
        wli.setEnabled(true);
        WorkspaceInfo workspace = store.getWorkspace();
        NamespaceInfo namespace = this.catalog.getNamespaceByPrefix(workspace.getName());
        if (namespace == null) {
            namespace = this.catalog.getDefaultNamespace();
        }
        wli.setNamespace(namespace);
        WMTSLayer layer = wli.getWMTSLayer(null);
        if (nativeCRS != null) {
            wli.setSRS(CRS.toSRS((CoordinateReferenceSystem)nativeCRS));
            wli.setNativeCRS(nativeCRS);
        } else {
            for (String srs : layer.getSrs()) {
                try {
                    CoordinateReferenceSystem crs = CRS.decode((String)srs);
                    wli.setSRS(srs);
                    wli.setNativeCRS(crs);
                    break;
                }
                catch (Exception e) {
                    LOGGER.log(Level.INFO, "Skipping " + srs + " definition, it was not recognized by the referencing subsystem");
                }
            }
        }
        String srs = wli.getSRS();
        try {
            if (srs == null || srs.equals("CRS:84")) {
                wli.setSRS("EPSG:4326");
                srs = "EPSG:4326";
                wli.setNativeCRS(CRS.decode((String)"EPSG:4326"));
            } else if (srs.equals("CRS:83")) {
                wli.setSRS("EPSG:4269");
                srs = "EPSG:4269";
                wli.setNativeCRS(CRS.decode((String)"EPSG:4269"));
            } else if (srs.equals("CRS:27")) {
                wli.setSRS("EPSG:4267");
                srs = "EPSG:4267";
                wli.setNativeCRS(CRS.decode((String)"EPSG:4267"));
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException("Failed to compute the layer declared SRS code").initCause(e);
        }
        wli.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        GeneralEnvelope envelope = layer.getEnvelope(wli.getNativeCRS());
        if (envelope != null) {
            ReferencedEnvelope re = new ReferencedEnvelope(envelope.getMinimum(0), envelope.getMaximum(0), envelope.getMinimum(1), envelope.getMaximum(1), wli.getNativeCRS());
            wli.setNativeBoundingBox(re);
        }
        if ((llbbox = layer.getLatLonBoundingBox()) != null) {
            ReferencedEnvelope re = new ReferencedEnvelope(llbbox.getMinX(), llbbox.getMaxX(), llbbox.getMinY(), llbbox.getMaxY(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            wli.setLatLonBoundingBox(re);
        } else if (wli.getNativeBoundingBox() != null) {
            try {
                wli.setLatLonBoundingBox(wli.getNativeBoundingBox().transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true));
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Could not transform native bbox into a lat/lon one", e);
            }
        }
        wli.setAbstract(layer.get_abstract());
        wli.setDescription(layer.get_abstract());
        wli.setTitle(layer.getTitle());
        if (layer.getKeywords() != null) {
            for (String kw : layer.getKeywords()) {
                if (kw == null) continue;
                wli.getKeywords().add(new Keyword(kw));
            }
        }
        if ((published = wli.getName()).contains(":")) {
            wli.setName(published.substring(published.lastIndexOf(58) + 1));
        }
        return wli;
    }

    void formatUOM(StringBuilder label, Unit uom) {
        String formatted = UnitFormat.getInstance().format(uom);
        label.append(formatted);
    }

    public LayerInfo buildLayer(FeatureTypeInfo featureType) throws IOException {
        LayerInfo layer = this.buildLayer((ResourceInfo)featureType);
        StyleInfo style = this.getDefaultStyle(featureType);
        layer.setDefaultStyle(style);
        return layer;
    }

    public LayerInfo buildLayer(CoverageInfo coverage) throws IOException {
        LayerInfo layer = this.buildLayer((ResourceInfo)coverage);
        layer.setDefaultStyle(this.getDefaultStyle(coverage));
        return layer;
    }

    public LayerInfo buildLayer(WMSLayerInfo wms) throws IOException {
        LayerInfo layer = this.buildLayer((ResourceInfo)wms);
        layer.setDefaultStyle(this.getDefaultStyle(wms));
        return layer;
    }

    public StyleInfo getDefaultStyle(ResourceInfo resource) throws IOException {
        if (resource instanceof CoverageInfo || resource instanceof WMSLayerInfo || resource instanceof WMTSLayerInfo) {
            return this.catalog.getStyleByName("raster");
        }
        FeatureTypeInfo featureType = (FeatureTypeInfo)resource;
        if (featureType.getFeatureType() == null) {
            return null;
        }
        GeometryDescriptor gd = featureType.getFeatureType().getGeometryDescriptor();
        if (gd == null) {
            return null;
        }
        Class gtype = gd.getType().getBinding();
        String styleName = Point.class.isAssignableFrom(gtype) || MultiPoint.class.isAssignableFrom(gtype) ? "point" : (LineString.class.isAssignableFrom(gtype) || MultiLineString.class.isAssignableFrom(gtype) ? "line" : (Polygon.class.isAssignableFrom(gtype) || MultiPolygon.class.isAssignableFrom(gtype) ? "polygon" : (Point.class.isAssignableFrom(gtype) || MultiPoint.class.isAssignableFrom(gtype) ? "point" : "generic")));
        return this.catalog.getStyleByName(styleName);
    }

    public LayerInfo buildLayer(ResourceInfo resource) {
        LayerInfo layer = this.catalog.getFactory().createLayer();
        layer.setResource(resource);
        layer.setName(resource.getName());
        layer.setEnabled(true);
        if (layer.getResource() instanceof FeatureTypeInfo) {
            layer.setType(PublishedType.VECTOR);
        } else if (layer.getResource() instanceof CoverageInfo) {
            layer.setType(PublishedType.RASTER);
        } else if (layer.getResource() instanceof WMTSLayerInfo) {
            layer.setType(PublishedType.WMTS);
        } else if (layer.getResource() instanceof WMSLayerInfo) {
            layer.setType(PublishedType.WMS);
        }
        return layer;
    }

    public void calculateLayerGroupBounds(LayerGroupInfo layerGroup, CoordinateReferenceSystem crs) throws Exception {
        LayerGroupHelper helper = new LayerGroupHelper(layerGroup);
        helper.calculateBounds(crs);
    }

    public void calculateLayerGroupBoundsFromCRS(LayerGroupInfo layerGroup, CoordinateReferenceSystem crs) {
        LayerGroupHelper helper = new LayerGroupHelper(layerGroup);
        helper.calculateBoundsFromCRS(crs);
    }

    public void calculateLayerGroupBounds(LayerGroupInfo layerGroup) throws Exception {
        LayerGroupHelper helper = new LayerGroupHelper(layerGroup);
        helper.calculateBounds();
    }

    public void removeWorkspace(WorkspaceInfo workspace, boolean recursive) {
        if (recursive) {
            workspace.accept(new CascadeDeleteVisitor(this.catalog));
        } else {
            this.catalog.remove(workspace);
        }
    }

    public void removeStore(StoreInfo store, boolean recursive) {
        if (recursive) {
            store.accept(new CascadeDeleteVisitor(this.catalog));
        } else {
            this.catalog.remove(store);
        }
    }

    public void removeResource(ResourceInfo resource, boolean recursive) {
        if (recursive) {
            resource.accept(new CascadeDeleteVisitor(this.catalog));
        } else {
            this.catalog.remove(resource);
        }
    }

    public void attach(StoreInfo storeInfo) {
        storeInfo = ModificationProxy.unwrap(storeInfo);
        ((StoreInfoImpl)storeInfo).setCatalog(this.catalog);
    }

    public void attach(ResourceInfo resourceInfo) {
        resourceInfo = ModificationProxy.unwrap(resourceInfo);
        resourceInfo.setCatalog(this.catalog);
    }

    public void attach(LayerInfo layerInfo) {
        this.attach(layerInfo.getResource());
    }

    public void attach(MapInfo mapInfo) {
        for (LayerInfo layer : mapInfo.getLayers()) {
            this.attach(layer);
        }
    }

    public void attach(LayerGroupInfo groupInfo) {
        if (groupInfo.getRootLayer() != null) {
            this.attach(groupInfo.getRootLayer());
        }
        if (groupInfo.getRootLayerStyle() != null) {
            this.attach(groupInfo.getRootLayerStyle());
        }
        for (PublishedInfo p : groupInfo.getLayers()) {
            if (p instanceof LayerInfo) {
                this.attach((LayerInfo)p);
                continue;
            }
            this.attach((LayerGroupInfo)p);
        }
        for (StyleInfo style : groupInfo.getStyles()) {
            if (style == null) continue;
            this.attach(style);
        }
    }

    public void attach(StyleInfo styleInfo) {
        styleInfo = ModificationProxy.unwrap(styleInfo);
        ((StyleInfoImpl)styleInfo).setCatalog(this.catalog);
    }

    public void attach(NamespaceInfo nsInfo) {
    }

    public void attach(WorkspaceInfo wsInfo) {
    }

    public List<AttributeTypeInfo> getAttributes(FeatureType ft, FeatureTypeInfo info) {
        ArrayList<AttributeTypeInfo> attributes = new ArrayList<AttributeTypeInfo>();
        for (PropertyDescriptor pd : ft.getDescriptors()) {
            AttributeTypeInfo att = this.catalog.getFactory().createAttribute();
            att.setFeatureType(info);
            att.setName(pd.getName().getLocalPart());
            att.setMinOccurs(pd.getMinOccurs());
            att.setMaxOccurs(pd.getMaxOccurs());
            att.setNillable(pd.isNillable());
            att.setBinding(pd.getType().getBinding());
            int length = FeatureTypes.getFieldLength((PropertyDescriptor)pd);
            if (length > 0) {
                att.setLength(length);
            }
            attributes.add(att);
        }
        return attributes;
    }

    public ReferencedEnvelope getBoundsFromCRS(ResourceInfo resource) {
        Envelope crsEnvelope;
        ReferencedEnvelope crsReferencedEnvelope = null;
        ProjectionPolicy projPolicy = resource.getProjectionPolicy();
        CoordinateReferenceSystem crs = null;
        crs = projPolicy == ProjectionPolicy.NONE ? resource.getNativeCRS() : resource.getCRS();
        if (crs != null && (crsEnvelope = CRS.getEnvelope((CoordinateReferenceSystem)crs)) != null) {
            crsReferencedEnvelope = new ReferencedEnvelope(crsEnvelope);
        }
        return crsReferencedEnvelope;
    }
}

