/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.wicket.Localizer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.ServiceDescription;
import org.geoserver.web.ServiceDescriptionProvider;
import org.geoserver.web.ServiceLinkDescription;
import org.geotools.text.Text;
import org.geotools.util.Version;
import org.opengis.util.InternationalString;

public class RESTServiceDescriptionProvider
extends ServiceDescriptionProvider {
    public static final String SERVICE_TYPE = "REST";

    public List<ServiceDescription> getServices(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        InternationalString title;
        ArrayList<ServiceDescription> descriptions = new ArrayList<ServiceDescription>();
        Localizer localizer = GeoServerApplication.get().getResourceSettings().getLocalizer();
        if (workspaceInfo != null) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("workspace", workspaceInfo.getName());
            title = Text.text((String)localizer.getString("RESTServiceDescriptionProvider.workspace", null, (IModel)new Model(params)));
        } else {
            title = Text.text((String)localizer.getString("RESTServiceDescriptionProvider.title", null));
        }
        InternationalString description = Text.text((String)localizer.getString("RESTServiceDescriptionProvider.description", null));
        ServiceDescription restDescription = new ServiceDescription(SERVICE_TYPE, title, description, true, true, workspaceInfo != null ? workspaceInfo.getName() : null, layerInfo != null ? layerInfo.getName() : null);
        descriptions.add(restDescription);
        return descriptions;
    }

    public List<ServiceLinkDescription> getServiceLinks(WorkspaceInfo workspaceInfo, PublishedInfo layerInfo) {
        ArrayList<ServiceLinkDescription> links = new ArrayList<ServiceLinkDescription>();
        if (workspaceInfo == null) {
            links.add(new ServiceLinkDescription(SERVICE_TYPE, new Version("1.0.0"), "../rest", null, null, SERVICE_TYPE));
        } else {
            links.add(new ServiceLinkDescription(SERVICE_TYPE, new Version("1.0.0"), "../rest/workspaces/" + workspaceInfo.getName(), workspaceInfo != null ? workspaceInfo.getName() : null, null, SERVICE_TYPE));
        }
        return links;
    }
}

