/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.FileSystemWatcher;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceListener;
import org.geoserver.platform.resource.Resources;
import org.geotools.util.URLs;
import org.geotools.util.logging.Logging;

public final class Files {
    private static final Logger LOGGER = Logging.getLogger(Files.class);
    static final FileSystemWatcher watcher = new FileSystemWatcher();

    private Files() {
    }

    public static File url(File baseDirectory, String url) {
        String ss = StringUtils.removeStart((String)url, (String)"resource:");
        if (!Objects.equals(url, ss)) {
            Resource res = Resources.fromURL(Files.asResource(baseDirectory), ss);
            if (res == null) {
                return null;
            }
            return Resources.find(res, true);
        }
        if (url.startsWith("file:/")) {
            try {
                return URLs.urlToFile((URL)new URL(url));
            }
            catch (Exception res) {
                // empty catch block
            }
        }
        if (url.startsWith("file:")) {
            File f = new File(url = url.substring(5));
            if (f.isAbsolute() || f.exists()) {
                return f;
            }
            if (baseDirectory != null) {
                return new File(baseDirectory, url);
            }
            return f;
        }
        File file = new File(url);
        if (file.isAbsolute() || file.exists()) {
            return file;
        }
        if (baseDirectory != null && (file = new File(baseDirectory, url)).exists()) {
            return file;
        }
        return null;
    }

    public static Resource asResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File required");
        }
        return new ResourceAdaptor(file);
    }

    public static void schedule(long delay, TimeUnit unit) {
        watcher.schedule(delay, unit);
    }

    public static OutputStream out(final File file) throws FileNotFoundException {
        final File temp = new File(file.getParentFile(), file.getName() + ".tmp");
        if (temp.exists()) {
            temp.delete();
        }
        return new OutputStream(){
            FileOutputStream delegate;
            {
                this.delegate = new FileOutputStream(temp);
            }

            @Override
            public void close() throws IOException {
                this.delegate.close();
                Files.move(temp, file);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.delegate.write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                this.delegate.flush();
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.delegate.write(b);
            }

            @Override
            public void write(int b) throws IOException {
                this.delegate.write(b);
            }
        };
    }

    public static boolean move(File source, File dest) throws IOException {
        boolean samePath;
        if (source == null || !source.exists()) {
            throw new NullPointerException("File source required");
        }
        if (dest == null) {
            throw new NullPointerException("File dest required");
        }
        boolean win = System.getProperty("os.name").startsWith("Windows");
        boolean bl = samePath = win ? source.getCanonicalPath().equalsIgnoreCase(dest.getCanonicalPath()) : source.getCanonicalPath().equals(dest.getCanonicalPath());
        if (samePath) {
            return true;
        }
        if (win && dest.exists() && !dest.delete()) {
            throw new IOException("Failed to move " + source.getAbsolutePath() + " - unable to remove existing: " + dest.getCanonicalPath());
        }
        if (!source.renameTo(dest)) {
            throw new IOException("Failed to move " + source.getAbsolutePath() + " to " + dest.getAbsolutePath());
        }
        return true;
    }

    public static boolean delete(File file) {
        if (file.isDirectory()) {
            Files.emptyDirectory(file);
        }
        return file.delete();
    }

    private static boolean emptyDirectory(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " does not appear to be a directory at all...");
        }
        boolean allClean = true;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    allClean &= Files.delete(file);
                    continue;
                }
                if (file.delete()) continue;
                LOGGER.log(Level.WARNING, "Could not delete {0}", file.getAbsolutePath());
                allClean = false;
            }
        }
        return allClean;
    }

    static final class ResourceAdaptor
    implements Resource {
        final File file;

        private ResourceAdaptor(File file) {
            this.file = file.getAbsoluteFile();
        }

        @Override
        public String path() {
            return Paths.convert(this.file.getPath());
        }

        @Override
        public String name() {
            return this.file.getName();
        }

        @Override
        public Resource.Lock lock() {
            return () -> {};
        }

        @Override
        public void addListener(ResourceListener listener) {
            watcher.addListener(this.path(), listener);
        }

        @Override
        public void removeListener(ResourceListener listener) {
            watcher.removeListener(this.path(), listener);
        }

        @Override
        public InputStream in() {
            File actualFile = this.file();
            if (!actualFile.exists()) {
                throw new IllegalStateException("Cannot access " + actualFile);
            }
            try {
                return new FileInputStream(actualFile);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream out() {
            File temp;
            File actualFile = this.file();
            if (!actualFile.exists()) {
                throw new IllegalStateException("Cannot access " + actualFile);
            }
            ResourceAdaptor resourceAdaptor = this;
            synchronized (resourceAdaptor) {
                UUID uuid;
                File tryTemp;
                do {
                    uuid = UUID.randomUUID();
                } while ((tryTemp = new File(this.file.getParentFile(), String.format("%s.%s.tmp", this.file.getName(), uuid))).exists());
                temp = tryTemp;
            }
            try {
                temp.createNewFile();
                return new OutputStream(){
                    FileOutputStream delegate;
                    {
                        this.delegate = new FileOutputStream(temp);
                    }

                    @Override
                    public void close() throws IOException {
                        this.delegate.close();
                        if (temp.exists()) {
                            Files.move(temp, file);
                        }
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                        this.delegate.write(b, off, len);
                    }

                    @Override
                    public void flush() throws IOException {
                        this.delegate.flush();
                    }

                    @Override
                    public void write(byte[] b) throws IOException {
                        this.delegate.write(b);
                    }

                    @Override
                    public void write(int b) throws IOException {
                        this.delegate.write(b);
                    }
                };
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Could not create temporary file {0} writing directly to {1} instead.", new Object[]{temp, actualFile});
                try {
                    return new FileOutputStream(actualFile);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        @Override
        public File file() {
            if (this.file.isDirectory()) {
                throw new IllegalStateException("Cannot create file: is already a directory.");
            }
            try {
                if (!(this.file.exists() || (this.file.getParentFile() == null || this.file.getParentFile().exists() || this.file.getParentFile().mkdirs()) && this.file.createNewFile())) {
                    throw new IllegalStateException("Could not create file.");
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return this.file;
        }

        @Override
        public File dir() {
            if (this.file.exists() && !this.file.isDirectory()) {
                throw new IllegalStateException("Cannot create directory: is already a file.");
            }
            if (!this.file.exists() && !this.file.mkdirs()) {
                throw new IllegalStateException("Could not create directory.");
            }
            return this.file;
        }

        @Override
        public long lastmodified() {
            return this.file.lastModified();
        }

        @Override
        public Resource parent() {
            return new ResourceAdaptor(this.file.getParentFile());
        }

        @Override
        public Resource get(String resourcePath) {
            return new ResourceAdaptor(new File(this.file, resourcePath));
        }

        @Override
        public List<Resource> list() {
            if (!this.file.isDirectory()) {
                return Collections.emptyList();
            }
            ArrayList<Resource> result = new ArrayList<Resource>();
            for (File child : Optional.ofNullable(this.file.listFiles()).orElse(new File[0])) {
                result.add(new ResourceAdaptor(child));
            }
            return result;
        }

        @Override
        public Resource.Type getType() {
            return this.file.exists() ? (this.file.isDirectory() ? Resource.Type.DIRECTORY : Resource.Type.RESOURCE) : Resource.Type.UNDEFINED;
        }

        public String toString() {
            return "ResourceAdaptor(" + this.file + ")";
        }

        @Override
        public boolean delete() {
            return Files.delete(this.file);
        }

        @Override
        public boolean renameTo(Resource dest) {
            if (dest instanceof FileSystemResourceStore.FileSystemResource) {
                return this.file.renameTo(((FileSystemResourceStore.FileSystemResource)dest).file);
            }
            if (dest instanceof ResourceAdaptor) {
                return this.file.renameTo(((ResourceAdaptor)dest).file);
            }
            return Resources.renameByCopy(this, dest);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourceAdaptor other = (ResourceAdaptor)obj;
            return !(this.file == null ? other.file != null : !this.file.equals(other.file));
        }
    }
}

