/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;

public class OWS20Exception
extends ServiceException {
    private static final Logger LOGGER = Logging.getLogger(OWS20Exception.class);
    private static final long serialVersionUID = 7254349181794561724L;
    protected Integer httpCode;

    public OWS20Exception(String message) {
        super(message);
    }

    public OWS20Exception(String message, Throwable cause) {
        super(message, cause);
    }

    public OWS20Exception(String message, Throwable cause, String code) {
        this(message, cause);
    }

    protected OWS20Exception(String message, Throwable cause, String code, String locator) {
        super(message, cause, code);
    }

    public OWS20Exception(String message, Throwable cause, OWSExceptionCode code, String locator) {
        super(message, cause, code.getExceptionCode());
        this.setHttpCode(code.getHttpCode());
    }

    protected OWS20Exception(String message, String code) {
        super(message);
    }

    public OWS20Exception(String message, OWSExceptionCode code) {
        super(message, code.getExceptionCode());
        this.setHttpCode(code.getHttpCode());
    }

    protected OWS20Exception(String message, String code, String locator) {
        super(message, code);
    }

    public OWS20Exception(String message, OWSExceptionCode code, String locator) {
        super(message, code.getExceptionCode(), locator);
        this.setHttpCode(code.getHttpCode());
    }

    public OWS20Exception(Throwable cause) {
        super(cause);
    }

    protected OWS20Exception(Throwable cause, String code) {
        super(cause);
    }

    protected OWS20Exception(Throwable cause, String code, String locator) {
        super(cause, code);
    }

    public OWS20Exception(Throwable cause, OWSExceptionCode code, String locator) {
        super(cause, code.getExceptionCode());
        this.setHttpCode(code.getHttpCode());
    }

    public Integer getHttpCode() {
        return this.httpCode;
    }

    public void setHttpCode(Integer httpCode) {
        this.httpCode = httpCode;
    }

    @Override
    public String toString() {
        String msg = super.toString();
        if (this.httpCode == null) {
            return msg;
        }
        return msg + NEW_LINE + "HTTPcode:" + this.httpCode;
    }

    public static class OWSExceptionCode {
        private static final Map<String, OWSExceptionCode> codes = new HashMap<String, OWSExceptionCode>();
        public static final OWSExceptionCode OperationNotSupported = new OWSExceptionCode("OperationNotSupported", 501, "Not Implemented");
        public static final OWSExceptionCode MissingParameterValue = new OWSExceptionCode("MissingParameterValue", 400, "Bad request");
        public static final OWSExceptionCode InvalidParameterValue = new OWSExceptionCode("InvalidParameterValue", 400, "Bad request");
        public static final OWSExceptionCode VersionNegotiationFailed = new OWSExceptionCode("VersionNegotiationFailed", 400, "Bad request");
        public static final OWSExceptionCode InvalidUpdateSequence = new OWSExceptionCode("InvalidUpdateSequence", 400, "Bad request");
        public static final OWSExceptionCode OptionNotSupported = new OWSExceptionCode("OptionNotSupported", 501, "Not Implemented");
        public static final OWSExceptionCode NoApplicableCode = new OWSExceptionCode("NoApplicableCode", 500, "Not Implemented");
        public static final OWSExceptionCode NotFound = new OWSExceptionCode("NotFound", 404, "Not found");
        public static final OWSExceptionCode InvalidCoverageType = new OWSExceptionCode("InvalidCoverageType", 404, "Coverage addressed is not a grid coverage");
        private final String exceptionCode;
        private final Integer httpCode;
        private final String httpMessage;

        public OWSExceptionCode(String exceptionCode) {
            this(exceptionCode, null, null);
        }

        public OWSExceptionCode(String exceptionCode, Integer httpCode) {
            this(exceptionCode, httpCode, null);
        }

        protected OWSExceptionCode(String exceptionCode, Integer httpCode, String message) {
            this.exceptionCode = exceptionCode;
            this.httpCode = httpCode;
            this.httpMessage = message;
            OWSExceptionCode old = codes.put(exceptionCode, this);
            if (old != null) {
                LOGGER.warning("Replacing exception code " + old + " with " + this);
            }
        }

        public String getExceptionCode() {
            return this.exceptionCode;
        }

        public Integer getHttpCode() {
            return this.httpCode;
        }

        public String getHttpMessage() {
            return this.httpMessage;
        }

        public static OWSExceptionCode getByCode(String code) {
            return codes.get(code);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName()).append("[exCode:").append(this.exceptionCode).append(" httpCode=").append(this.httpCode);
            if (this.httpMessage != null) {
                builder.append(" httpMessage=").append(this.httpMessage);
            }
            builder.append(']');
            return builder.toString();
        }
    }
}

