/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceNotificationDispatcher;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.Resources;
import org.geotools.util.logging.Logging;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.web.context.ServletContextAware;

public class GeoServerResourceLoader
extends DefaultResourceLoader
implements ResourceStore,
ServletContextAware {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.platform");
    ResourceStore resources;
    File baseDirectory;

    public GeoServerResourceLoader() {
        this.baseDirectory = null;
        this.resources = ResourceStore.EMPTY;
    }

    public GeoServerResourceLoader(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        this.resources = new FileSystemResourceStore(baseDirectory);
    }

    public GeoServerResourceLoader(ResourceStore resourceStore) {
        this.resources = resourceStore;
    }

    public void setServletContext(ServletContext servletContext) {
        if (this.baseDirectory == null) {
            String data = GeoServerResourceLoader.lookupGeoServerDataDirectory(servletContext);
            if (data != null) {
                this.baseDirectory = new File(data);
            } else {
                throw new IllegalStateException("Unable to determine data directory");
            }
        }
        if (this.resources == ResourceStore.EMPTY && this.baseDirectory != null) {
            this.resources = new FileSystemResourceStore(this.baseDirectory);
        }
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(File baseDirectory) {
        this.baseDirectory = baseDirectory;
        if (this.resources == ResourceStore.EMPTY) {
            this.resources = new FileSystemResourceStore(baseDirectory);
        }
    }

    @Override
    public Resource get(String path) {
        return this.resources.get(path);
    }

    @Override
    public boolean move(String path, String target) {
        return this.resources.move(path, target);
    }

    @Override
    public boolean remove(String path) {
        return this.resources.remove(path);
    }

    public Resource fromURL(String url) {
        return Resources.fromURL(this.resources.get(""), url);
    }

    public Resource fromURL(URL url) {
        return Resources.fromURL(this.resources.get(""), url);
    }

    public Resource fromPath(String path) {
        return Resources.fromPath(path, this.resources.get(""));
    }

    public File find(String location) throws IOException {
        Resource resource = this.get(Paths.convert(location));
        return Resources.find(resource);
    }

    public File find(File parentFile, String location) throws IOException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Looking up resource " + location + " with parent " + (parentFile != null ? parentFile.getPath() : "null"));
        }
        Resource resource = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.find(resource);
    }

    public File find(String ... location) throws IOException {
        Resource resource = this.get(Paths.path(location));
        return Resources.find(resource);
    }

    public File find(File parentFile, String ... location) throws IOException {
        Resource resource = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.find(resource);
    }

    String concat(String ... location) {
        StringBuffer loc = new StringBuffer();
        for (String s : location) {
            loc.append(s).append(File.separator);
        }
        loc.setLength(loc.length() - 1);
        return loc.toString();
    }

    public File findOrCreateDirectory(String ... location) throws IOException {
        Resource directory = this.get(Paths.path(location));
        return directory.dir();
    }

    public File findOrCreateDirectory(File parentFile, String ... location) throws IOException {
        Resource directory = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return directory.dir();
    }

    public File findOrCreateDirectory(String location) throws IOException {
        Resource directory = this.get(Paths.convert(location));
        return directory.dir();
    }

    public File findOrCreateDirectory(File parentFile, String location) throws IOException {
        Resource directory = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return directory.dir();
    }

    public File createDirectory(String ... location) throws IOException {
        Resource directory = this.get(Paths.path(location));
        return Resources.createNewDirectory(directory);
    }

    public File createDirectory(File parentFile, String ... location) throws IOException {
        Resource directory = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.createNewDirectory(directory);
    }

    public File createDirectory(String location) throws IOException {
        Resource directory = this.get(Paths.convert(location));
        return Resources.createNewDirectory(directory);
    }

    public File createDirectory(File parentFile, String location) throws IOException {
        Resource directory = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.createNewDirectory(directory);
    }

    public File createFile(String ... location) throws IOException {
        Resource resource = this.get(Paths.path(location));
        return Resources.createNewFile(resource);
    }

    public File createFile(String location) throws IOException {
        Resource resource = this.get(Paths.convert(location));
        return Resources.createNewFile(resource);
    }

    public File createFile(File parentFile, String ... location) throws IOException {
        Resource resource = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.createNewFile(resource);
    }

    public File createFile(File parentFile, String location) throws IOException {
        Resource resource = this.get(Paths.convert(this.getBaseDirectory(), parentFile, location));
        return Resources.createNewFile(resource);
    }

    public void copyFromClassPath(String classpathResource, String location) throws IOException {
        Resource resource = this.get(Paths.convert(location));
        this.copyFromClassPath(classpathResource, resource.file());
    }

    public void copyFromClassPath(String classpathResource, File target) throws IOException {
        this.copyFromClassPath(classpathResource, target, null);
    }

    public void copyFromClassPath(String classpathResource, File target, Class<?> scope) throws IOException {
        byte[] buffer = new byte[4096];
        try (InputStream is = this.getStreamFromResource(classpathResource, scope);
             FileOutputStream os = new FileOutputStream(target);){
            int read;
            while ((read = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, read);
            }
        }
        catch (FileNotFoundException targetException) {
            throw new IOException("Can't write to file " + target.getAbsolutePath() + ". Check write permissions on target folder for user " + System.getProperty("user.name"));
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Unable to copy logging configuration file", e);
        }
    }

    private InputStream getStreamFromResource(String classpathResource, Class<?> scope) throws IOException {
        InputStream is = null;
        if (scope == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathResource);
            if (is == null) {
                throw new IOException("Could not load " + classpathResource + " from scope " + Thread.currentThread().getContextClassLoader().toString() + ".");
            }
        } else {
            is = scope.getResourceAsStream(classpathResource);
            if (is == null) {
                throw new IOException("Could not load " + classpathResource + " from scope " + scope.toString() + ".");
            }
        }
        return is;
    }

    public static String lookupGeoServerDataDirectory(ServletContext servContext) {
        String[] typeStrs = new String[]{"Java environment variable ", "Servlet context parameter ", "System environment variable "};
        String requireFileVar = "GEOSERVER_REQUIRE_FILE";
        GeoServerResourceLoader.requireFile(System.getProperty(requireFileVar), typeStrs[0] + requireFileVar);
        GeoServerResourceLoader.requireFile(servContext.getInitParameter(requireFileVar), typeStrs[1] + requireFileVar);
        GeoServerResourceLoader.requireFile(System.getenv(requireFileVar), typeStrs[2] + requireFileVar);
        String[] varStrs = new String[]{"GEOSERVER_DATA_DIR", "GEOSERVER_DATA_ROOT"};
        String dataDirStr = null;
        String msgPrefix = null;
        for (int i = 0; i < varStrs.length && dataDirStr == null; ++i) {
            for (int j = 0; j < typeStrs.length && dataDirStr == null; ++j) {
                String value = null;
                String varStr = varStrs[i];
                String typeStr = typeStrs[j];
                switch (j) {
                    case 0: {
                        value = System.getProperty(varStr);
                        break;
                    }
                    case 1: {
                        value = servContext.getInitParameter(varStr);
                        break;
                    }
                    case 2: {
                        value = System.getenv(varStr);
                    }
                }
                if (value == null || value.equalsIgnoreCase("")) {
                    LOGGER.finer("Found " + typeStr + varStr + " to be unset");
                    continue;
                }
                File fh = new File(value);
                msgPrefix = "Found " + typeStr + varStr + " set to " + value;
                if (!fh.exists()) {
                    LOGGER.warning(msgPrefix + " , but this path does not exist");
                    continue;
                }
                if (!fh.isDirectory()) {
                    LOGGER.warning(msgPrefix + " , which is not a directory");
                    continue;
                }
                if (!fh.canWrite()) {
                    LOGGER.warning(msgPrefix + " , which is not writeable");
                    continue;
                }
                LOGGER.finer(msgPrefix);
                dataDirStr = value;
            }
        }
        if (dataDirStr == null) {
            dataDirStr = servContext.getRealPath("/data");
            LOGGER.finer("Falling back to embedded data directory: '" + dataDirStr + "'");
        }
        return dataDirStr;
    }

    static void requireFile(String files, String source) {
        if (files == null || files.isEmpty()) {
            return;
        }
        for (String file : files.split(File.pathSeparator)) {
            if (new File(file).exists()) continue;
            throw new IllegalArgumentException("Missing required file: " + file + " From: " + source + ": " + files);
        }
    }

    @Override
    public ResourceNotificationDispatcher getResourceNotificationDispatcher() {
        return this.resources.getResourceNotificationDispatcher();
    }

    public ResourceStore getResourceStore() {
        return this.resources;
    }
}

