/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.platform;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;

public class FileWatcher<T> {
    protected Resource resource;
    protected long lastModified = Long.MIN_VALUE;
    protected long lastCheck;
    protected boolean stale;

    public FileWatcher(Resource resource) {
        this.resource = resource;
    }

    public FileWatcher(File file) {
        this.resource = Files.asResource(file);
    }

    public File getFile() {
        return this.resource.file();
    }

    public Resource getResource() {
        return this.resource;
    }

    public T read() throws IOException {
        T result = null;
        if (this.resource.getType() == Resource.Type.RESOURCE) {
            try (InputStream is = this.resource.in();){
                result = this.parseFileContents(is);
                this.lastModified = this.resource.lastmodified();
                this.lastCheck = System.currentTimeMillis();
                this.stale = false;
            }
        }
        return result;
    }

    protected T parseFileContents(InputStream in) throws IOException {
        return null;
    }

    public boolean isModified() {
        long now = System.currentTimeMillis();
        if (now - this.lastCheck > 1000L) {
            this.lastCheck = now;
            this.stale = this.resource.getType() != Resource.Type.UNDEFINED && this.resource.lastmodified() != this.lastModified;
        }
        return this.stale;
    }

    public void setKnownLastModified(long lastModified) {
        this.lastModified = lastModified;
    }
}

