/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.property;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.springframework.util.StringUtils;

public class PropertyEditorFormComponent
extends FormComponentPanel<Properties> {
    private static final long serialVersionUID = -1960584178014140068L;
    ListView<Tuple> listView;
    List<Tuple> invalidTuples = null;

    public PropertyEditorFormComponent(String id) {
        super(id);
        this.initComponents();
    }

    public PropertyEditorFormComponent(String id, IModel<Properties> model) {
        super(id, model);
        this.initComponents();
    }

    void initComponents() {
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.listView = new ListView<Tuple>("list"){
            private static final long serialVersionUID = -7250612551499360015L;

            protected void populateItem(ListItem<Tuple> item) {
                item.setModel((IModel)new CompoundPropertyModel(item.getModelObject()));
                item.add(new Component[]{new TextField("key").add(new Behavior[]{this.getEmptyBlurBehavior()})});
                item.add(new Component[]{new TextField("value").add(new Behavior[]{this.getEmptyBlurBehavior()})});
                item.add(new Component[]{new AjaxLink<Tuple>("remove", item.getModel()){
                    private static final long serialVersionUID = 3201264868229144613L;

                    public void onClick(AjaxRequestTarget target) {
                        List l = PropertyEditorFormComponent.this.listView.getModelObject();
                        l.remove(this.getModelObject());
                        target.add(new Component[]{container});
                    }
                }});
            }

            private AjaxFormComponentUpdatingBehavior getEmptyBlurBehavior() {
                return new AjaxFormComponentUpdatingBehavior("blur"){
                    private static final long serialVersionUID = 5416373713193788662L;

                    protected void onUpdate(AjaxRequestTarget target) {
                    }
                };
            }
        };
        container.add(new Component[]{this.listView});
        this.add(new Component[]{new AjaxLink<Void>("add"){
            private static final long serialVersionUID = 4741595573705562351L;

            public void onClick(AjaxRequestTarget target) {
                PropertyEditorFormComponent.this.listView.getModelObject().add(new Tuple());
                target.add(new Component[]{container});
            }
        }});
    }

    List<Tuple> tuples() {
        if (this.invalidTuples != null) {
            return this.invalidTuples;
        }
        Properties props = (Properties)this.getModelObject();
        if (props == null) {
            props = new Properties();
        }
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            tuples.add(new Tuple((String)e.getKey(), (String)e.getValue()));
        }
        Collections.sort(tuples);
        return tuples;
    }

    protected void onBeforeRender() {
        this.listView.setModel((IModel)new ListModel(this.tuples()));
        super.onBeforeRender();
    }

    public void convertInput() {
        for (Component component : this.listView) {
            ListItem item = (ListItem)component;
            ((FormComponent)item.get("key")).updateModel();
            ((FormComponent)item.get("value")).updateModel();
        }
        Properties props = (Properties)this.getModelObject();
        if (props == null) {
            props = new Properties();
        }
        props.clear();
        for (Tuple t : this.listView.getModelObject()) {
            props.put(t.getKey(), t.getValue());
        }
        this.setConvertedInput(props);
    }

    public void validate() {
        this.invalidTuples = null;
        for (Tuple t : this.listView.getModelObject()) {
            if (!StringUtils.hasLength((String)t.getKey())) {
                this.invalidTuples = this.listView.getModelObject();
                this.error((IValidationError)new ValidationError("KeyRequired").addKey("KeyRequired"));
                return;
            }
            if (StringUtils.hasLength((String)t.getValue())) continue;
            this.invalidTuples = this.listView.getModelObject();
            this.error((IValidationError)new ValidationError("ValueRequired").addKey("ValueRequired"));
            return;
        }
        super.validate();
    }

    static class Tuple
    implements Serializable,
    Comparable<Tuple> {
        private static final long serialVersionUID = 1L;
        private String key;
        private String value;

        public Tuple() {
        }

        public Tuple(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public int compareTo(Tuple o) {
            return this.key != null ? this.key.compareTo(o.key) : (o.key == null ? 0 : -1);
        }
    }
}

