/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.awt.AWTError;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.browser.FileBreadcrumbs;
import org.geoserver.web.wicket.browser.FileDataView;
import org.geoserver.web.wicket.browser.FileProvider;
import org.geoserver.web.wicket.browser.FileRootsFinder;
import org.geotools.util.logging.Logging;

public class GeoServerFileChooser
extends Panel {
    private static final long serialVersionUID = -6246944669686555266L;
    static Boolean HIDE_FS = null;
    static File USER_HOME;
    static final Logger LOGGER;
    FileBreadcrumbs breadcrumbs;
    FileDataView fileTable;
    boolean hideFileSystem = false;
    IModel<File> file;

    public GeoServerFileChooser(String id, IModel<File> file) {
        this(id, file, HIDE_FS);
    }

    public GeoServerFileChooser(String id, IModel<File> file, boolean hideFileSystem) {
        super(id, file);
        File relativeToDataDir;
        this.file = file;
        this.hideFileSystem = hideFileSystem;
        FileRootsFinder fileRootsFinder = new FileRootsFinder(hideFileSystem, true);
        ArrayList<File> roots = fileRootsFinder.getRoots();
        GeoServerResourceLoader loader = fileRootsFinder.getLoader();
        File dataDirectory = fileRootsFinder.getDataDirectory();
        File selection = (File)file.getObject();
        if (selection != null && (relativeToDataDir = Resources.find((Resource)Resources.fromURL((Resource)Files.asResource((File)loader.getBaseDirectory()), (String)selection.getPath()), (boolean)true)) != null) {
            selection = relativeToDataDir;
        }
        File selectionRoot = null;
        if (selection != null && selection.exists()) {
            for (File root : roots) {
                if (!this.isSubfile(root, selection.getAbsoluteFile())) continue;
                selectionRoot = root;
                break;
            }
            if (selectionRoot == null) {
                selectionRoot = dataDirectory;
                file = new Model((Serializable)selectionRoot);
            } else {
                file = !selection.isDirectory() ? new Model((Serializable)selection.getParentFile()) : new Model((Serializable)selection);
            }
        } else {
            selectionRoot = dataDirectory;
            file = new Model((Serializable)selectionRoot);
        }
        this.file = file;
        this.setDefaultModel((IModel)file);
        final DropDownChoice choice = new DropDownChoice("roots", (IModel)new Model((Serializable)selectionRoot), (IModel)new Model(roots), (IChoiceRenderer)new FileRootsRenderer((Component)this));
        choice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1527567847101388940L;

            protected void onUpdate(AjaxRequestTarget target) {
                File selection = (File)choice.getModelObject();
                GeoServerFileChooser.this.breadcrumbs.setRootFile(selection);
                GeoServerFileChooser.this.updateFileBrowser(selection, target);
            }
        }});
        choice.setOutputMarkupId(true);
        this.add(new Component[]{choice});
        this.breadcrumbs = new FileBreadcrumbs("breadcrumbs", (IModel)new Model((Serializable)selectionRoot), (IModel)file){
            private static final long serialVersionUID = -6995769189316700797L;

            @Override
            protected void pathItemClicked(File file, AjaxRequestTarget target) {
                GeoServerFileChooser.this.updateFileBrowser(file, target);
            }
        };
        this.breadcrumbs.setOutputMarkupId(true);
        this.add(new Component[]{this.breadcrumbs});
        this.fileTable = new FileDataView("fileTable", new FileProvider((IModel<File>)file)){
            private static final long serialVersionUID = -5481794219862786117L;

            @Override
            protected void linkNameClicked(File file, AjaxRequestTarget target) {
                GeoServerFileChooser.this.updateFileBrowser(file, target);
            }
        };
        this.fileTable.setOutputMarkupId(true);
        this.add(new Component[]{this.fileTable});
    }

    void updateFileBrowser(File file, AjaxRequestTarget target) {
        if (file.isDirectory()) {
            this.directoryClicked(file, target);
        } else if (file.isFile()) {
            this.fileClicked(file, target);
        }
    }

    protected void fileClicked(File file, AjaxRequestTarget target) {
    }

    protected void directoryClicked(File file, AjaxRequestTarget target) {
        this.file.setObject((Object)file);
        this.fileTable.getProvider().setDirectory((IModel<File>)new Model((Serializable)file));
        this.breadcrumbs.setSelection(file);
        target.add(new Component[]{this.fileTable});
        target.add(new Component[]{this.breadcrumbs});
    }

    private boolean isSubfile(File root, File selection) {
        if (selection == null || "".equals(selection.getPath())) {
            return false;
        }
        if (selection.equals(root)) {
            return true;
        }
        return this.isSubfile(root, selection.getParentFile());
    }

    public void setFilter(IModel<? extends FileFilter> fileFilter) {
        this.fileTable.provider.setFileFilter(fileFilter);
    }

    public void setFileTableHeight(String height) {
        this.fileTable.setTableHeight(height);
    }

    static {
        HIDE_FS = Boolean.valueOf(GeoServerExtensions.getProperty((String)"GEOSERVER_FILEBROWSER_HIDEFS"));
        USER_HOME = null;
        try {
            File hf = null;
            String home = System.getProperty("user.home");
            if (home != null) {
                hf = new File(home);
            }
            if (hf != null && hf.exists()) {
                USER_HOME = hf;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LOGGER = Logging.getLogger(GeoServerFileChooser.class);
    }

    static class FileRootsRenderer
    extends ChoiceRenderer<File> {
        private static final long serialVersionUID = 1389015915737006638L;
        Component component;

        public FileRootsRenderer(Component component) {
            this.component = component;
        }

        public Object getDisplayValue(File f) {
            if (f == USER_HOME) {
                return new ParamResourceModel("userHome", this.component, new Object[0]).getString();
            }
            GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
            if (f.equals(loader.getBaseDirectory())) {
                return new ParamResourceModel("dataDirectory", this.component, new Object[0]).getString();
            }
            try {
                String displayName = FileSystemView.getFileSystemView().getSystemDisplayName(f);
                if (displayName != null && !displayName.trim().isEmpty()) {
                    return displayName.trim();
                }
                return FilenameUtils.getPrefix((String)f.getAbsolutePath());
            }
            catch (AWTError | Exception e) {
                LOGGER.log(Level.FINE, "Failed to get file display name, on Windows this might be related to a known java bug http://bugs.java.com/bugdatabase/view_bug.do?bug_id=6973685", e);
                return f.getName();
            }
        }

        public String getIdValue(File f, int count) {
            return "" + count;
        }
    }
}

