/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.web.wicket.browser.GeoServerFileChooser;

public class FileRootsFinder
implements Serializable {
    private ArrayList<File> roots = new ArrayList();
    private File dataDirectory;

    public FileRootsFinder(boolean includeDataDir) {
        this(GeoServerFileChooser.HIDE_FS, includeDataDir);
    }

    public FileRootsFinder(boolean hideFileSystem, boolean includeDataDir) {
        if (!hideFileSystem) {
            this.roots.addAll(Arrays.asList(File.listRoots()));
        }
        Collections.sort(this.roots);
        GeoServerResourceLoader loader = this.getLoader();
        this.dataDirectory = loader.getBaseDirectory();
        if (includeDataDir) {
            this.roots.add(0, this.dataDirectory);
        }
        if (!hideFileSystem && GeoServerFileChooser.USER_HOME != null) {
            this.roots.add(1, GeoServerFileChooser.USER_HOME);
        }
    }

    public ArrayList<File> getRoots() {
        return this.roots;
    }

    public GeoServerResourceLoader getLoader() {
        return (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public Stream<String> getMatches(String input, FileFilter fileFilter) {
        PathSplitter ddSplitter = new PathSplitter(input, true);
        GeoServerResourceLoader loader = this.getLoader();
        Resource resource = loader.get(ddSplitter.base);
        File dataDirectoryRoot = loader.get("/").dir();
        Stream<String> result = resource.list().stream().filter(r -> r.name().toLowerCase().contains(ddSplitter.name)).filter(r -> fileFilter == null || fileFilter.accept(new File(dataDirectoryRoot, r.path()))).map(r -> ddSplitter.buildPath(r.name()));
        PathSplitter fsSplitter = new PathSplitter(input, false);
        Iterator<File> iterator = this.getRoots().iterator();
        while (iterator.hasNext()) {
            File searchBase;
            String[] names;
            String pathInRoot = fsSplitter.base;
            File root = iterator.next();
            if (!pathInRoot.startsWith(root.getPath())) continue;
            if ((pathInRoot = pathInRoot.substring(root.getPath().length())).startsWith(File.separator)) {
                pathInRoot = pathInRoot.substring(1);
            }
            if ((names = (searchBase = new File(root, pathInRoot)).list((dir, fileName) -> fileName.toLowerCase().contains(fsSplitter.name))) == null) continue;
            Stream<String> rootPaths = Arrays.stream(names).filter(name -> fileFilter == null || fileFilter.accept(new File(fsSplitter.base, (String)name))).map(fileName -> fsSplitter.buildPath(fileName));
            result = Stream.concat(result, rootPaths);
        }
        return result.distinct().sorted();
    }

    static class PathSplitter {
        String separator;
        boolean dataDirectoryPath;
        String base;
        String name;

        public PathSplitter(String input, boolean dataDirectoryPath) {
            int idx;
            this.separator = dataDirectoryPath ? "/" : File.separator;
            this.dataDirectoryPath = dataDirectoryPath;
            if (input.startsWith("file:")) {
                input = input.startsWith("file:/") ? (input.startsWith("file://") ? input.substring(7) : input.substring(6)) : input.substring(5);
            }
            if ((idx = input.lastIndexOf(this.separator)) >= 0) {
                this.base = input.substring(0, idx);
                this.name = input.substring(idx + 1, input.length()).toLowerCase();
            } else {
                this.base = this.separator;
                this.name = input.toLowerCase();
            }
            if (dataDirectoryPath) {
                this.base = Paths.convert((String)this.base);
            }
        }

        private String buildPath(String name) {
            String prefix = this.dataDirectoryPath ? "file:" : "file://";
            String localBase = this.base;
            if (this.dataDirectoryPath && localBase.startsWith(this.separator)) {
                localBase = this.base.substring(1);
            }
            if (localBase.endsWith(this.separator)) {
                return prefix + localBase + name;
            }
            return prefix + localBase + this.separator + name;
        }
    }
}

