/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket.browser;

import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidator;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.browser.FileInput;
import org.geoserver.web.wicket.browser.GeoServerFileChooser;

public class DirectoryInput
extends FileInput {
    private static final long serialVersionUID = -8317791966175845831L;
    protected GeoServerDialog gsDialog;

    @SafeVarargs
    public DirectoryInput(String id, IModel<String> paramValue, IModel<String> paramLabelModel, boolean required, IValidator<? super String> ... validators) {
        super(id, paramValue, paramLabelModel, required, validators);
        this.remove((Component)this.dialog);
        Component[] componentArray = new Component[1];
        this.gsDialog = new GeoServerDialog("dialog");
        componentArray[0] = this.gsDialog;
        this.add(componentArray);
    }

    @Override
    protected Component chooserButton(final String windowTitle) {
        AjaxSubmitLink link = new AjaxSubmitLink("chooser"){
            private static final long serialVersionUID = -2860146532287292092L;

            public boolean getDefaultFormProcessing() {
                return false;
            }

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                DirectoryInput.this.gsDialog.setTitle((IModel<String>)new Model((Serializable)((Object)windowTitle)));
                DirectoryInput.this.gsDialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                    private static final long serialVersionUID = 1576266249751904398L;

                    @Override
                    protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                        GeoServerFileChooser chooser = (GeoServerFileChooser)contents;
                        String path = ((File)chooser.getDefaultModelObject()).getAbsolutePath();
                        DirectoryInput.this.textField.clearInput();
                        DirectoryInput.this.textField.setModelValue(new String[]{path});
                        target.add(new Component[]{DirectoryInput.this.textField});
                        return true;
                    }

                    @Override
                    public void onClose(AjaxRequestTarget target) {
                        target.add(new Component[]{DirectoryInput.this.textField});
                    }

                    @Override
                    protected Component getContents(String id) {
                        File file = null;
                        DirectoryInput.this.textField.processInput();
                        String input = (String)DirectoryInput.this.textField.getConvertedInput();
                        if (input != null && !input.equals("")) {
                            file = new File(input);
                        }
                        GeoServerFileChooser chooser = new GeoServerFileChooser(id, (IModel<File>)new Model(file));
                        chooser.setFilter((IModel<? extends FileFilter>)DirectoryInput.this.fileFilter);
                        return chooser;
                    }
                });
            }
        };
        return link;
    }
}

