/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.model.IModel;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class SRSToCRSModel
implements IModel<CoordinateReferenceSystem> {
    private static final long serialVersionUID = 1887687559796645124L;
    private static final Logger LOGGER = Logging.getLogger(SRSToCRSModel.class);
    IModel<String> srsModel;

    public SRSToCRSModel(IModel<String> srsModel) {
        this.srsModel = srsModel;
    }

    public CoordinateReferenceSystem getObject() {
        String srs = (String)this.srsModel.getObject();
        if (srs == null || "UNKNOWN".equals(srs)) {
            return null;
        }
        try {
            return CRS.decode((String)srs);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setObject(CoordinateReferenceSystem object) {
        CoordinateReferenceSystem crs = object;
        try {
            Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
            String srs = epsgCode != null ? "EPSG:" + epsgCode : null;
            this.srsModel.setObject(srs);
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Failed to lookup the SRS code for " + crs);
            this.srsModel.setObject(null);
        }
    }

    public void detach() {
        this.srsModel.detach();
    }
}

