/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.factory.Hints;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.crs.GeoserverCustomWKTFactory;

public class SRSProvider
extends GeoServerDataProvider<SRS> {
    private static final long serialVersionUID = 3731647638872356912L;
    private static Pattern NUMERIC = Pattern.compile("\\d+");
    private static CRSAuthorityFactory customFactory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, GeoserverCustomWKTFactory.class));
    public static final GeoServerDataProvider.Property<SRS> CODE = new GeoServerDataProvider.BeanProperty<SRS>("code", "code"){
        private static final long serialVersionUID = -1638823520421390286L;

        @Override
        public Comparator<SRS> getComparator() {
            return new CodeComparator();
        }
    };
    public static final GeoServerDataProvider.Property<SRS> DESCRIPTION = new GeoServerDataProvider.BeanProperty<SRS>("description", "description"){
        private static final long serialVersionUID = 3549074714488486991L;

        @Override
        public Comparator<SRS> getComparator() {
            return (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getDescription(), o2.getDescription());
        }
    };
    private static final ArrayList<GeoServerDataProvider.Property<SRS>> PROPERTIES = new ArrayList<GeoServerDataProvider.Property>(Arrays.asList(CODE, DESCRIPTION));
    private volatile List<SRS> items;

    public SRSProvider() {
    }

    public SRSProvider(List<String> srsList) {
        ArrayList<SRS> otherSRS = new ArrayList<SRS>();
        for (String srs : srsList) {
            if (srs.startsWith("EPSG:")) {
                srs = srs.substring("EPSG:".length());
            }
            otherSRS.add(new SRS(srs));
        }
        this.items = otherSRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<SRS> getItems() {
        if (this.items == null) {
            SRSProvider sRSProvider = this;
            synchronized (sRSProvider) {
                if (this.items == null) {
                    this.items = SRSProvider.buildCodeList();
                }
            }
        }
        return this.items;
    }

    @Override
    protected List<GeoServerDataProvider.Property<SRS>> getProperties() {
        return PROPERTIES;
    }

    static List<SRS> buildCodeList() {
        Set codes = CRS.getSupportedCodes((String)"EPSG");
        try {
            codes.addAll(customFactory.getAuthorityCodes(CoordinateReferenceSystem.class));
        }
        catch (FactoryException e) {
            LOGGER.log(Level.WARNING, "Error occurred while trying to gather custom CRS codes", e);
        }
        HashSet<SRS> idSet = new HashSet<SRS>();
        for (String code : codes) {
            String id = code.substring(code.indexOf(58) + 1);
            if (!NUMERIC.matcher(id).matches()) continue;
            idSet.add(new SRS(id));
        }
        ArrayList<SRS> srsList = new ArrayList<SRS>(idSet);
        Collections.sort(srsList, new CodeComparator());
        return srsList;
    }

    private static class CodeComparator
    implements Comparator<SRS> {
        private CodeComparator() {
        }

        @Override
        public int compare(SRS srs1, SRS srs2) {
            String s1 = srs1.getCode();
            String s2 = srs2.getCode();
            Integer c1 = null;
            Integer c2 = null;
            try {
                c1 = Integer.parseInt(s1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                c2 = Integer.parseInt(s2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (c1 == null) {
                if (c2 == null) {
                    return s1.compareTo(s2);
                }
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            return c1 - c2;
        }
    }

    public static class SRS
    implements Serializable,
    Comparable<SRS> {
        private static final long serialVersionUID = -4155644876049747585L;
        private String code;
        private transient String description;

        public SRS(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            if (this.description == null) {
                String desc = "-";
                try {
                    String epsgcode = this.code;
                    if (!epsgcode.startsWith("urn:ogc:def:crs:EPSG::")) {
                        epsgcode = "EPSG:" + epsgcode;
                    }
                    desc = CRS.getAuthorityFactory((boolean)true).getDescriptionText(epsgcode).toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.description = desc;
            }
            return this.description;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SRS)) {
                return false;
            }
            return this.code.equals(((SRS)o).code);
        }

        public int hashCode() {
            return 17 * this.code.hashCode();
        }

        @Override
        public int compareTo(SRS o) {
            return this.code.compareTo(o.code);
        }
    }
}

