/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.UpDownPanel;
import wicketdnd.DragSource;
import wicketdnd.DropTarget;
import wicketdnd.Location;
import wicketdnd.Operation;
import wicketdnd.Transfer;
import wicketdnd.theme.WebTheme;

public abstract class ReorderableTablePanel<T>
extends GeoServerTablePanel<T> {
    private static final long serialVersionUID = -6732973402966999112L;
    private final List<T> items;
    static GeoServerDataProvider.Property<?> POSITION = new GeoServerDataProvider.PropertyPlaceholder("position");
    static GeoServerDataProvider.Property<?> RENDERING_ORDER = new GeoServerDataProvider.PropertyPlaceholder("order");

    public ReorderableTablePanel(String id, final Class<T> contentsClass, final List<T> items, IModel<List<GeoServerDataProvider.Property<T>>> properties) {
        super(id, new ReorderableDataProvider<T>(items, properties));
        this.items = items;
        this.setOutputMarkupId(true);
        this.setSortable(false);
        this.add(new Behavior[]{new WebTheme()});
        this.add(new Behavior[]{new DragSource(new Operation[]{Operation.MOVE}).drag("tr")});
        this.add(new Behavior[]{new DropTarget(new Operation[]{Operation.MOVE}){

            public void onDrop(AjaxRequestTarget target, Transfer transfer, Location location) {
                Object targetItem;
                if (location == null || !contentsClass.isInstance(location.getComponent().getDefaultModel().getObject())) {
                    return;
                }
                Object movedItem = transfer.getData();
                if (movedItem.equals(targetItem = location.getComponent().getDefaultModel().getObject())) {
                    return;
                }
                items.remove(movedItem);
                int idx = items.indexOf(targetItem);
                if (idx < items.size() - 1) {
                    items.add(idx, movedItem);
                } else {
                    items.add(movedItem);
                }
                target.add(new Component[]{ReorderableTablePanel.this});
            }
        }.dropCenter("tr")});
    }

    @Override
    protected void buildRowListView(final GeoServerDataProvider<T> dataProvider, Item<T> item, final IModel<T> itemModel) {
        LoadableDetachableModel propertyList = new LoadableDetachableModel<List<GeoServerDataProvider.Property<T>>>(){

            protected List<GeoServerDataProvider.Property<T>> load() {
                return dataProvider.getVisibleProperties();
            }
        };
        ListView items = new ListView<GeoServerDataProvider.Property<T>>("itemProperties", (IModel)propertyList){
            private static final long serialVersionUID = -7089826211241039856L;

            protected void populateItem(ListItem<GeoServerDataProvider.Property<T>> item) {
                GeoServerDataProvider.Property property = (GeoServerDataProvider.Property)item.getModelObject();
                Object component = null;
                if (property == POSITION) {
                    ParamResourceModel upTitle = new ParamResourceModel("moveToTop", (Component)this, new Object[0]);
                    ParamResourceModel downTitle = new ParamResourceModel("moveToBottom", (Component)this, new Object[0]);
                    component = new UpDownPanel<Object>("component", itemModel.getObject(), dataProvider.getItems(), (Component)ReorderableTablePanel.this, upTitle, downTitle);
                } else {
                    component = property == RENDERING_ORDER ? new Label("component", (IModel)new Model()) : ReorderableTablePanel.this.getComponentForProperty("component", itemModel, property);
                }
                if (component == null) {
                    component = new Label("component", property.getModel(itemModel));
                } else if (!"component".equals(component.getId())) {
                    throw new IllegalArgumentException("getComponentForProperty asked to build a component with id = 'component' for property '" + property.getName() + "', but got '" + component.getId() + "' instead");
                }
                item.add(new Component[]{component});
                ReorderableTablePanel.this.onPopulateItem(property, item);
            }
        };
        items.setReuseItems(true);
        item.add(new Component[]{items});
        this.setOutputMarkupId(true);
    }

    @Override
    protected void onPopulateItem(GeoServerDataProvider.Property<T> property, ListItem<GeoServerDataProvider.Property<T>> item) {
        if (property == RENDERING_ORDER) {
            Label label = (Label)item.iterator().next();
            OddEvenItem rowContainer = (OddEvenItem)item.getParent().getParent();
            label.setDefaultModel((IModel)new Model((Serializable)Integer.valueOf(rowContainer.getIndex() + 1)));
            item.add(new Behavior[]{new Behavior(){
                private static final long serialVersionUID = 8429550827543813897L;

                public void onComponentTag(Component component, ComponentTag tag) {
                    tag.put("style", (CharSequence)"width:1%");
                }
            }});
        }
    }

    public List<T> getItems() {
        return this.items;
    }

    static class ReorderableDataProvider<T>
    extends GeoServerDataProvider<T> {
        private static final long serialVersionUID = -5792726233183939109L;
        private List<T> items;
        private IModel<List<GeoServerDataProvider.Property<T>>> properties;

        public ReorderableDataProvider(List<T> items, final IModel<List<GeoServerDataProvider.Property<T>>> properties) {
            this.items = items;
            this.properties = new LoadableDetachableModel<List<GeoServerDataProvider.Property<T>>>(){

                protected List<GeoServerDataProvider.Property<T>> load() {
                    ArrayList result = new ArrayList((Collection)properties.getObject());
                    result.add(0, POSITION);
                    result.add(0, RENDERING_ORDER);
                    return result;
                }
            };
        }

        @Override
        protected List<GeoServerDataProvider.Property<T>> getProperties() {
            return (List)this.properties.getObject();
        }

        @Override
        protected List<T> getItems() {
            return this.items;
        }
    }
}

