/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public class PercentageTextField
extends TextField<Double> {
    private static final long serialVersionUID = -4589385113632745745L;
    private int maximumFractionDigits = 1;
    private IConverter<Double> percentConverter = new IConverter<Double>(){
        private static final long serialVersionUID = -8409029711658542273L;

        public String convertToString(Double value, Locale locale) {
            NumberFormat format = PercentageTextField.this.formatter(locale);
            return value == null ? null : format.format(value);
        }

        public Double convertToObject(String value, Locale locale) {
            Number parsed;
            if (value == null || value.trim().length() == 0) {
                return null;
            }
            if (!value.endsWith("%")) {
                value = value + "%";
            }
            NumberFormat format = PercentageTextField.this.formatter(locale);
            try {
                parsed = format.parse(value);
            }
            catch (ParseException e) {
                PercentageTextField.this.error((Serializable)((Object)e.getMessage()));
                return null;
            }
            return parsed.doubleValue();
        }
    };

    public PercentageTextField(String id) {
        super(id, Double.class);
    }

    public PercentageTextField(String id, IModel<Double> model) {
        super(id, model, Double.class);
    }

    private NumberFormat formatter(Locale locale) {
        NumberFormat format = NumberFormat.getPercentInstance(locale);
        format.setMaximumFractionDigits(this.maximumFractionDigits);
        return format;
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        this.maximumFractionDigits = maximumFractionDigits;
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (Double.class.isAssignableFrom(type)) {
            return this.percentConverter;
        }
        return super.getConverter(type);
    }
}

