/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.KeywordInfo;

public class KeywordsEditor
extends FormComponentPanel<List<KeywordInfo>> {
    private static final long serialVersionUID = 1L;
    ListMultipleChoice<KeywordInfo> choices;
    TextField<String> newKeyword;
    TextField<String> vocabTextField;
    DropDownChoice<String> langChoice;

    public KeywordsEditor(String id, IModel<List<KeywordInfo>> keywords) {
        super(id, keywords);
        this.choices = new ListMultipleChoice("keywords", (IModel)new Model(), new ArrayList((Collection)keywords.getObject()), (IChoiceRenderer)new ChoiceRenderer<KeywordInfo>(){
            private static final long serialVersionUID = 1L;

            public Object getDisplayValue(KeywordInfo kw) {
                StringBuffer sb = new StringBuffer(kw.getValue());
                if (kw.getLanguage() != null) {
                    sb.append(" (").append(kw.getLanguage()).append(")");
                }
                if (kw.getVocabulary() != null) {
                    sb.append(" [").append(kw.getVocabulary()).append("]");
                }
                return sb.toString();
            }
        });
        this.choices.setOutputMarkupId(true);
        this.add(new Component[]{this.choices});
        this.add(new Component[]{this.removeKeywordsButton()});
        this.newKeyword = new TextField("newKeyword", (IModel)new Model());
        this.newKeyword.setOutputMarkupId(true);
        this.add(new Component[]{this.newKeyword});
        this.langChoice = new DropDownChoice("lang", (IModel)new Model(), Arrays.asList(Locale.getISOLanguages()), (IChoiceRenderer)new ChoiceRenderer<String>(){
            private static final long serialVersionUID = 1L;

            public String getDisplayValue(String object) {
                return new Locale(object).getDisplayLanguage();
            }

            public String getIdValue(String object, int index) {
                return object;
            }
        });
        this.langChoice.setNullValid(true);
        this.langChoice.setOutputMarkupId(true);
        this.add(new Component[]{this.langChoice});
        this.vocabTextField = new TextField("vocab", (IModel)new Model());
        this.vocabTextField.setOutputMarkupId(true);
        this.add(new Component[]{this.vocabTextField});
        this.add(new Component[]{this.addKeywordsButton()});
    }

    private AjaxButton addKeywordsButton() {
        AjaxButton button = new AjaxButton("addKeyword"){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                String value = KeywordsEditor.this.newKeyword.getInput();
                String lang = KeywordsEditor.this.langChoice.getInput();
                String vocab = KeywordsEditor.this.vocabTextField.getInput();
                Keyword keyword = new Keyword(value);
                if (lang != null && !"".equals(lang.trim())) {
                    keyword.setLanguage(lang);
                }
                if (vocab != null && !"".equals(vocab.trim())) {
                    keyword.setVocabulary(vocab);
                }
                List choiceList = KeywordsEditor.this.choices.getChoices();
                choiceList.add(keyword);
                KeywordsEditor.this.choices.setChoices(choiceList);
                KeywordsEditor.this.langChoice.setModelObject(null);
                KeywordsEditor.this.langChoice.modelChanged();
                KeywordsEditor.this.vocabTextField.setModelObject(null);
                KeywordsEditor.this.vocabTextField.modelChanged();
                target.add(new Component[]{KeywordsEditor.this.newKeyword});
                target.add(new Component[]{KeywordsEditor.this.langChoice});
                target.add(new Component[]{KeywordsEditor.this.vocabTextField});
                target.add(new Component[]{KeywordsEditor.this.choices});
            }
        };
        button.setDefaultFormProcessing(false);
        return button;
    }

    private AjaxButton removeKeywordsButton() {
        AjaxButton button = new AjaxButton("removeKeywords"){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target, Form<?> form) {
                Collection selection = (Collection)KeywordsEditor.this.choices.getModelObject();
                List keywords = KeywordsEditor.this.choices.getChoices();
                for (KeywordInfo selected : selection) {
                    keywords.remove(selected);
                }
                KeywordsEditor.this.choices.setChoices(keywords);
                KeywordsEditor.this.choices.modelChanged();
                target.add(new Component[]{KeywordsEditor.this.choices});
            }
        };
        return button;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.updateFields();
    }

    private void updateFields() {
        this.choices.setChoices(this.getModel());
    }

    public void convertInput() {
        this.setConvertedInput(this.choices.getChoices());
    }
}

