/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class GeoServerDialog
extends Panel {
    ModalWindow window;
    Component userPanel;
    DialogDelegate delegate;

    public GeoServerDialog(String id) {
        super(id);
        Component[] componentArray = new Component[1];
        this.window = new ModalWindow("dialog");
        componentArray[0] = this.window;
        this.add(componentArray);
    }

    public void setTitle(IModel<String> title) {
        this.window.setTitle(title);
    }

    public String getHeightUnit() {
        return this.window.getHeightUnit();
    }

    public int getInitialHeight() {
        return this.window.getInitialHeight();
    }

    public int getInitialWidth() {
        return this.window.getInitialWidth();
    }

    public String getWidthUnit() {
        return this.window.getWidthUnit();
    }

    public void setHeightUnit(String heightUnit) {
        this.window.setHeightUnit(heightUnit);
    }

    public void setInitialHeight(int initialHeight) {
        this.window.setInitialHeight(initialHeight);
    }

    public void setInitialWidth(int initialWidth) {
        this.window.setInitialWidth(initialWidth);
    }

    public void setWidthUnit(String widthUnit) {
        this.window.setWidthUnit(widthUnit);
    }

    public int getMinimalHeight() {
        return this.window.getMinimalHeight();
    }

    public int getMinimalWidth() {
        return this.window.getMinimalWidth();
    }

    public void setMinimalHeight(int minimalHeight) {
        this.window.setMinimalHeight(minimalHeight);
    }

    public void setMinimalWidth(int minimalWidth) {
        this.window.setMinimalWidth(minimalWidth);
    }

    public void showOkCancel(AjaxRequestTarget target, DialogDelegate delegate) {
        this.userPanel = delegate.getContents("userPanel");
        this.window.setContent((Component)new ContentsPage(this.userPanel));
        this.window.setCloseButtonCallback((ModalWindow.CloseButtonCallback & Serializable)target12 -> delegate.onCancel(target12));
        this.window.setWindowClosedCallback((ModalWindow.WindowClosedCallback & Serializable)target1 -> delegate.onClose(target1));
        this.delegate = delegate;
        this.window.show((IPartialPageRequestHandler)target);
    }

    @SafeVarargs
    public final void showInfo(AjaxRequestTarget target, IModel<String> heading, IModel<String> ... messages) {
        this.window.setPageCreator((ModalWindow.PageCreator & Serializable)() -> new InfoPage(heading, messages));
        this.window.show((IPartialPageRequestHandler)target);
    }

    public void close(AjaxRequestTarget target) {
        this.window.close((IPartialPageRequestHandler)target);
        this.delegate = null;
        this.userPanel = null;
    }

    public void submit(AjaxRequestTarget target) {
        this.submit(target, this.userPanel);
    }

    void submit(AjaxRequestTarget target, Component contents) {
        if (this.delegate.onSubmit(target, contents)) {
            this.close(target);
        }
    }

    AjaxSubmitLink sumbitLink(Component contents) {
        AjaxSubmitLink link = new AjaxSubmitLink("submit"){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                GeoServerDialog.this.submit(target, (Component)this.getDefaultModelObject());
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                GeoServerDialog.this.delegate.onError(target, form);
            }
        };
        link.setDefaultModel((IModel)new Model((Serializable)contents));
        return link;
    }

    Component cancelLink() {
        return new AjaxLink<Void>("cancel"){

            public void onClick(AjaxRequestTarget target) {
                if (GeoServerDialog.this.delegate.onCancel(target)) {
                    GeoServerDialog.this.window.close((IPartialPageRequestHandler)target);
                    GeoServerDialog.this.delegate = null;
                }
            }
        };
    }

    public void setResizable(boolean resizable) {
        this.window.setResizable(resizable);
    }

    public static abstract class DialogDelegate
    implements Serializable {
        protected abstract Component getContents(String var1);

        public void onError(AjaxRequestTarget target, Form<?> form) {
            form.getPage().visitChildren(IFeedback.class, (component, visit) -> {
                if (component.getOutputMarkupId()) {
                    target.add(new Component[]{component});
                }
            });
        }

        public void onClose(AjaxRequestTarget target) {
        }

        protected abstract boolean onSubmit(AjaxRequestTarget var1, Component var2);

        protected boolean onCancel(AjaxRequestTarget target) {
            return true;
        }
    }

    protected class InfoPage
    extends WebPage {
        @SafeVarargs
        public InfoPage(IModel<String> title, IModel<String> ... messages) {
            this.add(new Component[]{new Label("title", title)});
            this.add(new Component[]{new ListView<IModel<String>>("messages", Arrays.asList(messages)){

                protected void populateItem(ListItem<IModel<String>> item) {
                    item.add(new Component[]{new Label("message", (IModel)item.getModelObject()).setEscapeModelStrings(false)});
                }
            }});
        }
    }

    protected class ContentsPage
    extends Panel {
        public ContentsPage(Component contents) {
            super("content");
            Form form = new Form("form");
            this.add(new Component[]{form});
            form.add(new Component[]{contents});
            AjaxSubmitLink submit = GeoServerDialog.this.sumbitLink(contents);
            form.add(new Component[]{submit});
            form.add(new Component[]{GeoServerDialog.this.cancelLink()});
            form.setDefaultButton((IFormSubmittingComponent)submit);
        }
    }
}

