/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.wicket.util.convert.converter.DoubleConverter;

public class DecimalConverter
extends DoubleConverter {
    int maximumFractionDigits = 16;

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public void setMaximumFractionDigits(int maximumFractionDigits) {
        this.maximumFractionDigits = maximumFractionDigits;
    }

    public Double convertToObject(String value, Locale locale) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        NumberFormat format = this.getNumberFormat(locale);
        DecimalFormatSymbols symbols = ((DecimalFormat)format).getDecimalFormatSymbols();
        if (value.equals(symbols.getNaN())) {
            return Double.NaN;
        }
        if (value.equals(symbols.getInfinity())) {
            return Double.POSITIVE_INFINITY;
        }
        if (value.equals("-" + symbols.getInfinity())) {
            return Double.NEGATIVE_INFINITY;
        }
        return super.convertToObject(value, locale);
    }

    protected NumberFormat newNumberFormat(Locale locale) {
        NumberFormat format = DecimalFormat.getInstance();
        format.setMaximumFractionDigits(16);
        return format;
    }
}

