/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.geotools.util.logging.Logging;

public class DateTimeLabel
extends Panel {
    static final Logger LOGGER = Logging.getLogger(DateTimeLabel.class);
    private static final long serialVersionUID = -665729388275555894L;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");

    public DateTimeLabel(String id, IModel<?> model) {
        super(id, model);
        String formattedDateString = "";
        String formattedTimeString = "";
        if (model.getObject() != null) {
            Object val = model.getObject();
            if (val instanceof Date) {
                Date date = (Date)val;
                formattedDateString = this.dateFormat.format(date);
                formattedTimeString = this.timeFormat.format(date);
            } else {
                LOGGER.severe("expected instance of java.util.Date as Model object in DateTimeLabel");
            }
        }
        Label dateLabel = new Label("dateTimelabel", (Serializable)((Object)formattedDateString));
        dateLabel.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)formattedTimeString))});
        this.add(new Component[]{dateLabel});
    }
}

