/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.wicket;

import org.apache.wicket.model.IModel;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSModel
implements IModel<CoordinateReferenceSystem> {
    transient CoordinateReferenceSystem crs;
    String wkt;

    public CRSModel(CoordinateReferenceSystem crs) {
        this.setObject(crs);
    }

    public CoordinateReferenceSystem getObject() {
        if (this.crs != null) {
            return this.crs;
        }
        if (this.wkt == null) {
            return null;
        }
        try {
            this.crs = CRS.parseWKT((String)this.wkt);
            return this.crs;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setObject(CoordinateReferenceSystem object) {
        this.crs = object;
        this.wkt = this.crs != null ? this.crs.toWKT() : null;
    }

    public void detach() {
        this.crs = null;
    }
}

