/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.system.status;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ConsoleInfoUtils {
    private ConsoleInfoUtils() {
    }

    static String getThreadsInfo(boolean lockedMonitors, boolean lockedSynchronizers) {
        return Arrays.stream(ManagementFactory.getThreadMXBean().dumpAllThreads(lockedMonitors, lockedSynchronizers)).map(ThreadInfo::toString).collect(Collectors.joining("\n"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getHistoMemoryDump() {
        try {
            int pid = Optional.ofNullable(ManagementFactory.getRuntimeMXBean().getName()).map(processName -> Arrays.asList(processName.split("@"))).filter(elements -> !elements.isEmpty()).map(maybePid -> Integer.valueOf((String)maybePid.get(0))).orElseThrow(() -> new IOException("Problem on getting the PID for the java process"));
            Process jmapProcess = Runtime.getRuntime().exec(String.format("jmap -histo:live %d", pid));
            try (BufferedReader stdConsole = new BufferedReader(new InputStreamReader(jmapProcess.getInputStream()));){
                String buffer;
                StringBuilder accumulator = new StringBuilder();
                while ((buffer = stdConsole.readLine()) != null) {
                    accumulator.append(buffer).append("\n");
                }
                String string = accumulator.toString();
                return string;
            }
        }
        catch (IOException e) {
            return String.format("Error reading the histo memory dump with the jmap command. Exception: %s", e.getMessage());
        }
    }
}

