/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.publish;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.theme.DefaultTheme;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ServiceResourceProvider;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.publish.PublishedConfigurationPanel;

public class ServiceLayerConfigurationPanel
extends PublishedConfigurationPanel<LayerInfo> {
    private static final long serialVersionUID = 1L;
    private WebMarkupContainer serviceSelectionContainer;
    private Palette<String> servicesMultiSelector;

    public ServiceLayerConfigurationPanel(String id, IModel<LayerInfo> layerModel) {
        super(id, layerModel);
        AjaxCheckBox configEnabledCheck = new AjaxCheckBox("configEnabled", (IModel)new PropertyModel(layerModel, "resource.serviceConfiguration")){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                ServiceLayerConfigurationPanel.this.servicesMultiSelector.setVisible(((Boolean)this.getModelObject()).booleanValue());
                target.add(new Component[]{ServiceLayerConfigurationPanel.this.serviceSelectionContainer});
            }
        };
        this.add(new Component[]{configEnabledCheck});
        PropertyModel dsModel = new PropertyModel(layerModel, "resource.disabledServices");
        ChoiceRenderer<String> renderer = new ChoiceRenderer<String>(){

            public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                return id;
            }

            public Object getDisplayValue(String object) {
                if (object == null) {
                    return null;
                }
                return super.getDisplayValue((Object)object);
            }

            public String getIdValue(String object, int index) {
                return object;
            }
        };
        this.servicesMultiSelector = new Palette<String>("servicesSelection", (IModel)dsModel, this.servicesVotedModel(((LayerInfo)layerModel.getObject()).getResource()), (IChoiceRenderer)renderer, 10, false){
            private static final long serialVersionUID = 1L;

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("DisabledServicesPalette.selectedHeader"));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("DisabledServicesPalette.availableHeader"));
            }
        };
        this.servicesMultiSelector.add(new Behavior[]{new DefaultTheme()});
        this.servicesMultiSelector.setVisible(((LayerInfo)layerModel.getObject()).getResource().isServiceConfiguration());
        this.serviceSelectionContainer = new WebMarkupContainer("serviceSelectionContainer");
        this.serviceSelectionContainer.setOutputMarkupPlaceholderTag(true);
        this.add(new Component[]{this.serviceSelectionContainer});
        this.serviceSelectionContainer.add(new Component[]{this.servicesMultiSelector});
    }

    protected ServiceResourceProvider getServiceResourceUtil() {
        return GeoServerApplication.get().getBeanOfType(ServiceResourceProvider.class);
    }

    private LoadableDetachableModel<List<String>> servicesVotedModel(final ResourceInfo resource) {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 1L;

            protected List<String> load() {
                return ServiceLayerConfigurationPanel.this.getServiceResourceUtil().getServicesForResource(resource);
            }
        };
    }
}

