/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.data.workspace.WorkspaceDetachableModel;
import org.geoserver.web.wicket.GeoServerDataProvider;

public class WorkspaceProvider
extends GeoServerDataProvider<WorkspaceInfo> {
    private static final long serialVersionUID = -2464073552094977958L;
    public static GeoServerDataProvider.Property<WorkspaceInfo> NAME = new GeoServerDataProvider.BeanProperty<WorkspaceInfo>("name", "name");
    public static GeoServerDataProvider.Property<WorkspaceInfo> DEFAULT = new GeoServerDataProvider.AbstractProperty<WorkspaceInfo>("default"){
        private static final long serialVersionUID = 7732697329315316826L;

        @Override
        public Object getPropertyValue(WorkspaceInfo item) {
            Catalog catalog = GeoServerApplication.get().getCatalog();
            WorkspaceInfo defaultWorkspace = catalog.getDefaultWorkspace();
            return defaultWorkspace != null && defaultWorkspace.equals(item);
        }
    };
    public static GeoServerDataProvider.Property<WorkspaceInfo> ISOLATED = new GeoServerDataProvider.BeanProperty<WorkspaceInfo>("isolated", "isolated");
    static List<GeoServerDataProvider.Property<WorkspaceInfo>> PROPERTIES = Arrays.asList(NAME, DEFAULT, ISOLATED);
    public static final GeoServerDataProvider.Property<WorkspaceInfo> MODIFIED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<WorkspaceInfo>("datemodfied", "dateModified");
    public static final GeoServerDataProvider.Property<WorkspaceInfo> CREATED_TIMESTAMP = new GeoServerDataProvider.BeanProperty<WorkspaceInfo>("datecreated", "dateCreated");

    public WorkspaceProvider() {
        this.setSort(NAME.getName(), SortOrder.ASCENDING);
    }

    @Override
    protected List<WorkspaceInfo> getItems() {
        return this.getCatalog().getWorkspaces();
    }

    @Override
    protected List<GeoServerDataProvider.Property<WorkspaceInfo>> getProperties() {
        List<GeoServerDataProvider.Property<WorkspaceInfo>> modifiedPropertiesList = PROPERTIES.stream().map(c -> c).collect(Collectors.toList());
        if (GeoServerApplication.get().getGeoServer().getSettings().isShowCreatedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(CREATED_TIMESTAMP);
        }
        if (GeoServerApplication.get().getGeoServer().getSettings().isShowModifiedTimeColumnsInAdminList()) {
            modifiedPropertiesList.add(MODIFIED_TIMESTAMP);
        }
        return modifiedPropertiesList;
    }

    @Override
    protected IModel<WorkspaceInfo> newModel(WorkspaceInfo object) {
        return new WorkspaceDetachableModel(object);
    }
}

