/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.workspace;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.CatalogIconFactory;
import org.geoserver.web.ComponentAuthorizer;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.data.SelectionRemovalLink;
import org.geoserver.web.data.workspace.WorkspaceEditPage;
import org.geoserver.web.data.workspace.WorkspaceNewPage;
import org.geoserver.web.data.workspace.WorkspaceProvider;
import org.geoserver.web.wicket.DateTimeLabel;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.SimpleBookmarkableLink;

public class WorkspacePage
extends GeoServerSecuredPage {
    private static final long serialVersionUID = 3084639304127909774L;
    WorkspaceProvider provider = new WorkspaceProvider();
    GeoServerTablePanel<WorkspaceInfo> table;
    GeoServerDialog dialog;
    SelectionRemovalLink removal;

    public WorkspacePage() {
        Component[] componentArray = new Component[1];
        this.table = new GeoServerTablePanel<WorkspaceInfo>("table", (GeoServerDataProvider)this.provider, true){
            private static final long serialVersionUID = 8028081894753417294L;

            @Override
            protected Component getComponentForProperty(String id, IModel<WorkspaceInfo> itemModel, GeoServerDataProvider.Property<WorkspaceInfo> property) {
                if (property == WorkspaceProvider.NAME) {
                    return WorkspacePage.this.workspaceLink(id, itemModel);
                }
                if (property == WorkspaceProvider.DEFAULT) {
                    if (WorkspacePage.this.getCatalog().getDefaultWorkspace().equals(itemModel.getObject())) {
                        return new Icon(id, CatalogIconFactory.ENABLED_ICON);
                    }
                    return new Label(id, (Serializable)((Object)""));
                }
                if (property == WorkspaceProvider.ISOLATED) {
                    if (((WorkspaceInfo)itemModel.getObject()).isIsolated()) {
                        return new Icon(id, CatalogIconFactory.ENABLED_ICON);
                    }
                    return new Label(id, (Serializable)((Object)""));
                }
                if (property == WorkspaceProvider.MODIFIED_TIMESTAMP) {
                    return new DateTimeLabel(id, WorkspaceProvider.MODIFIED_TIMESTAMP.getModel(itemModel));
                }
                if (property == WorkspaceProvider.CREATED_TIMESTAMP) {
                    return new DateTimeLabel(id, WorkspaceProvider.CREATED_TIMESTAMP.getModel(itemModel));
                }
                throw new IllegalArgumentException("No such property " + property.getName());
            }

            @Override
            protected void onSelectionUpdate(AjaxRequestTarget target) {
                WorkspacePage.this.removal.setEnabled(WorkspacePage.this.table.getSelection().size() > 0);
                target.add(new Component[]{WorkspacePage.this.removal});
            }
        };
        componentArray[0] = this.table;
        this.add(componentArray);
        this.table.setOutputMarkupId(true);
        Component[] componentArray2 = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray2[0] = this.dialog;
        this.add(componentArray2);
        this.setHeaderPanel(this.headerPanel());
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new BookmarkablePageLink("addNew", WorkspaceNewPage.class)});
        Component[] componentArray = new Component[1];
        this.removal = new SelectionRemovalLink("removeSelected", this.table, this.dialog);
        componentArray[0] = this.removal;
        header.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        header.setEnabled(this.isAuthenticatedAsAdmin());
        return header;
    }

    Component workspaceLink(String id, IModel<WorkspaceInfo> itemModel) {
        IModel<?> nameModel = WorkspaceProvider.NAME.getModel(itemModel);
        return new SimpleBookmarkableLink(id, WorkspaceEditPage.class, nameModel, "name", (String)nameModel.getObject());
    }

    @Override
    protected ComponentAuthorizer getPageAuthorizer() {
        return ComponentAuthorizer.WORKSPACE_ADMIN;
    }
}

