/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.data.store.panel;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.model.IModel;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geotools.util.logging.Logging;

public class FileModel
implements IModel<String> {
    private static final long serialVersionUID = 3911203737278340528L;
    static final Logger LOGGER = Logging.getLogger(FileModel.class);
    IModel<String> delegate;
    File rootDir;

    public FileModel(IModel<String> delegate) {
        this(delegate, ((GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class)).getBaseDirectory());
    }

    public FileModel(IModel<String> delegate, File rootDir) {
        this.delegate = delegate;
        this.rootDir = rootDir;
    }

    private boolean isSubfile(File root, File selection) {
        if (selection == null || "".equals(selection.getPath())) {
            return false;
        }
        if (selection.equals(root)) {
            return true;
        }
        return this.isSubfile(root, selection.getParentFile());
    }

    public String getObject() {
        Object obj = this.delegate.getObject();
        if (obj instanceof URL) {
            URL url = (URL)obj;
            return url.toExternalForm();
        }
        return (String)obj;
    }

    public void detach() {
    }

    public void setObject(String location) {
        if (location != null) {
            File file;
            File dataDirectory = this.canonicalize(this.rootDir);
            if (this.isSubfile(dataDirectory, file = this.canonicalize(new File(location)))) {
                String path = null;
                for (File curr = file; curr != null && !curr.equals(dataDirectory); curr = curr.getParentFile()) {
                    path = path == null ? curr.getName() : curr.getName() + "/" + path;
                }
                location = "file:" + path;
            } else {
                File dataFile = Files.url((File)this.rootDir, (String)location);
                if (dataFile == null || dataFile.equals(file)) {
                    location = "file://" + file.getAbsolutePath();
                }
            }
        }
        this.delegate.setObject((Object)location);
    }

    File canonicalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Could not convert " + file + " into canonical form", e);
            return file;
        }
    }
}

